/*
 * Decompiled with CFR 0.152.
 */
package com.whatsapp.client;

import com.whatsapp.client.ChatState;
import com.whatsapp.client.FunXMPP;

public class UsageStats {
    public static final int MEDIA = 0;
    public static final int MESSAGE_SERVICE = 1;
    public static final int COLD_SYNC = 2;
    public static final long LAST_RESET_NEVER = Long.MIN_VALUE;
    public static final long SAVE_INTERVAL = 1800000L;
    long rx_text_msgs = 0L;
    long tx_text_msgs = 0L;
    long rx_media_msgs = 0L;
    long tx_media_msgs = 0L;
    long rx_offline_msgs = 0L;
    long rx_offline_delay = 0L;
    long rx_media_bytes = 0L;
    long tx_media_bytes = 0L;
    long rx_message_service_bytes = 0L;
    long tx_message_service_bytes = 0L;
    long rx_cold_sync_bytes = 0L;
    long tx_cold_sync_bytes = 0L;
    final long last_reset;
    long last_save;

    public UsageStats() {
        this(false);
    }

    public UsageStats(boolean isReset) {
        this.last_reset = isReset ? System.currentTimeMillis() : Long.MIN_VALUE;
    }

    public static void reset() {
        UsageStats newStats;
        ChatState.getState()._usageStats = newStats = new UsageStats(true);
    }

    private void saveCheck() {
        if (System.currentTimeMillis() - this.last_save > 1800000L) {
            new Thread(new Runnable(){

                public void run() {
                }
            }).start();
        }
    }

    public synchronized void recordMessageReceived(FunXMPP.FMessage message) {
        long delay = System.currentTimeMillis() - message.timestamp;
        if (message.offline) {
            this.rx_offline_delay = (this.rx_offline_delay * this.rx_offline_msgs + delay) / ++this.rx_offline_msgs;
        }
        if (message.media_wa_type == 0) {
            ++this.rx_text_msgs;
        } else {
            ++this.rx_media_msgs;
        }
        this.saveCheck();
    }

    public synchronized void recordMessageSent(FunXMPP.FMessage message) {
        if (message.media_wa_type == 0) {
            ++this.tx_text_msgs;
        } else {
            ++this.tx_media_msgs;
        }
        this.saveCheck();
    }

    public synchronized void recordBytesReceived(long bytes, int category) {
        switch (category) {
            case 0: {
                this.rx_media_bytes += bytes;
                break;
            }
            case 2: {
                this.rx_cold_sync_bytes += bytes;
                break;
            }
            case 1: {
                this.rx_message_service_bytes += bytes;
            }
        }
    }

    public synchronized void recordBytesSent(long bytes, int category) {
        switch (category) {
            case 0: {
                this.tx_media_bytes += bytes;
                break;
            }
            case 2: {
                this.tx_cold_sync_bytes += bytes;
                break;
            }
            case 1: {
                this.tx_message_service_bytes += bytes;
            }
        }
    }
}

