/*
 * Decompiled with CFR 0.152.
 */
package com.whatsapp.client;

import com.whatsapp.api.ui.Rect;
import com.whatsapp.api.ui.UIField;
import javax.microedition.lcdui.Font;
import javax.microedition.lcdui.Graphics;

public class TabRow
extends UIField {
    private static final int ARROW_WIDTH = 6;
    private static final int ARROW_HEIGHT = 12;
    private static final int ARROW_MARGIN_RIGHT = 2;
    private static final int ARROW_MARGIN_BOTTOM = 2;
    private static final int PADDING_LEFT = 27;
    private static final int PADDING_RIGHT = 9;
    private static final int[] TAB_WIDTH_WEIGHT = new int[]{75, 50, 5};
    private static final int[] TAB_MARGIN_TOP = new int[]{2, 4, 6};
    private static final int TAB_PADDING_BOTTOM = 3;
    private static final int TAB_PADDING_LEFT = 3;
    private static final int TAB_PADDING_RIGHT = 0;
    private static final int TAB_TEXT_BASELINE_OFFSET = -6;
    private static final int BORDER_WIDTH = 1;
    private static final Font FONT = Font.getFont((int)0, (int)0, (int)8);
    private static final int FONT_EXTRA_HEIGHT = 2;
    private static final int EXTRA_HEIGHT = 4;
    private static final int HEIGHT = FONT.getHeight() + 2 + TAB_MARGIN_TOP[0] + 4 + 1;
    private static final int COLOR_INACTIVE_TAB = 0xD8D8D8;
    public static final int COLOR_ACTIVE_TAB = 0xF8FCF8;
    private static final int COLOR_HIGHLIGHTED_TAB = 15259768;
    private static final int COLOR_TAB_TEXT = 0;
    private static final int COLOR_TAB_BORDER = 0x606460;
    private static final int COLOR_BACKGROUND = 9484496;
    private static final int COLOR_ARROWS = 0;
    private static final int COLOR_BORDER = 0x606460;
    public static final int MAX_VISIBLE_TABS = 5;
    private final boolean[] highlighted;
    private int leftHorizonHighlights;
    private int rightHorizonHighlights;
    public final String[] tabNames;
    public final int tabCount;
    public final int visibleTabCount;
    private int centerTabVisibleIdx;
    public final boolean wrap;
    public final boolean staticTabs;
    private int centerTabIdx;

    public TabRow(TabRow other, int centerTabIdx) {
        this(other.tabNames, centerTabIdx, other.wrap, other.staticTabs, other.highlighted);
    }

    public TabRow(String[] tabNames, int centerTabIdx, boolean wrap, boolean staticTabs) {
        this(tabNames, centerTabIdx, wrap, staticTabs, new boolean[tabNames.length]);
    }

    public TabRow(String[] tabNames, int centerTabIdx, boolean wrap, boolean staticTabs, boolean[] highlighted) {
        super(0L);
        this.tabNames = tabNames;
        this.tabCount = tabNames.length;
        this.visibleTabCount = Math.min(5, this.tabCount);
        this.staticTabs = staticTabs && this.visibleTabCount >= this.tabCount && this.tabCount <= TAB_WIDTH_WEIGHT.length;
        this.wrap = wrap || !this.staticTabs;
        this.highlighted = highlighted;
        this.setCenter(centerTabIdx);
    }

    public void setName(int tabIdx, String name) {
        this.tabNames[tabIdx] = name;
    }

    public int getCenter() {
        return this.centerTabIdx;
    }

    public int adjustCenter(int off) {
        if (this.wrap) {
            this.setCenter((this.centerTabIdx + off + this.tabCount) % this.tabCount);
        } else {
            this.setCenter(Math.max(0, Math.min(this.tabCount - 1, this.centerTabIdx + off)));
        }
        return this.centerTabIdx;
    }

    public void setCenter(int centerTabIdx) {
        this.centerTabIdx = centerTabIdx;
        this.centerTabVisibleIdx = !this.staticTabs ? (this.visibleTabCount - 1) / 2 : centerTabIdx;
        this.leftHorizonHighlights = 0;
        this.rightHorizonHighlights = 0;
        for (int tabIdx = 0; tabIdx < this.tabCount; ++tabIdx) {
            if (!this.highlighted[tabIdx]) continue;
            this.highlighted[tabIdx] = false;
            this.setHighlight(tabIdx, true);
        }
    }

    private int visibleToTabIdx(int visibleIdx) {
        return (this.centerTabIdx - (this.centerTabVisibleIdx - visibleIdx) + this.tabCount) % this.tabCount;
    }

    public void setHighlight(int tabIdx, boolean highlight) {
        if (this.highlighted[tabIdx] == highlight) {
            return;
        }
        this.highlighted[tabIdx] = highlight;
        int off = (tabIdx - this.centerTabIdx + this.tabCount * 3 / 2) % this.tabCount - this.tabCount / 2;
        if (off < -this.visibleTabCount / 2) {
            this.leftHorizonHighlights = highlight ? ++this.leftHorizonHighlights : --this.leftHorizonHighlights;
        } else if (off > this.visibleTabCount / 2) {
            this.rightHorizonHighlights = highlight ? ++this.rightHorizonHighlights : --this.rightHorizonHighlights;
        }
    }

    public void layout(int width, int height) {
        this.setExtent(width, HEIGHT);
    }

    private void drawTab(Graphics g, String text, int x, int y, int width, int height, int textBaseline, boolean selected, boolean highlighted) {
        Rect clip = new Rect(g.getClipX(), g.getClipY(), g.getClipWidth(), g.getClipHeight());
        g.clipRect(x, y, width, height);
        g.setColor(selected ? 0xF8FCF8 : (highlighted ? 15259768 : 0xD8D8D8));
        g.fillRect(x, y, width, height);
        g.setColor(0x606460);
        g.drawRect(x, y, width - 1, height - 1);
        g.clipRect(x += 3, y, width -= 3, height);
        if (text != null) {
            g.setColor(0);
            int stringWidth = FONT.stringWidth(text);
            int stringX = x + Math.max(0, (width - stringWidth) / 2);
            g.drawString(text, stringX, textBaseline, 68);
        }
        g.setClip(clip.x, clip.y, clip.width, clip.height);
    }

    public void paint(Graphics g, int x, int y, int width, int height) {
        boolean focused = this.hasFocus();
        Rect clip = new Rect(g.getClipX(), g.getClipY(), g.getClipWidth(), g.getClipHeight());
        g.clipRect(x, y, width, height);
        width = this.getWidth();
        height = this.getHeight();
        g.setColor(focused ? 0xF8FCF8 : 9484496);
        g.fillRect(x, y, width, height);
        g.setColor(0x606460);
        g.fillRect(x, y + height - 1, width, 1);
        if (focused && this.tabCount >= 2) {
            int arrowBottom = y + height - 2;
            int arrowTop = arrowBottom - 12;
            int arrowCenter = arrowTop + (arrowBottom - arrowTop) / 2;
            int[] arrowOffset = new int[]{-2, -8};
            int[] arrowRightX = new int[]{x + 27, x + width};
            g.setColor(0);
            for (int i = 0; i <= 1; ++i) {
                int right = i;
                int left = 1 - i;
                if (!this.wrap && (this.centerTabIdx == 0 && i == 0 || this.centerTabIdx == this.tabCount - 1 && i == 1)) continue;
                g.fillTriangle(arrowRightX[i] + arrowOffset[right], arrowTop, arrowRightX[i] + arrowOffset[right], arrowBottom, arrowRightX[i] + arrowOffset[left], arrowCenter);
            }
        }
        x += 27;
        width -= 36;
        int totalTabWidthWeight = 0;
        for (int i = 0; i < this.visibleTabCount; ++i) {
            int dist = Math.abs(this.centerTabVisibleIdx - i);
            totalTabWidthWeight += TAB_WIDTH_WEIGHT[dist];
        }
        int usedWidth = 1;
        for (int i = 0; i < this.visibleTabCount; ++i) {
            int dist = Math.abs(this.centerTabVisibleIdx - i);
            usedWidth += width * TAB_WIDTH_WEIGHT[dist] / totalTabWidthWeight - 1;
        }
        g.setFont(FONT);
        int tabX = x;
        int unusedWidth = width - usedWidth;
        for (int visibleTabIdx = 0; visibleTabIdx < this.visibleTabCount; ++visibleTabIdx) {
            boolean highlight;
            int tabIdx = this.visibleToTabIdx(visibleTabIdx);
            int dist = Math.abs(this.centerTabVisibleIdx - visibleTabIdx);
            int tabY = y + TAB_MARGIN_TOP[dist];
            int tabWidth = width * TAB_WIDTH_WEIGHT[dist] / totalTabWidthWeight;
            int tabHeight = height - TAB_MARGIN_TOP[dist] + Math.max(0, 1 - dist);
            int tabTextBaseline = y + height + -6;
            boolean bl = highlight = this.highlighted[tabIdx] || visibleTabIdx == 0 && this.leftHorizonHighlights > 0 || visibleTabIdx == this.visibleTabCount - 1 && this.rightHorizonHighlights > 0;
            if (dist == 0) {
                tabWidth += unusedWidth;
            }
            this.drawTab(g, dist < 2 ? this.tabNames[tabIdx] : null, tabX, tabY, tabWidth, tabHeight, tabTextBaseline, dist == 0, highlight);
            tabX += tabWidth - 1;
        }
        g.setClip(clip.x, clip.y, clip.width, clip.height);
    }
}

