/*
 * Decompiled with CFR 0.152.
 */
package com.whatsapp.client;

import com.whatsapp.api.ui.TextUtils;
import com.whatsapp.api.ui.UIField;
import com.whatsapp.api.ui.UIManager;
import javax.microedition.lcdui.Font;
import javax.microedition.lcdui.Graphics;

public class ShadedLabelField
extends UIManager {
    private static final int H_PADDING = 2;
    private static final int V_PADDING = 0;
    String _text;
    Font _font;
    int _hPadding = 2;
    int _vPadding = 0;
    private static int START_FACTOR = 211;
    private static int END_FACTOR = 128;

    public ShadedLabelField(String text, Font font) {
        super(0L);
        this._text = text;
        this._font = font;
    }

    public void setPadding(int hPadding, int vPadding) {
        this._hPadding = hPadding;
        this._vPadding = vPadding;
    }

    public void setText(String t) {
        this._text = t;
    }

    public void paint(Graphics g, int x, int y, int width, int height) {
        int gradations = Math.min(height, 6);
        int extraGain = height % gradations;
        int slice = (END_FACTOR - START_FACTOR) / gradations;
        int heightSlice = height / gradations;
        int runningOffset = 0;
        for (int i = 0; i < gradations; ++i) {
            int curFactor = START_FACTOR + slice * i;
            int newColor = curFactor * 256 * 256 + curFactor * 256 + curFactor;
            g.setColor(newColor);
            int curSlice = heightSlice;
            if (i < extraGain) {
                ++curSlice;
            }
            g.fillRect(x, y + runningOffset, width, curSlice);
            runningOffset += curSlice;
        }
        g.setColor(0);
        g.setFont(this._font);
        int availWidth = width - this._hPadding;
        if (this.getNumChildren() > 0) {
            UIField timeField = this.getChildAt(0);
            availWidth -= timeField.getWidth() + timeField.getMarginLeft() + timeField.getMarginRight();
        }
        TextUtils.drawStringElided(g, this._text, x + this._hPadding, y + this._vPadding, availWidth);
        super.paint(g, x, y, width, height);
    }

    public void sublayout(int width, int height) {
        int reqHeight = this._font.getHeight() + 2 * this._vPadding;
        if (this.getNumChildren() > 0) {
            UIField timeField = this.getChildAt(0);
            timeField.layout(width / 2, reqHeight);
            int vdiff = reqHeight - timeField.getHeight();
            int vadjust = Math.max(vdiff / 2, timeField.getMarginTop());
            timeField.setManagerPosition(width - (timeField.getMarginRight() + timeField.getWidth()), vadjust);
            reqHeight = Math.max(reqHeight, timeField.getHeight() + timeField.getMarginRight() + timeField.getMarginBottom());
        }
        this.setExtent(width, reqHeight);
    }
}

