/*
 * Decompiled with CFR 0.152.
 */
package com.whatsapp.client;

import com.whatsapp.api.util.Utilities;
import com.whatsapp.client.Constants;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.EOFException;
import java.io.IOException;
import java.util.Vector;
import javax.microedition.rms.RecordEnumeration;
import javax.microedition.rms.RecordStore;
import javax.microedition.rms.RecordStoreException;

public class Settings {
    public static final int CHAT_NAME = 0;
    public static final int ROAM = 1;
    public static final int PHONE_NUMBER = 2;
    public static final int COUNTRY_CODE = 3;
    public static final int PHONE_REG_STEP = 4;
    public static final int CHAT_USER_ID = 5;
    public static final int DID_FIRST_SYNC = 6;
    public static final int INSTALL_DATE = 7;
    public static final int LAST_VERSION_RUN_AS = 8;
    public static final int EXPIRED = 9;
    public static final int CRASH_UPLOAD_DATE = 10;
    public static final int WHATSAPP_STATUS = 11;
    public static final int LAST_IMSI_VERIFIED = 12;
    public static final int GROUP_MAX_PARTICIPANTS = 13;
    public static final int GROUP_MAX_SUBJECT = 14;
    public static final int GROUP_MAX_GROUPS = 15;
    private static final int STRING = 0;
    private static final int INTEGER = 1;
    private static final int BOOLEAN = 2;
    private static final int LONG = 3;
    private static final Vector listeners = new Vector();
    private static final Setting[] settings = new Setting[]{new Setting(0, Constants.STRING_EMPTY_STRING), new Setting(1, new Integer(1)), new Setting(0, null), new Setting(1, new Integer(-1)), new Setting(1, new Integer(0)), new Setting(0, null), new Setting(2, Boolean.FALSE), new Setting(3, new Long(0L)), new Setting(0, null), new Setting(2, Boolean.FALSE), new Setting(3, new Long(0L)), new Setting(0, Constants.STRING_EMPTY_STRING), new Setting(0, null), new Setting(1, new Integer(10)), new Setting(1, new Integer(25)), new Setting(1, new Integer(10))};
    private static final String RMS_NAME = "Settings";
    private static boolean cache_built = false;
    private static int last_version;
    private static int version;

    public static void addListener(Listener listener) {
        listeners.removeElement(listener);
        listeners.addElement(listener);
    }

    public static void removeListener(Listener listener) {
        listeners.removeElement(listener);
    }

    private static void notifySettingChanged(int setting, boolean localOrigin) {
        if (cache_built) {
            for (int listener = 0; listener < listeners.size(); ++listener) {
                ((Listener)listeners.elementAt(listener)).onSettingChanged(setting, localOrigin);
            }
        }
    }

    public static byte[] sendCacheUpdate(int setting) {
        ByteArrayOutputStream bytesOut = new ByteArrayOutputStream();
        DataOutputStream dataOut = new DataOutputStream(bytesOut);
        try {
            dataOut.writeInt(setting);
            dataOut.writeInt(settings[setting].id);
            dataOut.writeInt(last_version);
            dataOut.writeInt(version);
            return bytesOut.toByteArray();
        }
        catch (IOException ex) {
            throw new RuntimeException("settings/cache/send/io-exception (" + ex + ")");
        }
    }

    public static void receiveCacheUpdate(byte[] data) throws RecordStoreException {
        DataInputStream in = new DataInputStream(new ByteArrayInputStream(data));
        try {
            Settings.cacheUpdate(in.readInt(), in.readInt(), in.readInt(), in.readInt());
        }
        catch (IOException ex) {
            throw new RuntimeException("settings/cache/recv/io-exception (" + ex + ")");
        }
    }

    public static byte[] sendCacheRemove(int setting) {
        ByteArrayOutputStream bytesOut = new ByteArrayOutputStream();
        DataOutputStream dataOut = new DataOutputStream(bytesOut);
        try {
            dataOut.writeInt(setting);
            dataOut.writeInt(last_version);
            dataOut.writeInt(version);
            return bytesOut.toByteArray();
        }
        catch (IOException ex) {
            throw new RuntimeException("settings/cache/send/io-exception (" + ex + ")");
        }
    }

    public static void receiveCacheRemove(byte[] data) throws RecordStoreException {
        DataInputStream in = new DataInputStream(new ByteArrayInputStream(data));
        try {
            Settings.cacheRemove(in.readInt(), in.readInt(), in.readInt());
        }
        catch (IOException ex) {
            throw new RuntimeException("settings/cache/recv/io-exception (" + ex + ")");
        }
    }

    private static void cacheUpdate(int setting, int recordId, int oldVersion, int newVersion) throws RecordStoreException {
        if (!cache_built) {
            return;
        }
        if (newVersion != version) {
            if (oldVersion <= version) {
                last_version = version;
                version = newVersion;
                settings[setting].assigned = true;
                settings[setting].id = recordId;
                settings[setting].changed = true;
                Settings.notifySettingChanged(setting, false);
            } else {
                Utilities.logData("version mismatch triggering rebuild, have " + version + " see " + oldVersion);
                Settings.rebuildCache();
            }
        }
    }

    private static void cacheRemove(int setting, int oldVersion, int newVersion) throws RecordStoreException {
        if (!cache_built) {
            return;
        }
        if (newVersion != version) {
            if (oldVersion <= version) {
                last_version = version;
                version = newVersion;
                settings[setting].assigned = false;
                Settings.notifySettingChanged(setting, false);
            } else {
                Settings.rebuildCache();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void rebuildCache() throws RecordStoreException {
        RecordStore rms = RecordStore.openRecordStore((String)RMS_NAME, (boolean)true);
        try {
            RecordEnumeration recordEnum = rms.enumerateRecords(null, null, false);
            while (recordEnum.hasNextElement()) {
                Settings.updateFromRecord(recordEnum.nextRecordId());
            }
            last_version = version;
            version = rms.getVersion();
            cache_built = true;
        }
        finally {
            rms.closeRecordStore();
        }
    }

    public static void set(int setting, String value) throws RecordStoreException {
        Settings.set(setting, (Object)value);
    }

    public static void set(int setting, int value) throws RecordStoreException {
        Settings.set(setting, new Integer(value));
    }

    public static void set(int setting, boolean value) throws RecordStoreException {
        Settings.set(setting, value ? Boolean.TRUE : Boolean.FALSE);
    }

    public static void set(int setting, long value) throws RecordStoreException {
        Settings.set(setting, new Long(value));
    }

    private static void set(int setting, Object value) throws RecordStoreException {
        if (setting < 0 || setting >= settings.length) {
            throw new IllegalArgumentException("settings/" + setting + "/invalid");
        }
        boolean success = false;
        RecordStore rms = RecordStore.openRecordStore((String)RMS_NAME, (boolean)true);
        try {
            ByteArrayOutputStream bytesOut = new ByteArrayOutputStream();
            DataOutputStream dataOut = new DataOutputStream(bytesOut);
            dataOut.writeInt(setting);
            switch (settings[setting].type) {
                case 0: {
                    dataOut.writeUTF((String)value);
                    break;
                }
                case 1: {
                    dataOut.writeInt((Integer)value);
                    break;
                }
                case 2: {
                    dataOut.writeBoolean((Boolean)value);
                    break;
                }
                case 3: {
                    dataOut.writeLong((Long)value);
                    break;
                }
                default: {
                    throw new IllegalArgumentException("settings/write/type/" + settings[setting].type + "/not-implemented");
                }
            }
            byte[] bytes = bytesOut.toByteArray();
            if (!settings[setting].assigned) {
                settings[setting].id = rms.addRecord(bytes, 0, bytes.length);
                settings[setting].assigned = true;
            } else {
                rms.setRecord(settings[setting].id, bytes, 0, bytes.length);
            }
            last_version = version;
            version = rms.getVersion();
            settings[setting].value = value;
            settings[setting].changed = false;
            success = true;
        }
        catch (IOException ex) {
            Utilities.logData("settings/set/io-error (" + ex + ")");
            throw new RecordStoreException(ex.toString());
        }
        catch (RecordStoreException ex) {
            Utilities.logData("settings/set/rms-error (" + (Object)((Object)ex) + ")");
            throw ex;
        }
        finally {
            rms.closeRecordStore();
        }
        if (success) {
            Settings.notifySettingChanged(setting, true);
        }
    }

    public static String getString(int setting) throws RecordStoreException {
        return (String)Settings.get(setting);
    }

    public static int getInt(int setting) throws RecordStoreException {
        return (Integer)Settings.get(setting);
    }

    public static boolean getBoolean(int setting) throws RecordStoreException {
        return (Boolean)Settings.get(setting);
    }

    public static long getLong(int setting) throws RecordStoreException {
        return (Long)Settings.get(setting);
    }

    private static Object get(int setting) throws RecordStoreException {
        if (setting < 0 || setting >= settings.length) {
            throw new IllegalArgumentException("settings/" + setting + "/invalid");
        }
        if (!cache_built) {
            Settings.rebuildCache();
        }
        if (settings[setting].assigned) {
            if (settings[setting].changed) {
                Settings.updateFromRecord(settings[setting].id);
            }
            return settings[setting].value;
        }
        return settings[setting].defaultValue;
    }

    public static boolean isSet(int setting) throws RecordStoreException {
        if (setting < 0 || setting >= settings.length) {
            throw new IllegalArgumentException("settings/" + setting + "/invalid");
        }
        if (!cache_built) {
            Settings.rebuildCache();
        }
        return settings[setting].assigned;
    }

    private static void updateFromRecord(int id2) throws RecordStoreException {
        RecordStore rms = RecordStore.openRecordStore((String)RMS_NAME, (boolean)true);
        try {
            Object value;
            int setting;
            DataInputStream in = new DataInputStream(new ByteArrayInputStream(rms.getRecord(id2)));
            try {
                setting = in.readInt();
            }
            catch (EOFException ex) {
                Utilities.logData("settings/eof-error in setting header");
                for (int i = 0; i < settings.length; ++i) {
                    if (settings[i].id != id2) continue;
                    Settings.clear(i);
                    break;
                }
                rms.closeRecordStore();
                return;
            }
            if (setting < 0 || setting >= settings.length) {
                Utilities.logData("settings/corrupt-id/" + setting);
                rms.deleteRecord(id2);
                return;
            }
            try {
                switch (settings[setting].type) {
                    case 0: {
                        value = in.readUTF();
                        break;
                    }
                    case 1: {
                        value = new Integer(in.readInt());
                        break;
                    }
                    case 2: {
                        value = in.readBoolean() ? Boolean.TRUE : Boolean.FALSE;
                        break;
                    }
                    case 3: {
                        value = new Long(in.readLong());
                        break;
                    }
                    default: {
                        throw new IllegalArgumentException("settings/read/type/" + settings[setting].type + "/not-implemented");
                    }
                }
            }
            catch (EOFException eofx) {
                Utilities.logData("revert to default. couldn't read type " + settings[setting].type + " at record " + id2 + " for setting " + setting);
                value = settings[setting].defaultValue;
            }
            settings[setting].id = id2;
            if (!settings[setting].assigned || value != settings[setting].value && (value == null || settings[setting].value == null || !value.equals(settings[setting].value)) || settings[setting].changed) {
                settings[setting].assigned = true;
                settings[setting].value = value;
                if (!settings[setting].changed) {
                    Settings.notifySettingChanged(setting, false);
                } else {
                    settings[setting].changed = false;
                }
            }
        }
        catch (IOException ex) {
            Utilities.logData("settings/read/io-error (" + ex + ")");
            throw new RecordStoreException(ex.toString());
        }
        catch (RecordStoreException ex) {
            Utilities.logData("settings/read/rms-error (" + (Object)((Object)ex) + ")");
            throw ex;
        }
        finally {
            rms.closeRecordStore();
        }
    }

    public static void clear(int setting) throws RecordStoreException {
        if (setting < 0 || setting >= settings.length) {
            throw new IllegalArgumentException("settings/" + setting + "/invalid");
        }
        boolean success = false;
        if (settings[setting].assigned) {
            RecordStore rms = RecordStore.openRecordStore((String)RMS_NAME, (boolean)true);
            try {
                rms.deleteRecord(settings[setting].id);
                last_version = version;
                version = rms.getVersion();
                settings[setting].assigned = false;
                settings[setting].value = null;
                success = true;
            }
            catch (RecordStoreException ex) {
                Utilities.logData("settings/clear/rms-error (" + (Object)((Object)ex) + ")");
                throw ex;
            }
            finally {
                rms.closeRecordStore();
            }
        }
        if (success) {
            Settings.notifySettingChanged(setting, true);
        }
    }

    public static void setExternal(int setting, Object value) throws RecordStoreException {
        RecordStore rms = RecordStore.openRecordStore((String)RMS_NAME, (boolean)true);
        try {
            int id2;
            ByteArrayOutputStream bytesOut = new ByteArrayOutputStream();
            DataOutputStream dataOut = new DataOutputStream(bytesOut);
            dataOut.writeInt(setting);
            if (settings[setting].type == 0) {
                dataOut.writeUTF((String)value);
            } else if (settings[setting].type == 1) {
                dataOut.writeInt((Integer)value);
            } else if (settings[setting].type == 2) {
                dataOut.writeBoolean((Boolean)value);
            } else {
                throw new IllegalArgumentException("settings/write/type/" + settings[setting].type + "/not-implemented");
            }
            byte[] bytes = bytesOut.toByteArray();
            if (!settings[setting].assigned) {
                id2 = rms.addRecord(bytes, 0, bytes.length);
            } else {
                id2 = settings[setting].id;
                rms.setRecord(id2, bytes, 0, bytes.length);
            }
            Settings.cacheUpdate(setting, id2, version, rms.getVersion());
        }
        catch (IOException ex) {
            throw new RecordStoreException(ex.toString());
        }
        finally {
            rms.closeRecordStore();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void clearExternal(int setting) throws RecordStoreException {
        if (setting < 0 || setting >= settings.length) {
            throw new IllegalArgumentException("settings/" + setting + "/invalid");
        }
        RecordStore rms = RecordStore.openRecordStore((String)RMS_NAME, (boolean)true);
        try {
            if (settings[setting].assigned) {
                rms.deleteRecord(settings[setting].id);
                Settings.cacheRemove(setting, version, rms.getVersion());
            }
        }
        finally {
            rms.closeRecordStore();
        }
    }

    private static final class Setting {
        private boolean assigned;
        private int id;
        private Object value;
        private boolean changed;
        private final int type;
        private final Object defaultValue;

        private Setting(int type, Object defaultValue) {
            this.type = type;
            this.defaultValue = defaultValue;
            this.assigned = false;
        }
    }

    public static interface Listener {
        public void onSettingChanged(int var1, boolean var2);
    }
}

