/*
 * Decompiled with CFR 0.152.
 */
package com.whatsapp.client;

import com.whatsapp.api.util.DateTimeUtilities;
import com.whatsapp.api.util.Utilities;
import com.whatsapp.client.Constants;
import com.whatsapp.client.FGApp;
import com.whatsapp.client.MMSCreator;
import com.whatsapp.client.Res;
import com.whatsapp.client.test.ContactListMidlet;
import java.io.InputStream;
import javax.microedition.io.Connector;
import javax.microedition.io.file.FileConnection;
import javax.microedition.lcdui.Alert;
import javax.microedition.lcdui.AlertType;
import javax.microedition.lcdui.Command;
import javax.microedition.lcdui.CommandListener;
import javax.microedition.lcdui.Displayable;
import javax.microedition.lcdui.Form;
import javax.microedition.lcdui.Image;
import javax.microedition.lcdui.ImageItem;
import javax.microedition.lcdui.Item;

public class ImageDisplayForm
extends Form
implements CommandListener {
    private String _imageLoc;
    private Displayable _parentScr;
    private boolean _mmsPreviewMode = false;
    private MMSCreator.ImageCreator _imgCreator;
    private ImageItem _imageItem;
    private Command _backCmd = new Command(Res.getString(59), 2, 1);
    private Command _chooseCmd = new Command(Res.getString(69), 4, 1);
    private Command _cancelCmd = new Command(Res.getString(63), 3, 1);

    public ImageDisplayForm(Displayable parentScr, long timestamp, String imageLoc, MMSCreator.ImageCreator imgCreator) {
        super(Constants.STRING_EMPTY_STRING);
        this._imageLoc = imageLoc;
        this._parentScr = parentScr;
        if (imgCreator != null) {
            this._mmsPreviewMode = true;
            this._imgCreator = imgCreator;
            this.addCommand(this._chooseCmd);
            this.addCommand(this._cancelCmd);
            this.setTitle(Res.getString(123));
        } else {
            this.addCommand(this._backCmd);
            this.setTitle(DateTimeUtilities.simpleDayFormat(timestamp) + " " + DateTimeUtilities.shortTimeFormat(timestamp));
        }
        this.setCommandListener(this);
        this.append(Res.getString(103));
        BGLoader loader = new BGLoader();
        loader.start();
    }

    public void commandAction(Command cmd, Displayable dsplbl) {
        if (cmd == this._backCmd) {
            FGApp.getInstance().setTopPane(this._parentScr);
            ContactListMidlet.getInstance()._display.setCurrent(this._parentScr);
        } else if (cmd == this._chooseCmd) {
            this._imgCreator.postChoiceProcessFile();
            FGApp.getInstance().setTopPane(this._parentScr);
            ContactListMidlet.getInstance()._display.setCurrent(this._parentScr);
        } else if (cmd == this._cancelCmd) {
            FGApp.getInstance().setTopPane(this._parentScr);
            ContactListMidlet.getInstance()._display.setCurrent(this._parentScr);
        }
    }

    private class BGLoader
    extends Thread {
        private BGLoader() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            FileConnection fileC = null;
            InputStream is = null;
            boolean result = false;
            String errorTxt = Constants.STRING_EMPTY_STRING;
            try {
                Utilities.logData("image display trying to load: " + ImageDisplayForm.this._imageLoc);
                fileC = (FileConnection)Connector.open((String)ImageDisplayForm.this._imageLoc, (int)1);
                if (fileC.exists()) {
                    Utilities.logData("image exists");
                }
                is = fileC.openInputStream();
                Image image = Image.createImage((InputStream)is);
                Utilities.logData("image display loading " + ImageDisplayForm.this._imageLoc + " with dims " + image.getWidth() + "x" + image.getHeight());
                ImageDisplayForm.this._imageItem = new ImageItem(Constants.STRING_EMPTY_STRING, image, 15360, ImageDisplayForm.this._imageLoc);
                ImageDisplayForm.this.deleteAll();
                ImageDisplayForm.this.append((Item)ImageDisplayForm.this._imageItem);
                result = true;
            }
            catch (Throwable t) {
                Utilities.logData("image background loader died: " + t.toString());
                errorTxt = t.toString();
            }
            finally {
                if (is != null) {
                    try {
                        is.close();
                    }
                    catch (Exception x) {}
                }
                if (fileC != null) {
                    try {
                        fileC.close();
                    }
                    catch (Exception x) {}
                }
            }
            if (!result) {
                Alert byeAlert = new Alert(Res.getString(102), errorTxt, null, AlertType.ERROR);
                FGApp.getInstance().setTopPane(ImageDisplayForm.this._parentScr);
                ContactListMidlet.getInstance()._display.setCurrent(byeAlert, ImageDisplayForm.this._parentScr);
            }
        }
    }
}

