/*
 * Decompiled with CFR 0.152.
 */
package com.whatsapp.client;

import com.whatsapp.api.sapi.FileUI;
import com.whatsapp.api.sapi.FileUIListener;
import com.whatsapp.api.util.Utilities;
import com.whatsapp.client.ChatPane;
import com.whatsapp.client.Constants;

public class FileUICallback
implements FileUIListener {
    private ChatPane _curPane;
    private byte _curWAMediaType;
    private FileUI _fileUI = null;
    private boolean _fileReady = false;

    public void initialize() {
        try {
            this._fileUI = new FileUI(this);
            this._fileUI.connect();
        }
        catch (Throwable t) {
            Utilities.logData("couldnt init picker callback");
        }
    }

    public void clearPane() {
        this._curPane = null;
    }

    public void FileUIsystemMessageReceived(String message) {
        Utilities.logData("File picker system message: " + message);
    }

    public void FileUIError(String message) {
        Utilities.logData("file picker error: " + message);
    }

    public void FileUIServerReady() {
        this._fileReady = true;
    }

    public void FileUIServerClosed(int reason) {
        this._fileUI = null;
        this._fileReady = false;
        Utilities.logData("file picker closed because " + reason);
    }

    public void fileSelected(short transid, String mimeType, String displayName, String URL2, boolean sharedAllowed, long size) {
        Utilities.logData("callback sees selected file URL: " + URL2 + " display name " + displayName);
        if (this._curPane == null) {
            Utilities.logData("no current pane to receive selection of " + URL2);
            return;
        }
        this._curPane.gotMMSFileSelected(this._curWAMediaType, mimeType, displayName, URL2, size);
    }

    public boolean isReady() {
        return this._fileReady && this._fileUI != null;
    }

    private static String propertyDirPath2SAPI(String str) {
        if (str == null) {
            return null;
        }
        return str.substring(8, str.length() - 1);
    }

    public boolean launchPicker(ChatPane caller, byte waType, boolean internal) {
        String systemPickerType;
        if (!this._fileReady || this._fileUI == null) {
            return false;
        }
        String startingURL = Constants.STRING_EMPTY_STRING;
        String memoryLocation = internal ? "Internal" : "External";
        switch (waType) {
            case 1: {
                systemPickerType = "Picture";
                if (!internal) break;
                startingURL = FileUICallback.propertyDirPath2SAPI(System.getProperty("fileconn.dir.photos"));
                break;
            }
            case 2: {
                systemPickerType = "Music";
                if (!internal) break;
                startingURL = FileUICallback.propertyDirPath2SAPI(System.getProperty("fileconn.dir.recordings"));
                break;
            }
            case 3: {
                systemPickerType = "Video";
                if (!internal) break;
                startingURL = FileUICallback.propertyDirPath2SAPI(System.getProperty("fileconn.dir.videos"));
                break;
            }
            default: {
                systemPickerType = "All";
            }
        }
        this._curPane = caller;
        this._curWAMediaType = waType;
        this._fileUI.openFileUI(memoryLocation, systemPickerType, startingURL);
        return true;
    }
}

