/*
 * Decompiled with CFR 0.152.
 */
package com.whatsapp.client;

import com.whatsapp.api.util.Utilities;
import com.whatsapp.client.ChatHistory;
import com.whatsapp.client.Constants;
import com.whatsapp.client.FunXMPP;
import com.whatsapp.client.MediaData;
import com.whatsapp.client.Serializer;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.EOFException;
import java.io.FilterInputStream;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import javax.microedition.io.Connector;
import javax.microedition.io.file.FileConnection;

public class CommonFileMessageStore {
    private static final int OFFLINE_HISTORY_THRESHOLD = 20;
    private static final int GROUP_SUBJECT_WIDTH = 128;

    protected static String getPath() {
        return System.getProperty(Constants.PROPERTY_FILECONN_PRIVATE_DIR);
    }

    protected static String getMMSStoreFilename() {
        return CommonFileMessageStore.getPath() + "MMS_files";
    }

    protected static String stripJid(String jid) {
        int firstAt = jid.indexOf(64);
        if (firstAt < 0) {
            return jid;
        }
        return jid.substring(0, firstAt);
    }

    protected static String getGroupInfoBasename(String gjid) {
        return gjid + ".grp";
    }

    protected static String getGroupInfoFilename(String gjid) {
        return CommonFileMessageStore.getPath() + CommonFileMessageStore.getGroupInfoBasename(gjid);
    }

    protected static String getFilename(String jid) {
        return CommonFileMessageStore.getPath() + jid + "-2.data";
    }

    protected static String getFilename(FunXMPP.FMessage fmsg) {
        return CommonFileMessageStore.getFilename(fmsg.key.remote_jid);
    }

    protected static String getIndex(FunXMPP.FMessage fmsg) {
        return CommonFileMessageStore.getIndex(fmsg.key.remote_jid);
    }

    protected static String getIndex(String jid) {
        return CommonFileMessageStore.getPath() + CommonFileMessageStore.getIndexBasename(jid);
    }

    protected static String getIndexBasename(String jid) {
        return jid + ".ndx";
    }

    protected static String getUniqueFilename(FunXMPP.FMessage.Key key) {
        return CommonFileMessageStore.getPath() + key.id + ".unq";
    }

    protected static String getUniqueFilename(FunXMPP.FMessage fmsg) {
        return CommonFileMessageStore.getUniqueFilename(fmsg.key);
    }

    protected static String getUniqueIndex(FunXMPP.FMessage fmsg) {
        return CommonFileMessageStore.getPath() + fmsg.key.id + ".ndx";
    }

    protected static String getThumbsArchive() {
        return CommonFileMessageStore.getPath() + "thumbs/";
    }

    protected static String getThumbBasename(FunXMPP.FMessage.Key key) {
        return key.remote_jid + (key.from_me ? (char)'1' : '0') + key.id;
    }

    protected static String getThumbFullPath(FunXMPP.FMessage.Key key) {
        return CommonFileMessageStore.getThumbsArchive() + CommonFileMessageStore.getThumbBasename(key);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    public Vector getChats() {
        void var1_1;
        Vector<ChatHistory> v = new Vector<ChatHistory>();
        FileConnection dirC = null;
        try {
            String jid;
            String curEntry;
            dirC = (FileConnection)Connector.open((String)CommonFileMessageStore.getPath(), (int)1);
            Hashtable<String, String> validGroups = new Hashtable<String, String>();
            Enumeration en = dirC.list("*.grp", true);
            while (en.hasMoreElements()) {
                curEntry = (String)en.nextElement();
                jid = curEntry.substring(0, curEntry.length() - 4);
                Utilities.logData("seeing group metadata for gjid " + jid);
                validGroups.put(jid, jid);
            }
            en = dirC.list("*.data", true);
            while (en.hasMoreElements()) {
                ChatHistory newHist;
                curEntry = (String)en.nextElement();
                jid = Utilities.safeIntern(curEntry.substring(0, curEntry.length() - 7));
                Utilities.logData("seeing jid in dir " + jid);
                if (validGroups.get(jid) != null) {
                    newHist = new ChatHistory(jid, true);
                    validGroups.remove(jid);
                } else {
                    newHist = new ChatHistory(jid, false);
                }
                v.addElement(newHist);
            }
            en = validGroups.elements();
            while (en.hasMoreElements()) {
                String nakedGroup = (String)en.nextElement();
                ChatHistory newHist = new ChatHistory(nakedGroup, true);
                v.addElement(newHist);
            }
        }
        catch (Exception exception) {
        }
        finally {
            try {
                if (dirC != null) {
                    dirC.close();
                }
            }
            catch (Exception exception) {}
        }
        return var1_1;
    }

    private static boolean isValidOffliner(FunXMPP.FMessage fmsg, Hashtable fromMeIDHash) {
        if (!fmsg.key.from_me) {
            return false;
        }
        switch (fmsg.status & 0xF) {
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                return false;
            }
        }
        if (MediaData.hasURL(fmsg.media_wa_type) && (fmsg.media_url == null || fmsg.media_url.length() == 0)) {
            return false;
        }
        return fromMeIDHash.containsKey(fmsg.key.id);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    public Vector getAllOfflineMessages() {
        void var3_3;
        Vector chats = this.getChats();
        int numChats = chats.size();
        Vector<FunXMPP.FMessage> res = new Vector<FunXMPP.FMessage>();
        for (int i = 0; i < numChats; ++i) {
            long firstFromMeOffset;
            FilterInputStream dIS;
            InputStream is;
            FileConnection fileC;
            Hashtable<String, String> fromMeIDHash;
            ChatHistory curChat;
            block64: {
                block65: {
                    curChat = (ChatHistory)chats.elementAt(i);
                    fromMeIDHash = new Hashtable<String, String>();
                    fileC = null;
                    is = null;
                    dIS = null;
                    String indexFilename = CommonFileMessageStore.getIndex(curChat._jid);
                    firstFromMeOffset = -1L;
                    fileC = (FileConnection)Connector.open((String)indexFilename, (int)1);
                    if (fileC.exists()) break block64;
                    fileC.close();
                    fileC = null;
                    if (dIS == null) break block65;
                    try {
                        dIS.close();
                    }
                    catch (Exception x) {
                        // empty catch block
                    }
                }
                if (is != null) {
                    try {
                        is.close();
                    }
                    catch (Exception x) {
                        // empty catch block
                    }
                }
                if (fileC == null) continue;
                try {
                    fileC.close();
                }
                catch (Exception x) {}
                continue;
            }
            long indexSize = fileC.fileSize();
            long useOffset = indexSize - 1280L;
            if (useOffset < 0L) {
                useOffset = 0L;
            }
            is = fileC.openInputStream();
            is.skip(useOffset);
            dIS = new DataInputStream(is);
            try {
                while (true) {
                    IndexRecord ndx = IndexRecord.unserialize((DataInputStream)dIS);
                    if (!ndx.from_me) continue;
                    fromMeIDHash.put(ndx.id, ndx.id);
                    if (firstFromMeOffset != -1L) continue;
                    firstFromMeOffset = ndx.offset;
                }
            }
            catch (EOFException eofx) {
                block66: {
                    block67: {
                        dIS.close();
                        dIS = null;
                        is.close();
                        is = null;
                        fileC.close();
                        fileC = null;
                        if (fromMeIDHash.size() == 0) {
                            if (dIS != null) {
                                try {
                                    dIS.close();
                                }
                                catch (Exception x) {
                                    // empty catch block
                                }
                            }
                            if (is != null) {
                                try {
                                    is.close();
                                }
                                catch (Exception x) {
                                    // empty catch block
                                }
                            }
                            if (fileC == null) continue;
                            try {
                                fileC.close();
                            }
                            catch (Exception x) {}
                            continue;
                        }
                        fileC = (FileConnection)Connector.open((String)CommonFileMessageStore.getFilename(curChat._jid), (int)1);
                        if (fileC.exists()) break block66;
                        fileC.close();
                        fileC = null;
                        if (dIS == null) break block67;
                        try {
                            dIS.close();
                        }
                        catch (Exception x) {
                            // empty catch block
                        }
                    }
                    if (is != null) {
                        try {
                            is.close();
                        }
                        catch (Exception x) {
                            // empty catch block
                        }
                    }
                    if (fileC == null) continue;
                    try {
                        fileC.close();
                    }
                    catch (Exception x) {}
                    continue;
                }
                try {
                    is = fileC.openInputStream();
                    if (firstFromMeOffset > 0L) {
                        is.skip(firstFromMeOffset);
                    }
                    dIS = new DataInputStream(is);
                    try {
                        while (true) {
                            FunXMPP.FMessage fmsg;
                            if (CommonFileMessageStore.isValidOffliner(fmsg = Serializer.unserializeFMSG((DataInputStream)dIS), fromMeIDHash)) {
                                res.addElement(fmsg);
                                Utilities.logData("found offline message " + fmsg.key.toString());
                                continue;
                            }
                            FunXMPP.destroyMessage(fmsg);
                        }
                    }
                    catch (EOFException eofx2) {
                        dIS.close();
                        dIS = null;
                        is.close();
                        is = null;
                        fileC.close();
                        fileC = null;
                        if (dIS != null) {
                            try {
                                dIS.close();
                            }
                            catch (Exception x) {
                                // empty catch block
                            }
                        }
                        if (is != null) {
                            try {
                                is.close();
                            }
                            catch (Exception x) {
                                // empty catch block
                            }
                        }
                        if (fileC == null) continue;
                        try {
                            fileC.close();
                        }
                        catch (Exception x) {}
                        continue;
                    }
                }
                catch (Throwable t) {
                    try {
                        Utilities.logData("blew up looking for offliners in jid " + curChat._jid + " with error " + t.toString());
                        continue;
                    }
                    catch (Throwable throwable) {
                        throw throwable;
                    }
                    finally {
                        if (dIS != null) {
                            try {
                                dIS.close();
                            }
                            catch (Exception x) {}
                        }
                        if (is != null) {
                            try {
                                is.close();
                            }
                            catch (Exception x) {}
                        }
                        if (fileC != null) {
                            try {
                                fileC.close();
                            }
                            catch (Exception x) {}
                        }
                    }
                }
            }
        }
        return var3_3;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean putMessage(FunXMPP.FMessage fmsg) {
        FileConnection fileC = null;
        OutputStream os = null;
        FilterOutputStream dOS = null;
        boolean res = false;
        String filename = null;
        try {
            long indexOffset;
            long dataOffset;
            filename = CommonFileMessageStore.getFilename(fmsg);
            fileC = (FileConnection)Connector.open((String)filename, (int)3);
            if (fileC.exists()) {
                dataOffset = fileC.fileSize();
            } else {
                fileC.create();
                dataOffset = 0L;
            }
            os = fileC.openOutputStream(dataOffset);
            dOS = new DataOutputStream(os);
            Serializer.serializeFMSG(fmsg, (DataOutputStream)dOS, false);
            ((DataOutputStream)dOS).flush();
            dOS.close();
            dOS = null;
            os.close();
            os = null;
            fileC.close();
            fileC = null;
            IndexRecord indexRec = new IndexRecord(fmsg, dataOffset);
            filename = CommonFileMessageStore.getIndex(fmsg);
            fileC = (FileConnection)Connector.open((String)filename, (int)3);
            if (fileC.exists()) {
                indexOffset = fileC.fileSize();
            } else {
                fileC.create();
                indexOffset = 0L;
            }
            os = fileC.openOutputStream(indexOffset);
            dOS = new DataOutputStream(os);
            IndexRecord.serialize(indexRec, (DataOutputStream)dOS);
            ((DataOutputStream)dOS).flush();
            dOS.close();
            dOS = null;
            os.close();
            os = null;
            fileC.close();
            fileC = null;
            res = true;
        }
        catch (Throwable t) {
            Utilities.logData("couldn't store message with key " + fmsg.key + " after error " + t.toString() + " last file was " + filename);
            res = false;
        }
        finally {
            if (dOS != null) {
                try {
                    dOS.close();
                }
                catch (Exception x) {}
            }
            if (os != null) {
                try {
                    os.close();
                }
                catch (Exception x) {}
            }
            if (fileC != null) {
                try {
                    fileC.close();
                }
                catch (Exception x) {}
            }
        }
        return res;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public FunXMPP.FMessage getMessage(FunXMPP.FMessage.Key key) {
        FunXMPP.FMessage fMessage;
        InputStream is;
        FileConnection fileC;
        block39: {
            long useOffset;
            String indexFilename = CommonFileMessageStore.getIndex(key.remote_jid);
            fileC = null;
            is = null;
            FilterInputStream dIS = null;
            try {
                fileC = (FileConnection)Connector.open((String)indexFilename, (int)1);
                useOffset = 0L;
                is = fileC.openInputStream();
                dIS = new DataInputStream(is);
                try {
                    IndexRecord ndx;
                    do {
                        ndx = IndexRecord.unserialize((DataInputStream)dIS);
                    } while (!ndx.id.equals(key.id) || key.from_me != ndx.from_me);
                    useOffset = ndx.offset;
                }
                catch (EOFException eofx) {
                    Utilities.logData("reached EOF reading index looking for specific record: " + key.toString());
                    FunXMPP.FMessage fMessage2 = null;
                    if (dIS != null) {
                        try {
                            dIS.close();
                        }
                        catch (Exception x) {
                            // empty catch block
                        }
                    }
                    if (is != null) {
                        try {
                            is.close();
                        }
                        catch (Exception x) {
                            // empty catch block
                        }
                    }
                    if (fileC == null) return fMessage2;
                    try {
                        fileC.close();
                        return fMessage2;
                    }
                    catch (Exception x) {
                        // empty catch block
                    }
                    return fMessage2;
                }
            }
            catch (Throwable t) {
                try {
                    Utilities.logData("problems retrieving message " + key.toString());
                    FunXMPP.FMessage fMessage3 = null;
                    return fMessage3;
                }
                catch (Throwable throwable) {
                    throw throwable;
                }
                finally {
                    if (dIS != null) {
                        try {
                            dIS.close();
                        }
                        catch (Exception x) {}
                    }
                    if (is != null) {
                        try {
                            is.close();
                        }
                        catch (Exception x) {}
                    }
                    if (fileC != null) {
                        try {
                            fileC.close();
                        }
                        catch (Exception x) {}
                    }
                }
            }
            {
                FunXMPP.FMessage fmsg;
                dIS.close();
                dIS = null;
                is.close();
                is = null;
                fileC.close();
                fileC = null;
                String dataFilename = CommonFileMessageStore.getFilename(key.remote_jid);
                fileC = (FileConnection)Connector.open((String)dataFilename, (int)1);
                is = fileC.openInputStream();
                is.skip(useOffset);
                dIS = new DataInputStream(is);
                fMessage = fmsg = Serializer.unserializeFMSG((DataInputStream)dIS);
                if (dIS == null) break block39;
            }
            try {
                dIS.close();
            }
            catch (Exception x) {
                // empty catch block
            }
        }
        if (is != null) {
            try {
                is.close();
            }
            catch (Exception x) {
                // empty catch block
            }
        }
        if (fileC == null) return fMessage;
        try {
            fileC.close();
            return fMessage;
        }
        catch (Exception x) {
            // empty catch block
        }
        return fMessage;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public Vector getMessages(String jid, String sinceID) {
        Vector<FunXMPP.FMessage> resV;
        block67: {
            String indexFilename = CommonFileMessageStore.getIndex(jid);
            FileConnection fileC = null;
            InputStream is = null;
            FilterInputStream dIS = null;
            resV = new Vector<FunXMPP.FMessage>();
            try {
                fileC = (FileConnection)Connector.open((String)indexFilename, (int)1);
                if (!fileC.exists()) {
                    Vector<FunXMPP.FMessage> vector = resV;
                    return vector;
                }
                long useOffset = 0L;
                is = fileC.openInputStream();
                dIS = new DataInputStream(is);
                Vector<String> indexIDVec = new Vector<String>();
                try {
                    boolean harvestMode = sinceID == null;
                    while (true) {
                        IndexRecord ndx2222 = IndexRecord.unserialize((DataInputStream)dIS);
                        if (!harvestMode && ndx2222.id.equals(sinceID)) {
                            ndx2222 = IndexRecord.unserialize((DataInputStream)dIS);
                            useOffset = ndx2222.offset;
                            harvestMode = true;
                        }
                        if (!harvestMode) continue;
                        indexIDVec.addElement(ndx2222.id);
                    }
                }
                catch (EOFException eofx) {
                    block66: {
                        block64: {
                            Vector<FunXMPP.FMessage> ndx2222;
                            block65: {
                                if (indexIDVec.size() == 0) {
                                    Vector<FunXMPP.FMessage> ndx2222 = resV;
                                    if (dIS != null) {
                                        try {
                                            dIS.close();
                                        }
                                        catch (Exception x) {
                                            // empty catch block
                                        }
                                    }
                                    if (is != null) {
                                        try {
                                            is.close();
                                        }
                                        catch (Exception x) {
                                            // empty catch block
                                        }
                                    }
                                    if (fileC != null) {
                                        try {
                                            fileC.close();
                                        }
                                        catch (Exception x) {
                                            // empty catch block
                                        }
                                    }
                                    return ndx2222;
                                }
                                dIS.close();
                                dIS = null;
                                is.close();
                                is = null;
                                fileC.close();
                                fileC = null;
                                String dataFilename = CommonFileMessageStore.getFilename(jid);
                                fileC = (FileConnection)Connector.open((String)dataFilename, (int)1);
                                if (fileC.exists()) break block64;
                                ndx2222 = resV;
                                if (dIS == null) break block65;
                                try {
                                    dIS.close();
                                }
                                catch (Exception x) {
                                    // empty catch block
                                }
                            }
                            if (is != null) {
                                try {
                                    is.close();
                                }
                                catch (Exception x) {
                                    // empty catch block
                                }
                            }
                            if (fileC != null) {
                                try {
                                    fileC.close();
                                }
                                catch (Exception x) {
                                    // empty catch block
                                }
                            }
                            return ndx2222;
                        }
                        is = fileC.openInputStream();
                        is.skip(useOffset);
                        dIS = new DataInputStream(is);
                        try {
                            int needed = indexIDVec.size();
                            int indexPtr = 0;
                            while (indexPtr < needed) {
                                FunXMPP.FMessage curMsg = Serializer.unserializeFMSG((DataInputStream)dIS);
                                String findIndex = (String)indexIDVec.elementAt(indexPtr);
                                if (curMsg.key.id.equals(findIndex)) {
                                    resV.addElement(curMsg);
                                    ++indexPtr;
                                    continue;
                                }
                                Utilities.logData("message with id " + curMsg.key.id + " not what we're looking for, must be deleted or duped");
                            }
                        }
                        catch (EOFException eofx2) {
                            Utilities.logData("reached end of file trying to read messages after finding " + resV.size());
                        }
                        if (dIS == null) break block66;
                        try {
                            dIS.close();
                        }
                        catch (Exception x) {
                            // empty catch block
                        }
                    }
                    if (is != null) {
                        try {
                            is.close();
                        }
                        catch (Exception x) {
                            // empty catch block
                        }
                    }
                    if (fileC != null) {
                        try {
                            fileC.close();
                        }
                        catch (Exception x) {}
                    }
                    break block67;
                    catch (Throwable t) {
                        Utilities.logData("encountered error reading messages " + t.toString());
                        break block67;
                    }
                    catch (Throwable throwable) {
                        throw throwable;
                    }
                }
            }
            finally {
                if (dIS != null) {
                    try {
                        dIS.close();
                    }
                    catch (Exception x) {}
                }
                if (is != null) {
                    try {
                        is.close();
                    }
                    catch (Exception x) {}
                }
                if (fileC != null) {
                    try {
                        fileC.close();
                    }
                    catch (Exception x) {}
                }
            }
        }
        return resV;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Vector getMessagesBefore(String jid, FunXMPP.FMessage fmsg, int count, int[] outRemainingCount) {
        Vector<IndexRecord> indexVec;
        long useOffset;
        Vector<FunXMPP.FMessage> resV;
        FilterInputStream dIS;
        InputStream is;
        FileConnection fileC;
        block65: {
            String beforeID;
            String indexFilename = CommonFileMessageStore.getIndex(jid);
            fileC = null;
            is = null;
            dIS = null;
            resV = new Vector<FunXMPP.FMessage>();
            try {
                fileC = (FileConnection)Connector.open((String)indexFilename, (int)1);
                if (!fileC.exists()) {
                    Vector<FunXMPP.FMessage> vector = resV;
                    return vector;
                }
                useOffset = 0L;
                if (fmsg != null) {
                    beforeID = fmsg.key.id;
                } else {
                    beforeID = null;
                    long indexSize = fileC.fileSize();
                    useOffset = indexSize - (long)(count * 64);
                    if (useOffset < 0L) {
                        useOffset = 0L;
                    }
                    if (outRemainingCount != null) {
                        outRemainingCount[0] = (int)useOffset / 64;
                    }
                }
                is = fileC.openInputStream();
                is.skip(useOffset);
                dIS = new DataInputStream(is);
                indexVec = new Vector<IndexRecord>();
                try {}
                catch (EOFException eofx) {
                    if (indexVec.size() != 0) break block65;
                    Vector<FunXMPP.FMessage> vector = resV;
                    if (dIS != null) {
                        try {
                            dIS.close();
                        }
                        catch (Exception x) {
                            // empty catch block
                        }
                    }
                    if (is != null) {
                        try {
                            is.close();
                        }
                        catch (Exception x) {
                            // empty catch block
                        }
                    }
                    if (fileC == null) return vector;
                    try {
                        fileC.close();
                        return vector;
                    }
                    catch (Exception x) {
                        // empty catch block
                    }
                    return vector;
                }
            }
            catch (Throwable t) {
                Utilities.logData("encountered error reading messages " + t.toString());
                return resV;
            }
            while (true) {
                IndexRecord ndx = IndexRecord.unserialize((DataInputStream)dIS);
                if (beforeID != null && ndx.id.equals(beforeID)) break;
                indexVec.addElement(ndx);
            }
        }
        int totalScanned = indexVec.size();
        int finalSize = Math.min(count, totalScanned);
        if (fmsg != null && outRemainingCount != null) {
            outRemainingCount[0] = totalScanned - finalSize;
        }
        Vector<String> exactRecs = new Vector<String>(finalSize);
        IndexRecord curNdx = (IndexRecord)indexVec.elementAt(totalScanned - finalSize);
        useOffset = curNdx.offset;
        for (int i = 0; i < finalSize; ++i) {
            curNdx = (IndexRecord)indexVec.elementAt(totalScanned - finalSize + i);
            exactRecs.addElement(curNdx.id);
        }
        dIS.close();
        dIS = null;
        is.close();
        is = null;
        fileC.close();
        fileC = null;
        Utilities.logData("index says there are " + exactRecs.size() + " messages for " + jid + " starting at offset " + useOffset);
        String dataFilename = CommonFileMessageStore.getFilename(jid);
        fileC = (FileConnection)Connector.open((String)dataFilename, (int)1);
        if (!fileC.exists()) {
            Utilities.logData("No message data file but we expected record count: " + exactRecs.size());
            return resV;
        }
        is = fileC.openInputStream();
        is.skip(useOffset);
        dIS = new DataInputStream(is);
        try {
            int needed = exactRecs.size();
            int indexPtr = 0;
            while (indexPtr < needed) {
                FunXMPP.FMessage curMsg = Serializer.unserializeFMSG((DataInputStream)dIS);
                String findIndex = (String)exactRecs.elementAt(indexPtr);
                if (curMsg.key.id.equals(findIndex)) {
                    resV.insertElementAt(curMsg, 0);
                    ++indexPtr;
                    continue;
                }
                Utilities.logData("message with id " + curMsg.key.id + " not what we're looking for, must be deleted or duped");
            }
            return resV;
        }
        catch (EOFException eofx) {
            Utilities.logData("reached end of file trying to read messages after finding " + resV.size());
            return resV;
        }
        finally {
            if (dIS != null) {
                try {
                    dIS.close();
                }
                catch (Exception x) {}
            }
            if (is != null) {
                try {
                    is.close();
                }
                catch (Exception x) {}
            }
            if (fileC != null) {
                try {
                    fileC.close();
                }
                catch (Exception x) {}
            }
        }
    }

    public boolean deleteChatHistory(String jid) {
        FileConnection fileC = null;
        boolean res = true;
        try {
            fileC = (FileConnection)Connector.open((String)CommonFileMessageStore.getFilename(jid), (int)3);
            if (fileC.exists()) {
                fileC.delete();
            }
        }
        catch (Throwable t) {
            Utilities.logData("problems deleting data file for " + jid + " error: " + t.toString());
            res = false;
        }
        try {
            fileC = (FileConnection)Connector.open((String)CommonFileMessageStore.getGroupInfoFilename(jid), (int)3);
            if (fileC.exists()) {
                fileC.delete();
            }
        }
        catch (Throwable t) {
            Utilities.logData("problems deleting group file for " + jid + " error: " + t.toString());
            res = false;
        }
        try {
            fileC = (FileConnection)Connector.open((String)CommonFileMessageStore.getIndex(jid), (int)3);
            if (fileC.exists()) {
                fileC.delete();
            }
        }
        catch (Throwable t) {
            Utilities.logData("problems deleting index file for " + jid + " error: " + t.toString());
            res = false;
        }
        FileConnection fc2 = null;
        try {
            fileC = (FileConnection)Connector.open((String)CommonFileMessageStore.getThumbsArchive(), (int)3);
            if (fileC.exists()) {
                Enumeration en = fileC.list(jid, true);
                while (en.hasMoreElements()) {
                    String orphanedThumb = (String)en.nextElement();
                    try {
                        Utilities.logData("deleting orphaned thumb " + orphanedThumb);
                        fc2 = (FileConnection)Connector.open((String)(CommonFileMessageStore.getThumbsArchive() + orphanedThumb), (int)3);
                        fc2.delete();
                    }
                    catch (Throwable t) {}
                }
            }
        }
        catch (Throwable t) {
            // empty catch block
        }
        return res;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean deleteMessage(FunXMPP.FMessage fmsg) {
        String indexFilename = CommonFileMessageStore.getIndex(fmsg.key.remote_jid);
        FileConnection oldFileC = null;
        FileConnection newFileC = null;
        InputStream is = null;
        FilterInputStream dIS = null;
        OutputStream os = null;
        FilterOutputStream dOS = null;
        Vector<IndexRecord> remadeIndex = new Vector<IndexRecord>();
        boolean res = false;
        try {
            oldFileC = (FileConnection)Connector.open((String)indexFilename, (int)3);
            long useOffset = 0L;
            is = oldFileC.openInputStream();
            dIS = new DataInputStream(is);
            try {
                while (true) {
                    IndexRecord ndx = IndexRecord.unserialize((DataInputStream)dIS);
                    if (!ndx.id.equals(fmsg.key.id)) {
                        remadeIndex.addElement(ndx);
                        continue;
                    }
                    Utilities.logData("found delete target " + ndx.id);
                }
            }
            catch (EOFException eofx) {
                dIS.close();
                dIS = null;
                is.close();
                is = null;
                int newSize = remadeIndex.size();
                Utilities.logData("remade index will have " + newSize + " entries");
                newFileC = (FileConnection)Connector.open((String)(indexFilename + "NEW"), (int)2);
                newFileC.create();
                Utilities.logData("created new index");
                os = newFileC.openOutputStream();
                dOS = new DataOutputStream(os);
                for (int i = 0; i < newSize; ++i) {
                    IndexRecord ndx = (IndexRecord)remadeIndex.elementAt(i);
                    IndexRecord.serialize(ndx, (DataOutputStream)dOS);
                }
                ((DataOutputStream)dOS).flush();
                dOS.close();
                dOS = null;
                os.close();
                os = null;
                oldFileC.delete();
                newFileC.rename(CommonFileMessageStore.getIndexBasename(fmsg.key.remote_jid));
                res = true;
                oldFileC.close();
                newFileC.close();
                oldFileC = (FileConnection)Connector.open((String)CommonFileMessageStore.getThumbsArchive(), (int)3);
                if (oldFileC.exists()) {
                    Enumeration en = oldFileC.list(CommonFileMessageStore.getThumbBasename(fmsg.key), true);
                    while (en.hasMoreElements()) {
                        String orphanedThumb = (String)en.nextElement();
                        try {
                            Utilities.logData("deleting orphaned thumb " + orphanedThumb);
                            newFileC = (FileConnection)Connector.open((String)(CommonFileMessageStore.getThumbsArchive() + orphanedThumb), (int)3);
                            newFileC.delete();
                        }
                        catch (Throwable t) {}
                    }
                }
                if (!res && newFileC != null) {
                    try {
                        newFileC.delete();
                    }
                    catch (Exception x) {
                        // empty catch block
                    }
                }
                if (dIS != null) {
                    try {
                        dIS.close();
                    }
                    catch (Exception x) {
                        // empty catch block
                    }
                }
                if (is != null) {
                    try {
                        is.close();
                    }
                    catch (Exception x) {
                        // empty catch block
                    }
                }
                if (oldFileC != null) {
                    try {
                        oldFileC.close();
                    }
                    catch (Exception x) {
                        // empty catch block
                    }
                }
                if (dOS != null) {
                    try {
                        dOS.close();
                    }
                    catch (Exception x) {
                        // empty catch block
                    }
                }
                if (os != null) {
                    try {
                        os.close();
                    }
                    catch (Exception x) {
                        // empty catch block
                    }
                }
                if (newFileC != null) {
                    try {
                        newFileC.close();
                    }
                    catch (Exception x) {}
                }
            }
        }
        catch (Throwable t) {
            Utilities.logData("encountered problem deleting fmsg id " + fmsg.key.id + " error " + t.toString());
        }
        finally {
            if (!res && newFileC != null) {
                try {
                    newFileC.delete();
                }
                catch (Exception x) {}
            }
            if (dIS != null) {
                try {
                    dIS.close();
                }
                catch (Exception x) {}
            }
            if (is != null) {
                try {
                    is.close();
                }
                catch (Exception x) {}
            }
            if (oldFileC != null) {
                try {
                    oldFileC.close();
                }
                catch (Exception x) {}
            }
            if (dOS != null) {
                try {
                    dOS.close();
                }
                catch (Exception x) {}
            }
            if (os != null) {
                try {
                    os.close();
                }
                catch (Exception x) {}
            }
            if (newFileC != null) {
                try {
                    newFileC.close();
                }
                catch (Exception exception) {}
            }
        }
        return res;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public boolean updateMessageStatus(FunXMPP.FMessage fmsg, boolean includeMMSKey) {
        boolean bl;
        FilterOutputStream dOS;
        FilterInputStream dIS;
        OutputStream os;
        InputStream is;
        FileConnection fileC;
        block98: {
            long useOffset;
            block96: {
                boolean bl2;
                block97: {
                    block94: {
                        boolean bl3;
                        block95: {
                            String indexFilename = CommonFileMessageStore.getIndex(fmsg.key.remote_jid);
                            fileC = null;
                            is = null;
                            os = null;
                            dIS = null;
                            dOS = null;
                            fileC = (FileConnection)Connector.open((String)indexFilename, (int)1);
                            if (fileC.exists()) break block94;
                            bl3 = true;
                            if (dIS == null) break block95;
                            try {
                                dIS.close();
                            }
                            catch (Exception x) {
                                // empty catch block
                            }
                        }
                        if (is != null) {
                            try {
                                is.close();
                            }
                            catch (Exception x) {
                                // empty catch block
                            }
                        }
                        if (dOS != null) {
                            try {
                                dOS.close();
                            }
                            catch (Exception x) {
                                // empty catch block
                            }
                        }
                        if (os != null) {
                            try {
                                os.close();
                            }
                            catch (Exception x) {
                                // empty catch block
                            }
                        }
                        if (fileC != null) {
                            try {
                                fileC.close();
                            }
                            catch (Exception x) {
                                // empty catch block
                            }
                        }
                        return bl3;
                    }
                    long indexSize = fileC.fileSize();
                    useOffset = indexSize - 2560L;
                    if (useOffset < 0L) {
                        useOffset = 0L;
                    }
                    is = fileC.openInputStream();
                    is.skip(useOffset);
                    dIS = new DataInputStream(is);
                    try {
                        IndexRecord ndx;
                        do {
                            ndx = IndexRecord.unserialize((DataInputStream)dIS);
                        } while (!ndx.id.equals(fmsg.key.id) || fmsg.key.from_me != ndx.from_me);
                        useOffset = ndx.offset;
                    }
                    catch (EOFException eofx) {
                        Utilities.logData("reached EOF reading index looking for specific updateable record: " + fmsg.key.toString());
                        boolean bl4 = true;
                        if (dIS != null) {
                            try {
                                dIS.close();
                            }
                            catch (Exception x) {
                                // empty catch block
                            }
                        }
                        if (is != null) {
                            try {
                                is.close();
                            }
                            catch (Exception x) {
                                // empty catch block
                            }
                        }
                        if (dOS != null) {
                            try {
                                dOS.close();
                            }
                            catch (Exception x) {
                                // empty catch block
                            }
                        }
                        if (os != null) {
                            try {
                                os.close();
                            }
                            catch (Exception x) {
                                // empty catch block
                            }
                        }
                        if (fileC != null) {
                            try {
                                fileC.close();
                            }
                            catch (Exception x) {
                                // empty catch block
                            }
                        }
                        return bl4;
                    }
                    dIS.close();
                    dIS = null;
                    is.close();
                    is = null;
                    fileC.close();
                    fileC = null;
                    String filename = CommonFileMessageStore.getFilename(fmsg);
                    fileC = (FileConnection)Connector.open((String)filename, (int)3);
                    if (fileC.exists()) break block96;
                    Utilities.logData("status update for msg " + fmsg.key + " doesn't see file " + filename);
                    bl2 = false;
                    if (dIS == null) break block97;
                    try {
                        dIS.close();
                    }
                    catch (Exception x) {
                        // empty catch block
                    }
                }
                if (is != null) {
                    try {
                        is.close();
                    }
                    catch (Exception x) {
                        // empty catch block
                    }
                }
                if (dOS != null) {
                    try {
                        dOS.close();
                    }
                    catch (Exception x) {
                        // empty catch block
                    }
                }
                if (os != null) {
                    try {
                        os.close();
                    }
                    catch (Exception x) {
                        // empty catch block
                    }
                }
                if (fileC != null) {
                    try {
                        fileC.close();
                    }
                    catch (Exception x) {
                        // empty catch block
                    }
                }
                return bl2;
            }
            os = fileC.openOutputStream(useOffset);
            dOS = new DataOutputStream(os);
            Serializer.serializeFMsgStatusOnly(fmsg, includeMMSKey, (DataOutputStream)dOS);
            ((DataOutputStream)dOS).flush();
            bl = true;
            if (dIS == null) break block98;
            try {
                dIS.close();
            }
            catch (Exception x) {
                // empty catch block
            }
        }
        if (is != null) {
            try {
                is.close();
            }
            catch (Exception x) {
                // empty catch block
            }
        }
        if (dOS != null) {
            try {
                dOS.close();
            }
            catch (Exception x) {
                // empty catch block
            }
        }
        if (os != null) {
            try {
                os.close();
            }
            catch (Exception x) {
                // empty catch block
            }
        }
        if (fileC != null) {
            try {
                fileC.close();
            }
            catch (Exception x) {
                // empty catch block
            }
        }
        return bl;
        catch (Throwable t) {
            try {
                Utilities.logData("problems updating status on " + fmsg.key.toString() + ": " + t.toString());
                boolean bl5 = false;
                return bl5;
            }
            catch (Throwable throwable) {
                throw throwable;
            }
            finally {
                if (dIS != null) {
                    try {
                        dIS.close();
                    }
                    catch (Exception x) {}
                }
                if (is != null) {
                    try {
                        is.close();
                    }
                    catch (Exception x) {}
                }
                if (dOS != null) {
                    try {
                        dOS.close();
                    }
                    catch (Exception x) {}
                }
                if (os != null) {
                    try {
                        os.close();
                    }
                    catch (Exception x) {}
                }
                if (fileC != null) {
                    try {
                        fileC.close();
                    }
                    catch (Exception x) {}
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean putMessageToTemp(FunXMPP.FMessage fmsg) {
        OutputStream os;
        FileConnection fileC;
        block27: {
            fileC = null;
            os = null;
            FilterOutputStream dOS = null;
            String filename = null;
            try {
                filename = CommonFileMessageStore.getUniqueFilename(fmsg);
                fileC = (FileConnection)Connector.open((String)filename, (int)3);
                fileC.create();
                os = fileC.openOutputStream();
                dOS = new DataOutputStream(os);
                Utilities.logData("storing to unique file " + fileC.getURL());
                Serializer.serializeFMSG(fmsg, (DataOutputStream)dOS, false);
                ((DataOutputStream)dOS).flush();
                dOS.close();
                dOS = null;
                os.close();
                os = null;
                fileC.close();
                fileC = null;
                if (dOS == null) break block27;
            }
            catch (Throwable t) {
                try {
                    Utilities.logData("couldn't unique store message with key " + fmsg.key + " after error " + t.toString());
                    boolean bl = false;
                    return bl;
                }
                catch (Throwable throwable) {
                    throw throwable;
                }
                finally {
                    if (dOS != null) {
                        try {
                            dOS.close();
                        }
                        catch (Exception x) {}
                    }
                    if (os != null) {
                        try {
                            os.close();
                        }
                        catch (Exception x) {}
                    }
                    if (fileC != null) {
                        try {
                            fileC.close();
                        }
                        catch (Exception x) {}
                    }
                }
            }
            try {
                dOS.close();
            }
            catch (Exception x) {
                // empty catch block
            }
        }
        if (os != null) {
            try {
                os.close();
            }
            catch (Exception x) {
                // empty catch block
            }
        }
        if (fileC == null) return true;
        try {
            fileC.close();
            return true;
        }
        catch (Exception x) {
            return true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public FunXMPP.FMessage getTempMessage(FunXMPP.FMessage.Key key) {
        FunXMPP.FMessage fMessage;
        InputStream is;
        FileConnection fileC;
        block27: {
            String filename = CommonFileMessageStore.getUniqueFilename(key);
            fileC = null;
            is = null;
            FilterInputStream dIS = null;
            try {
                fileC = (FileConnection)Connector.open((String)filename, (int)3);
                is = fileC.openInputStream();
                dIS = new DataInputStream(is);
                FunXMPP.FMessage fmsg = Serializer.unserializeFMSG((DataInputStream)dIS);
                fileC.delete();
                fMessage = fmsg;
                if (dIS == null) break block27;
            }
            catch (Throwable t) {
                try {
                    Utilities.logData("problems retrieving unique message " + key.toString());
                    FunXMPP.FMessage fMessage2 = null;
                    return fMessage2;
                }
                catch (Throwable throwable) {
                    throw throwable;
                }
                finally {
                    if (dIS != null) {
                        try {
                            dIS.close();
                        }
                        catch (Exception x) {}
                    }
                    if (is != null) {
                        try {
                            is.close();
                        }
                        catch (Exception x) {}
                    }
                    if (fileC != null) {
                        try {
                            fileC.close();
                        }
                        catch (Exception x) {}
                    }
                }
            }
            try {
                dIS.close();
            }
            catch (Exception x) {
                // empty catch block
            }
        }
        if (is != null) {
            try {
                is.close();
            }
            catch (Exception x) {
                // empty catch block
            }
        }
        if (fileC == null) return fMessage;
        try {
            fileC.close();
            return fMessage;
        }
        catch (Exception x) {
            // empty catch block
        }
        return fMessage;
    }

    private void serializeGroupSubject(String subject, DataOutputStream dOS) throws UnsupportedEncodingException, IOException {
        byte[] rawBytes = subject.getBytes(Constants.CHARSET_UTF8);
        int size = Math.min(rawBytes.length, 128);
        dOS.writeByte(size);
        dOS.write(rawBytes, 0, size);
        int remaining = 128 - size;
        for (int i = 0; i < remaining; ++i) {
            dOS.writeByte(0);
        }
    }

    private String unserializeGroupSubject(DataInputStream dIS) throws IOException {
        byte size = dIS.readByte();
        byte[] rawBytes = new byte[size];
        dIS.readFully(rawBytes, 0, size);
        String subject = new String(rawBytes, Constants.CHARSET_UTF8);
        int remaining = 128 - size;
        dIS.skipBytes(remaining);
        return subject;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean getGroupInfo(String gjid, ChatHistory.Group group) {
        String filename = CommonFileMessageStore.getGroupInfoFilename(gjid);
        FileConnection fileC = null;
        InputStream is = null;
        FilterInputStream dIS = null;
        try {
            fileC = (FileConnection)Connector.open((String)filename, (int)1);
            is = fileC.openInputStream();
            dIS = new DataInputStream(is);
            group._subject = this.unserializeGroupSubject((DataInputStream)dIS);
            int partyCount = 0;
            try {
                while (true) {
                    String participant = Utilities.safeIntern(((DataInputStream)dIS).readUTF());
                    group.addParticipant(participant);
                    ++partyCount;
                }
            }
            catch (EOFException x) {
                Utilities.logData("reached end of grp metadata for " + gjid + " found " + partyCount + " parties");
                boolean bl = true;
                if (dIS != null) {
                    try {
                        dIS.close();
                    }
                    catch (Exception x2) {
                        // empty catch block
                    }
                }
                if (is != null) {
                    try {
                        is.close();
                    }
                    catch (Exception x3) {
                        // empty catch block
                    }
                }
                if (fileC != null) {
                    try {
                        fileC.close();
                    }
                    catch (Exception x3) {
                        // empty catch block
                    }
                }
                return bl;
            }
        }
        catch (Throwable t) {
            try {
                Utilities.logData("problem reading group meta info for " + gjid + " : " + t.toString());
                boolean bl = false;
                return bl;
            }
            catch (Throwable throwable) {
                throw throwable;
            }
            finally {
                if (dIS != null) {
                    try {
                        dIS.close();
                    }
                    catch (Exception x) {}
                }
                if (is != null) {
                    try {
                        is.close();
                    }
                    catch (Exception x) {}
                }
                if (fileC != null) {
                    try {
                        fileC.close();
                    }
                    catch (Exception x) {}
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean putGroupSubject(String gjid, String subject) {
        boolean bl;
        OutputStream os;
        FileConnection fileC;
        block28: {
            String filename = CommonFileMessageStore.getGroupInfoFilename(gjid);
            fileC = null;
            os = null;
            FilterOutputStream dOS = null;
            try {
                fileC = (FileConnection)Connector.open((String)filename, (int)3);
                if (!fileC.exists()) {
                    fileC.create();
                }
                os = fileC.openOutputStream(0L);
                dOS = new DataOutputStream(os);
                this.serializeGroupSubject(subject, (DataOutputStream)dOS);
                ((DataOutputStream)dOS).flush();
                bl = true;
                if (dOS == null) break block28;
            }
            catch (Throwable t) {
                try {
                    Utilities.logData("problems writing group info: " + t.toString());
                    boolean bl2 = false;
                    return bl2;
                }
                catch (Throwable throwable) {
                    throw throwable;
                }
                finally {
                    if (dOS != null) {
                        try {
                            dOS.close();
                        }
                        catch (Exception x) {}
                    }
                    if (os != null) {
                        try {
                            os.close();
                        }
                        catch (Exception x) {}
                    }
                    if (fileC != null) {
                        try {
                            fileC.close();
                        }
                        catch (Exception x) {}
                    }
                }
            }
            try {
                dOS.close();
            }
            catch (Exception x) {
                // empty catch block
            }
        }
        if (os != null) {
            try {
                os.close();
            }
            catch (Exception x) {
                // empty catch block
            }
        }
        if (fileC == null) return bl;
        try {
            fileC.close();
            return bl;
        }
        catch (Exception x) {
            // empty catch block
        }
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public boolean addGroupUser(String gjid, String jid) {
        boolean bl;
        FilterOutputStream dOS;
        OutputStream os;
        FileConnection fileC;
        block39: {
            block37: {
                boolean bl2;
                block38: {
                    String filename = CommonFileMessageStore.getGroupInfoFilename(gjid);
                    fileC = null;
                    os = null;
                    dOS = null;
                    fileC = (FileConnection)Connector.open((String)filename, (int)3);
                    if (fileC.exists()) break block37;
                    Utilities.logData("group file missing in user add " + gjid);
                    bl2 = false;
                    if (dOS == null) break block38;
                    try {
                        dOS.close();
                    }
                    catch (Exception x) {
                        // empty catch block
                    }
                }
                if (os != null) {
                    try {
                        os.close();
                    }
                    catch (Exception x) {
                        // empty catch block
                    }
                }
                if (fileC != null) {
                    try {
                        fileC.close();
                    }
                    catch (Exception x) {
                        // empty catch block
                    }
                }
                return bl2;
            }
            long offset = fileC.fileSize();
            os = fileC.openOutputStream(offset);
            dOS = new DataOutputStream(os);
            ((DataOutputStream)dOS).writeUTF(jid);
            ((DataOutputStream)dOS).flush();
            bl = true;
            if (dOS == null) break block39;
            try {
                dOS.close();
            }
            catch (Exception x) {
                // empty catch block
            }
        }
        if (os != null) {
            try {
                os.close();
            }
            catch (Exception x) {
                // empty catch block
            }
        }
        if (fileC != null) {
            try {
                fileC.close();
            }
            catch (Exception x) {
                // empty catch block
            }
        }
        return bl;
        catch (Throwable t) {
            try {
                Utilities.logData("problems adding group user: " + t.toString());
                boolean bl3 = false;
                return bl3;
            }
            catch (Throwable throwable) {
                throw throwable;
            }
            finally {
                if (dOS != null) {
                    try {
                        dOS.close();
                    }
                    catch (Exception x) {}
                }
                if (os != null) {
                    try {
                        os.close();
                    }
                    catch (Exception x) {}
                }
                if (fileC != null) {
                    try {
                        fileC.close();
                    }
                    catch (Exception x) {}
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean removeGroupUser(String gjid, String jid) {
        String filename = CommonFileMessageStore.getGroupInfoFilename(gjid);
        FileConnection oldFileC = null;
        FileConnection newFileC = null;
        InputStream is = null;
        FilterInputStream dIS = null;
        OutputStream os = null;
        FilterOutputStream dOS = null;
        Vector<String> remadeParties = new Vector<String>();
        boolean res = false;
        try {
            oldFileC = (FileConnection)Connector.open((String)filename, (int)3);
            if (!oldFileC.exists()) {
                Utilities.logData("group file " + filename + " missing in remove operation for " + jid);
                boolean bl = false;
                return bl;
            }
            long useOffset = 0L;
            is = oldFileC.openInputStream();
            dIS = new DataInputStream(is);
            byte[] rawBytes = new byte[129];
            ((DataInputStream)dIS).readFully(rawBytes, 0, 129);
            try {
                while (true) {
                    String curJid;
                    if (jid.equals(curJid = ((DataInputStream)dIS).readUTF())) {
                        continue;
                    }
                    remadeParties.addElement(curJid);
                }
            }
            catch (EOFException eofx) {
                dIS.close();
                dIS = null;
                is.close();
                is = null;
                newFileC = (FileConnection)Connector.open((String)(filename + "NEW"), (int)2);
                newFileC.create();
                Utilities.logData("created new group metadata for " + gjid);
                os = newFileC.openOutputStream();
                dOS = new DataOutputStream(os);
                dOS.write(rawBytes);
                int size = remadeParties.size();
                for (int i = 0; i < size; ++i) {
                    ((DataOutputStream)dOS).writeUTF((String)remadeParties.elementAt(i));
                }
                ((DataOutputStream)dOS).flush();
                dOS.close();
                dOS = null;
                os.close();
                os = null;
                oldFileC.delete();
                newFileC.rename(CommonFileMessageStore.getGroupInfoBasename(gjid));
                res = true;
                if (!res && newFileC != null) {
                    try {
                        newFileC.delete();
                    }
                    catch (Exception x) {
                        // empty catch block
                    }
                }
                if (dIS != null) {
                    try {
                        dIS.close();
                    }
                    catch (Exception x) {
                        // empty catch block
                    }
                }
                if (is != null) {
                    try {
                        is.close();
                    }
                    catch (Exception x) {
                        // empty catch block
                    }
                }
                if (oldFileC != null) {
                    try {
                        oldFileC.close();
                    }
                    catch (Exception x) {
                        // empty catch block
                    }
                }
                if (dOS != null) {
                    try {
                        dOS.close();
                    }
                    catch (Exception x) {
                        // empty catch block
                    }
                }
                if (os != null) {
                    try {
                        os.close();
                    }
                    catch (Exception x) {
                        // empty catch block
                    }
                }
                if (newFileC != null) {
                    try {
                        newFileC.close();
                    }
                    catch (Exception x) {}
                }
            }
        }
        catch (Throwable t) {
            Utilities.logData("encountered problem deleting user " + jid + " from group " + gjid + " " + t.toString());
        }
        finally {
            if (!res && newFileC != null) {
                try {
                    newFileC.delete();
                }
                catch (Exception x) {}
            }
            if (dIS != null) {
                try {
                    dIS.close();
                }
                catch (Exception x) {}
            }
            if (is != null) {
                try {
                    is.close();
                }
                catch (Exception x) {}
            }
            if (oldFileC != null) {
                try {
                    oldFileC.close();
                }
                catch (Exception x) {}
            }
            if (dOS != null) {
                try {
                    dOS.close();
                }
                catch (Exception x) {}
            }
            if (os != null) {
                try {
                    os.close();
                }
                catch (Exception x) {}
            }
            if (newFileC != null) {
                try {
                    newFileC.close();
                }
                catch (Exception x) {}
            }
        }
        return res;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public long addMMSFilename(String MMSFilename, String scaledMMSFilename) {
        long l;
        OutputStream os;
        FileConnection fileC;
        block29: {
            String filename = CommonFileMessageStore.getMMSStoreFilename();
            fileC = null;
            os = null;
            FilterOutputStream dOS = null;
            try {
                long offset;
                fileC = (FileConnection)Connector.open((String)filename, (int)3);
                if (!fileC.exists()) {
                    fileC.create();
                    offset = 0L;
                } else {
                    offset = fileC.fileSize();
                }
                os = fileC.openOutputStream(offset);
                dOS = new DataOutputStream(os);
                Utilities.safeStringOut(MMSFilename, (DataOutputStream)dOS);
                Utilities.safeStringOut(scaledMMSFilename, (DataOutputStream)dOS);
                ((DataOutputStream)dOS).flush();
                l = offset;
                if (dOS == null) break block29;
            }
            catch (Throwable t) {
                try {
                    Utilities.logData("problems adding mms filename to store: " + t.toString());
                    long l2 = -1L;
                    return l2;
                }
                catch (Throwable throwable) {
                    throw throwable;
                }
                finally {
                    if (dOS != null) {
                        try {
                            dOS.close();
                        }
                        catch (Exception x) {}
                    }
                    if (os != null) {
                        try {
                            os.close();
                        }
                        catch (Exception x) {}
                    }
                    if (fileC != null) {
                        try {
                            fileC.close();
                        }
                        catch (Exception x) {}
                    }
                }
            }
            try {
                dOS.close();
            }
            catch (Exception x) {
                // empty catch block
            }
        }
        if (os != null) {
            try {
                os.close();
            }
            catch (Exception x) {
                // empty catch block
            }
        }
        if (fileC == null) return l;
        try {
            fileC.close();
            return l;
        }
        catch (Exception x) {
            // empty catch block
        }
        return l;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public String[] getMMSFilenames(long offset) {
        String[] stringArray;
        FilterInputStream dIS;
        InputStream is;
        FileConnection fileC;
        block39: {
            block37: {
                String[] stringArray2;
                block38: {
                    String filename = CommonFileMessageStore.getMMSStoreFilename();
                    fileC = null;
                    is = null;
                    dIS = null;
                    fileC = (FileConnection)Connector.open((String)filename, (int)1);
                    if (fileC.exists()) break block37;
                    stringArray2 = null;
                    if (dIS == null) break block38;
                    try {
                        dIS.close();
                    }
                    catch (Exception x) {
                        // empty catch block
                    }
                }
                if (is != null) {
                    try {
                        is.close();
                    }
                    catch (Exception x) {
                        // empty catch block
                    }
                }
                if (fileC != null) {
                    try {
                        fileC.close();
                    }
                    catch (Exception x) {
                        // empty catch block
                    }
                }
                return stringArray2;
            }
            is = fileC.openInputStream();
            is.skip(offset);
            dIS = new DataInputStream(is);
            String[] res = new String[]{Utilities.readBlankAsNull((DataInputStream)dIS), Utilities.readBlankAsNull((DataInputStream)dIS)};
            stringArray = res;
            if (dIS == null) break block39;
            try {
                dIS.close();
            }
            catch (Exception x) {
                // empty catch block
            }
        }
        if (is != null) {
            try {
                is.close();
            }
            catch (Exception x) {
                // empty catch block
            }
        }
        if (fileC != null) {
            try {
                fileC.close();
            }
            catch (Exception x) {
                // empty catch block
            }
        }
        return stringArray;
        catch (Throwable t) {
            try {
                Utilities.logData("problems getting mms filename from store: " + t.toString());
                String[] stringArray3 = null;
                return stringArray3;
            }
            catch (Throwable throwable) {
                throw throwable;
            }
            finally {
                if (dIS != null) {
                    try {
                        dIS.close();
                    }
                    catch (Exception x) {}
                }
                if (is != null) {
                    try {
                        is.close();
                    }
                    catch (Exception x) {}
                }
                if (fileC != null) {
                    try {
                        fileC.close();
                    }
                    catch (Exception x) {}
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean addExternalThumbnail(FunXMPP.FMessage.Key key, byte[] imgData) {
        FileConnection fileC;
        int curCount;
        FunXMPP.FMessage sourceMsg;
        block24: {
            sourceMsg = this.getMessage(key);
            if (sourceMsg == null) {
                return false;
            }
            MediaData sourceMD = (MediaData)sourceMsg.thumb_image;
            if (sourceMD == null) {
                Utilities.logData("trying to add thumbnail to " + key + " but it has no md");
                return false;
            }
            curCount = sourceMD.externalThumbCount;
            if (curCount < 0) {
                curCount = 0;
            }
            String thumbName = CommonFileMessageStore.getThumbFullPath(key) + ++curCount;
            fileC = null;
            OutputStream os = null;
            try {
                fileC = (FileConnection)Connector.open((String)thumbName, (int)3);
                if (!fileC.exists()) {
                    fileC.create();
                }
                os = fileC.openOutputStream();
                os.write(imgData, 0, imgData.length);
                os.flush();
                if (os == null) break block24;
            }
            catch (Throwable t) {
                try {
                    Utilities.logData("blowup writing thumb file: " + thumbName + ' ' + t.toString());
                    boolean bl = false;
                    return bl;
                }
                catch (Throwable throwable) {
                    throw throwable;
                }
                finally {
                    if (os != null) {
                        try {
                            os.close();
                        }
                        catch (Exception x) {}
                    }
                    if (fileC != null) {
                        try {
                            fileC.close();
                        }
                        catch (Exception x) {}
                    }
                }
            }
            try {
                os.close();
            }
            catch (Exception x) {
                // empty catch block
            }
        }
        if (fileC != null) {
            try {
                fileC.close();
            }
            catch (Exception x) {}
        }
        sourceMD.externalThumbCount = curCount;
        return this.updateMessageStatus(sourceMsg, true);
    }

    public String getExternalThumbnailFile(FunXMPP.FMessage.Key key, int thumbIndex) {
        return CommonFileMessageStore.getThumbFullPath(key) + thumbIndex;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void makeExternalThumbnailDir() {
        FileConnection fileC = null;
        try {
            fileC = (FileConnection)Connector.open((String)CommonFileMessageStore.getThumbsArchive(), (int)3);
            if (!fileC.exists()) {
                fileC.mkdir();
            }
        }
        catch (Throwable t) {
            Utilities.logData("couldn't create thumbs external dir: " + t.toString());
        }
        finally {
            if (fileC != null) {
                try {
                    fileC.close();
                }
                catch (Exception exception) {}
            }
        }
    }

    public static class IndexRecord {
        public static final int RECORD_SIZE = 64;
        public static final byte MAGIC_BYTE = -8;
        public String id;
        public boolean from_me;
        public long offset;

        public IndexRecord() {
        }

        public IndexRecord(FunXMPP.FMessage fmsg, long offset) {
            this.id = fmsg.key.id;
            this.from_me = fmsg.key.from_me;
            this.offset = offset;
        }

        public static IndexRecord unserialize(DataInputStream dIS) throws IOException, EOFException {
            IndexRecord ndxRec = new IndexRecord();
            ndxRec.id = dIS.readUTF();
            ndxRec.from_me = dIS.readBoolean();
            ndxRec.offset = dIS.readLong();
            int usedLen = 2 + ndxRec.id.length() + 1 + 8;
            int remaining = 64 - usedLen;
            dIS.skipBytes(remaining);
            return ndxRec;
        }

        public static void serialize(IndexRecord ndxRec, DataOutputStream dOS) throws IOException {
            int usedLen = 2 + ndxRec.id.length() + 1 + 8;
            if (usedLen > 64) {
                throw new IllegalStateException("index record too large! id was " + ndxRec.id);
            }
            dOS.writeUTF(ndxRec.id);
            dOS.writeBoolean(ndxRec.from_me);
            dOS.writeLong(ndxRec.offset);
            int remaining = 64 - usedLen;
            for (int i = 0; i < remaining; ++i) {
                dOS.writeByte(-8);
            }
        }
    }
}

