/*
 * Decompiled with CFR 0.152.
 */
package com.whatsapp.client;

import com.whatsapp.api.ui.EmojiTextField;
import com.whatsapp.api.ui.FieldManager;
import com.whatsapp.api.ui.ImageField;
import com.whatsapp.api.util.Utilities;
import com.whatsapp.client.ChatPane;
import com.whatsapp.client.ChatsListItem;
import com.whatsapp.client.Constants;
import com.whatsapp.client.FGApp;
import com.whatsapp.client.FunXMPP;
import com.whatsapp.client.MediaData;
import com.whatsapp.client.MediaDisplay;
import com.whatsapp.client.MessageStatusIcon;
import com.whatsapp.client.Res;
import javax.microedition.lcdui.Font;
import javax.microedition.lcdui.Image;

public class ChatLine
extends FieldManager {
    public static final Font DESC_FONT = ChatsListItem.smallFont;
    private MessageStatusIcon _icon;
    public FunXMPP.FMessage _fmsg;
    private ChatPane _parentScr;
    private EmojiTextField _descLabel;
    private ImageField _thumbImgFld;

    private String getMMSLabel() {
        MediaData md = (MediaData)this._fmsg.thumb_image;
        if (md != null && (this._fmsg.status & 0x100) > 0) {
            if (FGApp.getInstance().getMMSState() == 2) {
                return Res.getString(64);
            }
            return Res.getString(87) + FGApp.getInstance().getXferProgress() + "%";
        }
        if (md != null && this._fmsg.status == 1) {
            if (FGApp.getInstance().getMMSState() == 2) {
                return Res.getString(64);
            }
            return Res.getString(169) + FGApp.getInstance().getXferProgress() + "%";
        }
        if (md != null && this._fmsg.key.from_me && MediaData.hasURL(this._fmsg.media_wa_type) && (this._fmsg.media_url == null || this._fmsg.media_url.length() == 0)) {
            return Res.getString(108);
        }
        if (md != null && md.downloaded) {
            return Res.getString(172, MediaDisplay.getLocalizedFMessageType(this._fmsg));
        }
        return Res.getString(86, MediaDisplay.getLocalizedFMessageType(this._fmsg));
    }

    private void addMMSElements(FunXMPP.FMessage fmsg, boolean showReadableType) {
        MediaData md = (MediaData)fmsg.thumb_image;
        if (md != null && md.thumbnail != null) {
            this.addImageField(md.thumbnail);
        }
        if (showReadableType) {
            this.addTextField(this.getMMSLabel(), 2);
        }
    }

    public ChatLine(FunXMPP.FMessage fmsg, ChatPane parentScr) {
        super(0L, false);
        this._parentScr = parentScr;
        this._fmsg = fmsg;
        if (fmsg.key.from_me || fmsg.media_wa_type == 7) {
            this._icon = new MessageStatusIcon(fmsg, 0L);
            this.add(this._icon);
        }
        fmsg.acceptVisitor(new FunXMPP.FMessageVisitor(){

            public void undefined(FunXMPP.FMessage fMessage) {
                ChatLine.this.addFlowTextField(fMessage);
            }

            public void image(FunXMPP.FMessage fMessage) {
                ChatLine.this.addMMSElements(fMessage, true);
            }

            public void audio(FunXMPP.FMessage fMessage) {
                ChatLine.this.addMMSElements(fMessage, true);
            }

            public void video(FunXMPP.FMessage fMessage) {
                ChatLine.this.addMMSElements(fMessage, true);
            }

            public void contact(FunXMPP.FMessage fMessage) {
                ChatLine.this.addMMSElements(fMessage, false);
            }

            public void location(FunXMPP.FMessage fMessage) {
                ChatLine.this.addMMSElements(fMessage, false);
            }

            public void system(FunXMPP.FMessage fMessage) {
                ChatLine.this.addFlowTextField(fMessage);
            }
        });
    }

    public boolean isGroupable(ChatLine other) {
        if ((this._fmsg.status & 0xF) == 6 || (other._fmsg.status & 0xF) == 6) {
            return false;
        }
        if (this._fmsg.key.from_me != other._fmsg.key.from_me) {
            return false;
        }
        if (!this._fmsg.key.remote_jid.equals(other._fmsg.key.remote_jid)) {
            return false;
        }
        if (!(this._fmsg.remote_resource == other._fmsg.remote_resource || this._fmsg.remote_resource != null && this._fmsg.remote_resource.equals(other._fmsg.remote_resource))) {
            return false;
        }
        return this._fmsg.media_wa_type == 0 && other._fmsg.media_wa_type == 0;
    }

    private void addTextField(String text, int align) {
        this._descLabel = new EmojiTextField(text, DESC_FONT);
        this._descLabel.setAlign(align);
        this.add(this._descLabel);
        this._descLabel.setMargin(1, 1, 1, 1);
    }

    public void updateMMSLabel() {
        this._descLabel.setText(this.getMMSLabel());
    }

    public void setLabel(String s) {
        this._descLabel.setText(s);
    }

    private void addFlowTextField(FunXMPP.FMessage fmsg) {
        String useText = Constants.STRING_EMPTY_STRING;
        if (fmsg.data != null) {
            useText = fmsg.data;
        }
        EmojiTextField etF = new EmojiTextField(useText, ChatsListItem.smallFont);
        etF.setMargin(1, 1, 1, 1);
        this.add(etF);
    }

    private void addImageField(Image image) {
        this._thumbImgFld = new ImageField(image);
        this.add(this._thumbImgFld);
        this._thumbImgFld.setMargin(1, 1, 1, 1);
    }

    public boolean reloadFMsg() {
        if (this._fmsg == null) {
            return false;
        }
        FunXMPP.FMessage.Key mykey = this._fmsg.key;
        this._fmsg = FGApp.getInstance().getMessageStore().getMessage(mykey);
        MediaData md = (MediaData)this._fmsg.thumb_image;
        if (md != null) {
            md.inflate();
            if (this._thumbImgFld != null) {
                this._thumbImgFld.setImage(md.thumbnail);
            }
        }
        Utilities.logData("reloaded msg " + this._fmsg.key.id + " with thumbs " + md.externalThumbCount + " and filenames " + md.filename + ", " + md.scaledFilename);
        return true;
    }
}

