/*
 * Decompiled with CFR 0.152.
 */
package com.whatsapp.client;

import com.whatsapp.api.contacts.ContactFileSystemStore;
import com.whatsapp.api.util.Utilities;
import com.whatsapp.client.ChatHistory;
import com.whatsapp.client.Constants;
import com.whatsapp.client.FGApp;
import com.whatsapp.client.FunXMPP;
import com.whatsapp.client.MessageStore;
import com.whatsapp.client.Serializer;
import java.io.IOException;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;

public class ChatHistoryCache {
    private Hashtable _chatsHash = new Hashtable();
    private Vector _naturalOrder = new Vector();

    private void initOneChatHistory(MessageStore mStore, ChatHistory curChat) {
        Vector lastMessageVec;
        String jid = curChat._jid;
        if (curChat._group != null) {
            mStore.getGroupInfo(jid, curChat._group);
            Utilities.logData("history cache init saw group " + curChat._group._subject + " with " + curChat._group.numParties() + " parties");
        }
        if ((lastMessageVec = mStore.getMessagesBefore(jid, null, 1, null)).size() == 0) {
            Utilities.logData("chat returned for " + jid + " but no messages");
        } else {
            FunXMPP.FMessage lastMsg = (FunXMPP.FMessage)lastMessageVec.elementAt(0);
            curChat.update(lastMsg);
        }
        this._chatsHash.put(jid, curChat);
        this._naturalOrder.addElement(jid);
    }

    public synchronized void initialize(MessageStore mStore) {
        Vector chats = mStore.getChats();
        for (int i = 0; i < chats.size(); ++i) {
            ChatHistory curChat = (ChatHistory)chats.elementAt(i);
            this.initOneChatHistory(mStore, curChat);
        }
        Utilities.logData("initialized CH cache from disk with size " + this._chatsHash.size());
    }

    public synchronized void initialize(byte[] data) throws IOException {
        ChatHistory newHistory = Serializer.unserializeChatHistory(data);
        Utilities.logData("soft init of chat history " + newHistory._jid);
        if (this._chatsHash.get(newHistory._jid) != null) {
            if (newHistory._group != null) {
                ChatHistory existingHist = (ChatHistory)this._chatsHash.get(newHistory._jid);
                existingHist.updateGroupChat(newHistory._group._owner, (int)(newHistory._group._creation / 1000L), newHistory._group._subject, newHistory._group._subjectT);
                if (existingHist._lastExcerpt == null || existingHist._lastExcerpt.length() == 0) {
                    existingHist.updateForcedGroup(newHistory);
                }
            }
        } else {
            String launchJid = FGApp.getInstance().getLaunchJid();
            if (launchJid != null && newHistory._jid.equals(launchJid) && newHistory.isDirty()) {
                newHistory._lastStatus = 0;
            }
            this._chatsHash.put(newHistory._jid, newHistory);
            this._naturalOrder.addElement(newHistory._jid);
        }
    }

    public ChatHistory get(String jid) {
        return (ChatHistory)this._chatsHash.get(jid);
    }

    private synchronized ChatHistory getOrAddHistory(String jid, boolean isGroup) {
        ChatHistory curChat = (ChatHistory)this._chatsHash.get(jid);
        if (curChat == null) {
            curChat = new ChatHistory(jid, isGroup);
            this._chatsHash.put(jid, curChat);
            this._naturalOrder.addElement(jid);
        } else if (isGroup && curChat._group == null) {
            Utilities.logData("get or add expected group in this history for " + jid);
            curChat._group = new ChatHistory.Group();
        }
        return curChat;
    }

    public void newMessage(FunXMPP.FMessage message) {
        ChatHistory curChat = this.getOrAddHistory(message.key.remote_jid, false);
        curChat.update(message);
    }

    public void messageReceipt(FunXMPP.FMessage.Key msgKey, int status) {
        ChatHistory curChat = (ChatHistory)this._chatsHash.get(msgKey.remote_jid);
        if (curChat != null) {
            curChat.updateStatus(msgKey, status);
        }
    }

    public synchronized void chatHistoryDeleted(String jid) {
        this._chatsHash.remove(jid);
        this._naturalOrder.removeElement(jid);
    }

    public void newContactChatState(String jid, int newState) {
        ChatHistory curChat = (ChatHistory)this._chatsHash.get(jid);
        if (curChat != null) {
            curChat._typing = newState == 0;
        }
    }

    public void updateReadableNames() {
        Enumeration en = this._chatsHash.elements();
        while (en.hasMoreElements()) {
            ChatHistory curHist = (ChatHistory)en.nextElement();
            if (curHist._group != null || curHist._readableName != null) continue;
            curHist._readableName = ContactFileSystemStore.getByJid(curHist._jid);
        }
    }

    public ChatHistory getNatural(int index) {
        if (index < 0 || index >= this._naturalOrder.size()) {
            return null;
        }
        String key = (String)this._naturalOrder.elementAt(index);
        return (ChatHistory)this._chatsHash.get(key);
    }

    public int getNaturalIndexOfJid(String jid) {
        if (!this._chatsHash.containsKey(jid)) {
            return -1;
        }
        return this._naturalOrder.indexOf(jid);
    }

    public Vector getSortedList() {
        Vector<ChatHistory> v = new Vector<ChatHistory>(this._chatsHash.size());
        Enumeration en = this._chatsHash.elements();
        while (en.hasMoreElements()) {
            ChatHistory curHist = (ChatHistory)en.nextElement();
            boolean placed = false;
            for (int i = 0; i < v.size(); ++i) {
                ChatHistory existingHist = (ChatHistory)v.elementAt(i);
                if (curHist._lastTimestamp <= existingHist._lastTimestamp) continue;
                v.insertElementAt(curHist, i);
                placed = true;
                break;
            }
            if (placed) continue;
            v.addElement(curHist);
        }
        return v;
    }

    public int size() {
        return this._chatsHash.size();
    }

    public int dirtyCount() {
        int res = 0;
        Enumeration en = this._chatsHash.elements();
        while (en.hasMoreElements()) {
            ChatHistory curHist = (ChatHistory)en.nextElement();
            if (!curHist.isDirty()) continue;
            ++res;
        }
        return res;
    }

    public int dirtyCountWithPayload(ChatHistory[] outArr) {
        int res = 0;
        Enumeration en = this._chatsHash.elements();
        while (en.hasMoreElements()) {
            ChatHistory curHist = (ChatHistory)en.nextElement();
            if (!curHist.isDirty()) continue;
            if (res < outArr.length) {
                outArr[res] = curHist;
            }
            ++res;
        }
        return res;
    }

    public String addGroupChat(String gid, String ownerJid, int creationT, String subject, int subjectT) {
        ChatHistory curChat = this.getOrAddHistory(gid, true);
        return curChat.updateGroupChat(ownerJid, creationT, subject, subjectT);
    }

    public boolean groupChatAddUser(String gid, String ujid) {
        ChatHistory curChat = this.getOrAddHistory(gid, true);
        return curChat._group.addParticipant(ujid);
    }

    public boolean groupChatRemoveUser(String gid, String ujid) {
        ChatHistory curChat = this.getOrAddHistory(gid, true);
        return curChat._group.removeParticipant(ujid);
    }

    public ChatHistory.Group getGroupChat(String gid, boolean force) {
        if (force) {
            ChatHistory curHist = this.getOrAddHistory(gid, true);
            return curHist._group;
        }
        ChatHistory curHist = (ChatHistory)this._chatsHash.get(gid);
        if (curHist != null) {
            return curHist._group;
        }
        return null;
    }

    public String getBGReadableName(String jid) {
        if (jid == null) {
            return Constants.STRING_EMPTY_STRING;
        }
        ChatHistory dummyHist = (ChatHistory)this._chatsHash.get(jid);
        if (dummyHist != null && dummyHist._readableName != null && dummyHist._readableName.length() > 0) {
            return dummyHist._readableName;
        }
        String useName = ContactFileSystemStore.getByJid(jid);
        if (useName != null && useName.length() > 0) {
            return useName;
        }
        return ChatHistory.getDisplayablePlainJid(jid);
    }
}

