/*
 * Decompiled with CFR 0.152.
 */
package com.whatsapp.client;

import com.whatsapp.api.contacts.ContactFileSystemStore;
import com.whatsapp.api.util.Utilities;
import com.whatsapp.client.Constants;
import com.whatsapp.client.FunXMPP;
import com.whatsapp.client.MediaDisplay;
import java.util.Vector;

public class ChatHistory {
    public String _jid;
    public String _readableName;
    public String _lastID;
    public boolean _lastFromMe;
    public long _lastTimestamp;
    public String _lastExcerpt;
    public int _lastStatus;
    public boolean _typing;
    public Group _group;

    public ChatHistory() {
    }

    public ChatHistory(String jid) {
        this(jid, false);
    }

    public ChatHistory(String jid, boolean isGroup) {
        this._jid = jid;
        if (isGroup) {
            this._group = new Group();
        }
    }

    public synchronized void update(FunXMPP.FMessage message) {
        this._lastStatus = message.status;
        this._lastID = message.key.id;
        this._lastFromMe = message.key.from_me;
        this._lastTimestamp = message.timestamp;
        this._lastExcerpt = ChatHistory.getPreviewText(message, 50);
        this._typing = false;
        if (this._group != null) {
            this._group._lastParty = message.remote_resource;
        } else if (this._readableName == null) {
            this._readableName = ContactFileSystemStore.getByJid(this._jid);
        }
    }

    public synchronized void updateForcedGroup(ChatHistory oldHist) {
        this._lastID = oldHist._lastID;
        this._lastFromMe = oldHist._lastFromMe;
        this._lastStatus = oldHist._lastStatus & 0xFFFFFF7F;
        this._lastTimestamp = oldHist._lastTimestamp;
        this._lastExcerpt = oldHist._lastExcerpt;
        this._group._lastParty = oldHist._group._lastParty;
    }

    public synchronized void updateStatus(FunXMPP.FMessage.Key msgKey, int status) {
        if (this._lastID != null && this._lastID.equals(msgKey.id)) {
            this._lastStatus = status;
        }
    }

    public boolean isDirty() {
        return !this._lastFromMe && (this._lastStatus & 0x80) > 0;
    }

    public static String getPreviewText(FunXMPP.FMessage message, int len) {
        if (message == null) {
            return Constants.STRING_EMPTY_STRING;
        }
        if (message.media_wa_type == 0 || message.media_wa_type == 7) {
            if (message.data == null) {
                return Constants.STRING_EMPTY_STRING;
            }
            if (message.data.length() > len) {
                return message.data.substring(0, len) + "...";
            }
            return message.data;
        }
        return MediaDisplay.getLocalizedFMessageType(message);
    }

    public static String getDisplayablePlainJid(String jid) {
        int firstAt = jid.indexOf(64);
        if (firstAt < 0) {
            return jid;
        }
        String newPhone = jid.substring(0, firstAt);
        if (Character.isDigit(jid.charAt(0))) {
            newPhone = "+" + newPhone;
        }
        return newPhone;
    }

    public synchronized String updateGroupChat(String ownerJid, int creationT, String subject, int subjectT) {
        if (this._group == null) {
            Utilities.logData("updateGroupChat called on group-less history. startup race with new message?");
            this._group = new Group();
        }
        String oldSubject = this._group._subject;
        if (subject != null && subjectT >= this._group._subjectT) {
            this._group._subject = subject;
            this._group._subjectT = subjectT;
            if ((long)(subjectT * 1000) > this._lastTimestamp) {
                this._lastTimestamp = (long)subjectT * 1000L;
            }
        }
        if (ownerJid != null) {
            this._group._owner = ownerJid;
        }
        if (creationT > 0) {
            this._group._creation = new Long((long)creationT * 1000L);
            if (this._group._creation > this._lastTimestamp) {
                this._lastTimestamp = this._group._creation;
            }
        }
        return oldSubject;
    }

    public static class GroupPlusMetadata {
        public String gjid;
        String owner;
        String subject;
        String subject_owner_jid;
        int subject_t;
        int creation;
    }

    public static class Group {
        public String _subject = Constants.STRING_EMPTY_STRING;
        public int _subjectT = 0;
        public String _owner = Constants.STRING_EMPTY_STRING;
        public int _userAddT;
        public Long _creation = new Long(0L);
        public boolean _createPending = false;
        public String _lastParty = null;
        private Vector _participants = new Vector(8, 1);

        public synchronized boolean addParticipant(String jid) {
            boolean wasIn = this._participants.contains(jid);
            if (!wasIn) {
                this._participants.addElement(jid);
                return true;
            }
            return false;
        }

        public synchronized boolean removeParticipant(String jid) {
            return this._participants.removeElement(jid);
        }

        public int numParties() {
            return this._participants.size();
        }

        public void computeAddDropSets(Vector newList, Vector outAdds, Vector outDrops) {
            int i;
            int s = newList.size();
            for (i = 0; i < s; ++i) {
                String newJid = (String)newList.elementAt(i);
                if (this._participants.contains(newJid)) continue;
                outAdds.addElement(newJid);
            }
            s = this._participants.size();
            for (i = 0; i < s; ++i) {
                String oldJid = (String)this._participants.elementAt(i);
                if (newList.contains(oldJid)) continue;
                outDrops.addElement(oldJid);
            }
        }
    }
}

