/*
 * Decompiled with CFR 0.152.
 */
package com.whatsapp.client;

import com.whatsapp.api.util.Utilities;
import com.whatsapp.client.ChatPane;
import com.whatsapp.client.Constants;
import com.whatsapp.client.FGApp;
import com.whatsapp.client.Res;
import com.whatsapp.client.test.ContactListMidlet;
import java.io.OutputStream;
import javax.microedition.io.Connector;
import javax.microedition.io.file.FileConnection;
import javax.microedition.lcdui.Alert;
import javax.microedition.lcdui.AlertType;
import javax.microedition.lcdui.Command;
import javax.microedition.lcdui.CommandListener;
import javax.microedition.lcdui.Displayable;
import javax.microedition.lcdui.Form;
import javax.microedition.lcdui.Item;
import javax.microedition.media.Manager;
import javax.microedition.media.Player;
import javax.microedition.media.control.VideoControl;

public class CameraForm
extends Form
implements CommandListener {
    private Command _cancelCmd = new Command(Res.getString(63), 3, 1);
    private Command _captureCmd = new Command(Res.getString(66), 4, 1);
    private Player _player;
    private VideoControl _vControl;
    private ChatPane _chatPane;

    public CameraForm(ChatPane chatPane) {
        super(Res.getString(62));
        this._chatPane = chatPane;
        this.addCommand(this._cancelCmd);
        this.setCommandListener(this);
        this.append(Res.getString(103));
        BGLoader loader = new BGLoader();
        loader.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void commandAction(Command cmd, Displayable dsplbl) {
        if (cmd == this._cancelCmd) {
            this.mmCleanup();
            FGApp.getInstance().setTopPane(this._chatPane);
            ContactListMidlet.getInstance()._display.setCurrent((Displayable)this._chatPane);
        } else if (cmd == this._captureCmd) {
            this.setTitle(Res.getString(142));
            this.removeCommand(this._captureCmd);
            this.removeCommand(this._cancelCmd);
            FileConnection fileC = null;
            OutputStream os = null;
            boolean success = false;
            String errorTxt = Constants.STRING_EMPTY_STRING;
            String filename = null;
            try {
                byte[] jpegData = this._vControl.getSnapshot("encoding=image/jpeg&width=640&height=480&quality=80");
                String photoDir = System.getProperty("fileconn.dir.photos");
                filename = photoDir + "WA-" + System.currentTimeMillis() + ".jpg";
                fileC = (FileConnection)Connector.open((String)filename, (int)3);
                if (!fileC.exists()) {
                    fileC.create();
                }
                os = fileC.openOutputStream();
                os.write(jpegData);
                os.flush();
                success = true;
            }
            catch (Throwable t) {
                Utilities.logData("capture blowup: " + t.toString());
                errorTxt = t.toString();
            }
            finally {
                if (os != null) {
                    try {
                        os.close();
                    }
                    catch (Exception x) {}
                }
                if (fileC != null) {
                    try {
                        fileC.close();
                    }
                    catch (Exception x) {}
                }
            }
            this.mmCleanup();
            FGApp.getInstance().setTopPane(this._chatPane);
            if (success) {
                String sapiFilename = filename.substring(8);
                ContactListMidlet.getInstance()._display.setCurrent((Displayable)this._chatPane);
                this._chatPane.gotMMSFileSelected((byte)1, Constants.MEDIA_MIME_TYPE_JPEG, Constants.STRING_EMPTY_STRING, sapiFilename, 0L);
            } else {
                Alert byeAlert = new Alert(Res.getString(170), errorTxt, null, AlertType.ERROR);
                ContactListMidlet.getInstance()._display.setCurrent(byeAlert, (Displayable)this._chatPane);
            }
        }
    }

    private synchronized void mmCleanup() {
        if (this._player != null) {
            try {
                this._player.stop();
            }
            catch (Exception exception) {
                // empty catch block
            }
            this._player.close();
            this._player = null;
        }
    }

    private class BGLoader
    extends Thread {
        private BGLoader() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            Object fileC = null;
            Object is = null;
            boolean result = false;
            String errorTxt = Constants.STRING_EMPTY_STRING;
            try {
                CameraForm.this._player = Manager.createPlayer((String)"capture://image");
                CameraForm.this._player.realize();
                CameraForm.this._player.prefetch();
                CameraForm.this._vControl = (VideoControl)CameraForm.this._player.getControl("VideoControl");
                if (CameraForm.this._vControl != null) {
                    Item vItem = (Item)CameraForm.this._vControl.initDisplayMode(0, null);
                    CameraForm.this.deleteAll();
                    CameraForm.this._vControl.setDisplaySize(CameraForm.this.getWidth(), CameraForm.this.getHeight() - 40);
                    CameraForm.this.append(vItem);
                    CameraForm.this._player.start();
                    CameraForm.this.addCommand(CameraForm.this._captureCmd);
                    result = true;
                }
            }
            catch (Throwable t) {
                Utilities.logData("capture window loader died: " + t.toString());
                errorTxt = t.toString();
            }
            if (!result) {
                CameraForm.this.mmCleanup();
                Alert byeAlert = new Alert(Res.getString(170), errorTxt, null, AlertType.ERROR);
                FGApp.getInstance().setTopPane(CameraForm.this._chatPane);
                ContactListMidlet.getInstance()._display.setCurrent(byeAlert, (Displayable)CameraForm.this._chatPane);
            }
        }
    }
}

