/*
 * Decompiled with CFR 0.152.
 */
package com.whatsapp.client;

import com.whatsapp.api.ui.Command;
import com.whatsapp.api.ui.EmojiTextField;
import com.whatsapp.api.ui.FieldManager;
import com.whatsapp.api.ui.UIField;
import com.whatsapp.api.util.DateTimeUtilities;
import com.whatsapp.api.util.Utilities;
import com.whatsapp.client.ApplicationData;
import com.whatsapp.client.CanvasScreen;
import com.whatsapp.client.Constants;
import com.whatsapp.client.FGApp;
import com.whatsapp.client.Res;
import com.whatsapp.client.test.ContactListMidlet;
import java.io.IOException;
import javax.microedition.lcdui.Alert;
import javax.microedition.lcdui.AlertType;
import javax.microedition.lcdui.Displayable;
import javax.microedition.lcdui.Font;

public class AboutForm
extends CanvasScreen {
    private static final Font LINK_FONT = Font.getFont((int)0, (int)4, (int)0);
    private final Command _supportCommand = new Command(Res.getString(73), Command.ITEM, 1);
    private final Command _closeCommand = new Command(Res.getString(70), Command.BACK, 1);
    private final Command _goCommand = new Command(Res.getString(2), Command.ITEM, 0);

    public AboutForm() {
        super(0xFFFFFF);
        long expDate;
        FieldManager vfm = new FieldManager(8L, true);
        String version = Utilities.getMidletVersion();
        EmojiTextField aboutText = new EmojiTextField(Res.getString(0, version));
        aboutText.setMargin(5, 5, 20, 5);
        vfm.add(aboutText);
        long installDate = ApplicationData.installDate();
        if (installDate > 0L) {
            expDate = installDate + 7776000000L;
            expDate = Math.min(expDate, 1324319075000L);
        } else {
            expDate = 1324319075000L;
        }
        EmojiTextField upgradeText = new EmojiTextField(Res.getString(1) + ':' + '\n' + DateTimeUtilities.dayOfYear(expDate) + ',' + ' ' + DateTimeUtilities.shortTimeFormat(expDate));
        upgradeText.setMargin(5, 5, 5, 5);
        EmojiTextField upgradeLink = new EmojiTextField(Res.getString(3), LINK_FONT);
        upgradeLink.setMargin(0, 5, 0, 5);
        upgradeLink.addFieldCommand(this._goCommand);
        vfm.add(upgradeText);
        vfm.add(upgradeLink);
        this.addField(vfm);
        this.addCommand(this._supportCommand);
        this.addCommand(this._closeCommand);
    }

    public boolean commandAction(Command cmd, UIField field) {
        if (cmd == this._supportCommand) {
            FGApp.getInstance().contactSupport();
        } else if (cmd == this._closeCommand) {
            FGApp fgApp = FGApp.getInstance();
            ContactListMidlet.getInstance()._display.setCurrent((Displayable)fgApp.getMainScreen());
            fgApp.setTopPane(fgApp.getMainScreen());
        } else if (cmd == this._goCommand) {
            try {
                ContactListMidlet.getInstance().platformRequest(Constants.URL_OTA_INSTALL);
            }
            catch (Exception x) {
                Alert errAlert = new Alert(Res.getString(4), Res.getString(5) + ' ' + Constants.URL_OTA_INSTALL, null, AlertType.ERROR);
                ContactListMidlet.getInstance()._display.setCurrent((Displayable)errAlert);
            }
        } else {
            return super.commandAction(cmd, field);
        }
        return true;
    }

    static {
        try {
            Utilities.logData("res/load/about");
            Res.load("about");
        }
        catch (IOException ex) {
            Utilities.logData("res/load/about/io-error: " + ex.toString());
        }
    }
}

