/*
 * Decompiled with CFR 0.152.
 */
package com.whatsapp.api.util;

import com.whatsapp.api.util.FileNotFoundException;
import com.whatsapp.api.util.Serializer;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.FilterInputStream;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.ref.WeakReference;
import java.util.Enumeration;
import java.util.Vector;
import javax.microedition.io.Connector;
import javax.microedition.io.file.FileConnection;

public class RandomAccessDatabase {
    public final String indexFilename;
    public final String dataFilename;
    public final String countFilename;
    public final Serializer serializer;

    public RandomAccessDatabase(String indexFilename, String dataFilename, String countFilename, Serializer serializer) {
        this.indexFilename = indexFilename;
        this.dataFilename = dataFilename;
        this.countFilename = countFilename;
        this.serializer = serializer;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int write(Enumeration en) throws IOException {
        FileConnection dataFileC = null;
        FileConnection idxFileC = null;
        FileConnection countFileC = null;
        OutputStream dataOS = null;
        OutputStream idxOS = null;
        OutputStream countOS = null;
        FilterOutputStream idxDOS = null;
        FilterOutputStream countDOS = null;
        try {
            dataFileC = (FileConnection)Connector.open((String)this.dataFilename, (int)3);
            if (!dataFileC.exists()) {
                dataFileC.create();
            }
            dataOS = dataFileC.openOutputStream(0L);
            ByteArrayOutputStream dataBAOS = new ByteArrayOutputStream();
            DataOutputStream dataDOS = new DataOutputStream(dataBAOS);
            idxFileC = (FileConnection)Connector.open((String)this.indexFilename, (int)3);
            if (!idxFileC.exists()) {
                idxFileC.create();
            }
            idxOS = idxFileC.openOutputStream(0L);
            idxDOS = new DataOutputStream(idxOS);
            long off = 0L;
            int size = 0;
            while (en.hasMoreElements()) {
                Object obj = en.nextElement();
                ((DataOutputStream)idxDOS).writeLong(off);
                this.serializer.serializeToDOS(obj, dataDOS);
                dataDOS.flush();
                byte[] bytes = dataBAOS.toByteArray();
                dataBAOS.reset();
                dataOS.write(bytes);
                off += (long)bytes.length;
                ++size;
            }
            dataFileC.truncate(off);
            ((DataOutputStream)idxDOS).writeLong(off);
            idxFileC.truncate((long)((size + 1) * 8));
            countFileC = (FileConnection)Connector.open((String)this.countFilename, (int)3);
            if (!countFileC.exists()) {
                countFileC.create();
            }
            countOS = countFileC.openOutputStream(0L);
            countDOS = new DataOutputStream(countOS);
            ((DataOutputStream)countDOS).writeInt(size);
            ((DataOutputStream)idxDOS).flush();
            ((DataOutputStream)countDOS).flush();
            int n = size;
            return n;
        }
        finally {
            if (dataOS != null) {
                try {
                    dataOS.close();
                }
                catch (Exception x) {}
            }
            if (dataFileC != null) {
                try {
                    dataFileC.close();
                }
                catch (Exception x) {}
            }
            if (idxDOS != null) {
                try {
                    idxDOS.close();
                }
                catch (Exception x) {}
            }
            if (idxOS != null) {
                try {
                    idxOS.close();
                }
                catch (Exception x) {}
            }
            if (idxFileC != null) {
                try {
                    idxFileC.close();
                }
                catch (Exception x) {}
            }
            if (countDOS != null) {
                try {
                    countDOS.close();
                }
                catch (Exception x) {}
            }
            if (countOS != null) {
                try {
                    countOS.close();
                }
                catch (Exception x) {}
            }
            if (countFileC != null) {
                try {
                    countFileC.close();
                }
                catch (Exception x) {}
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean exists() throws IOException {
        FileConnection fileC = null;
        try {
            fileC = (FileConnection)Connector.open((String)this.indexFilename, (int)1);
            if (!fileC.exists()) {
                boolean bl = false;
                return bl;
            }
            fileC.close();
            fileC = (FileConnection)Connector.open((String)this.dataFilename, (int)1);
            if (!fileC.exists()) {
                boolean bl = false;
                return bl;
            }
            fileC.close();
            fileC = (FileConnection)Connector.open((String)this.countFilename, (int)1);
            boolean bl = fileC.exists();
            return bl;
        }
        finally {
            if (fileC != null) {
                fileC.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void delete() throws IOException {
        FileConnection fileC = null;
        try {
            fileC = (FileConnection)Connector.open((String)this.indexFilename, (int)3);
            fileC.delete();
            fileC.close();
            fileC = (FileConnection)Connector.open((String)this.dataFilename, (int)3);
            fileC.delete();
            fileC.close();
            fileC = (FileConnection)Connector.open((String)this.countFilename, (int)3);
            fileC.delete();
        }
        finally {
            if (fileC != null) {
                fileC.close();
            }
        }
    }

    public Object get(int idx, Vector objs) throws IOException {
        this.fetch(idx, 1, objs);
        return objs.elementAt(idx);
    }

    public int fetch(int off, int count, Vector objs) throws IOException {
        return this.fetchSearch(off, count, objs, null);
    }

    public int search(int start, int count, Vector cache, Filter filter) throws IOException {
        return this.fetchSearch(start, count, cache, filter);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int fetchSearch(int off, int count, Vector objs, Filter filter) throws IOException {
        if (filter == null && objs.size() < off + count) {
            objs.setSize(off + count);
        }
        FileConnection idxFileC = null;
        FileConnection dataFileC = null;
        InputStream idxIS = null;
        InputStream dataIS = null;
        FilterInputStream idxDIS = null;
        FilterInputStream dataDIS = null;
        try {
            boolean filesOpened = false;
            long dataOffset = 0L;
            long idxOffset = 0L;
            int found = 0;
            while (found < count) {
                Object obj = null;
                if (objs != null && off < objs.size()) {
                    obj = objs.elementAt(off);
                }
                if (obj != null && obj instanceof WeakReference) {
                    obj = ((WeakReference)obj).get();
                }
                if (obj == null) {
                    long newIdxOffset;
                    if (!filesOpened) {
                        idxFileC = (FileConnection)Connector.open((String)this.indexFilename, (int)1);
                        if (!idxFileC.exists()) {
                            throw new FileNotFoundException(this.indexFilename);
                        }
                        idxIS = idxFileC.openInputStream();
                        idxDIS = new DataInputStream(idxIS);
                        dataFileC = (FileConnection)Connector.open((String)this.dataFilename, (int)1);
                        if (!dataFileC.exists()) {
                            throw new FileNotFoundException(this.dataFilename);
                        }
                        dataIS = dataFileC.openInputStream();
                        dataDIS = new DataInputStream(dataIS);
                        filesOpened = true;
                    }
                    if ((newIdxOffset = (long)(8 * off)) >= idxOffset) {
                        if (newIdxOffset > idxOffset) {
                            long skip = newIdxOffset - idxOffset;
                            idxDIS.skip(skip);
                            idxOffset = newIdxOffset;
                        }
                        long newDataOffset = ((DataInputStream)idxDIS).readLong();
                        idxOffset += 8L;
                        dataDIS.skip(newDataOffset - dataOffset);
                        if (dataDIS.available() == 0) break;
                    }
                    obj = this.serializer.unserializeFromDIS((DataInputStream)dataDIS);
                    dataOffset = ((DataInputStream)idxDIS).readLong();
                    idxOffset += 8L;
                }
                if (filter != null) {
                    if (objs != null) {
                        if (objs.size() < off) {
                            objs.setSize(off);
                        }
                        if (objs.size() == off) {
                            objs.addElement(obj);
                        } else {
                            objs.setElementAt(obj, off);
                        }
                    }
                    if (filter.accept(off, obj)) {
                        ++found;
                    }
                } else {
                    objs.setElementAt(obj, off);
                    ++found;
                }
                ++off;
            }
            int n = found;
            return n;
        }
        finally {
            if (idxDIS != null) {
                try {
                    idxDIS.close();
                }
                catch (Exception x) {}
            }
            if (idxIS != null) {
                try {
                    idxIS.close();
                }
                catch (Exception x) {}
            }
            if (idxFileC != null) {
                try {
                    idxFileC.close();
                }
                catch (Exception x) {}
            }
            if (dataDIS != null) {
                try {
                    dataDIS.close();
                }
                catch (Exception x) {}
            }
            if (dataIS != null) {
                try {
                    dataIS.close();
                }
                catch (Exception x) {}
            }
            if (dataFileC != null) {
                try {
                    dataFileC.close();
                }
                catch (Exception x) {}
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int size() throws IOException {
        FileConnection fileC = null;
        InputStream is = null;
        FilterInputStream dIS = null;
        try {
            fileC = (FileConnection)Connector.open((String)this.countFilename, (int)1);
            if (!fileC.exists()) {
                throw new FileNotFoundException(this.countFilename);
            }
            is = fileC.openInputStream();
            dIS = new DataInputStream(is);
            int n = ((DataInputStream)dIS).readInt();
            return n;
        }
        finally {
            if (dIS != null) {
                try {
                    dIS.close();
                    dIS = null;
                }
                catch (Exception x) {}
            }
            if (is != null) {
                try {
                    is.close();
                    is = null;
                }
                catch (Exception x) {}
            }
            if (fileC != null) {
                try {
                    fileC.close();
                    fileC = null;
                }
                catch (Exception x) {}
            }
        }
    }

    public static interface Filter {
        public boolean accept(int var1, Object var2);
    }
}

