/*
 * Decompiled with CFR 0.152.
 */
package com.whatsapp.api.ui;

import java.util.Vector;
import javax.microedition.lcdui.Font;
import javax.microedition.lcdui.Graphics;

public class TextUtils {
    static final String ELLIPSIS = "...";

    public static Vector simpleWrap(Font f, String s, int width) {
        int i;
        Vector<String> res = new Vector<String>();
        int lastLine = 0;
        int lastSpace = 0;
        int runningWidth = 0;
        int widthSinceSpace = 0;
        for (i = 0; i < s.length(); ++i) {
            char c = s.charAt(i);
            if (c == '\n') {
                res.addElement(s.substring(lastLine, i));
                lastLine = lastSpace = i + 1;
                widthSinceSpace = 0;
                runningWidth = 0;
                continue;
            }
            int curWidth = f.charWidth(c);
            widthSinceSpace += curWidth;
            if (c == ' ') {
                lastSpace = i;
                widthSinceSpace = 0;
            }
            if (runningWidth + curWidth > width) {
                if (lastSpace > lastLine) {
                    res.addElement(s.substring(lastLine, lastSpace));
                    lastLine = lastSpace + 1;
                    runningWidth = widthSinceSpace;
                    continue;
                }
                res.addElement(s.substring(lastLine, i));
                lastLine = lastSpace = i;
                widthSinceSpace = 0;
                runningWidth = 0;
                continue;
            }
            runningWidth += curWidth;
        }
        if (i > lastLine) {
            res.addElement(s.substring(lastLine, i));
        }
        return res;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static void drawStringElided(Graphics g, String text, int x, int y, int width) {
        Font f = g.getFont();
        if (f.stringWidth(text) > width) {
            int snip;
            int ellipsisWidth = f.stringWidth(ELLIPSIS);
            int textWidth = width - ellipsisWidth;
            int origLen = text.length();
            String useStr = null;
            for (snip = 1; snip < origLen && f.stringWidth(useStr = text.substring(0, origLen - snip)) >= textWidth; ++snip) {
            }
            if (useStr == null || snip >= origLen) return;
            g.drawString(useStr + ELLIPSIS, x, y, 20);
            return;
        } else {
            g.drawString(text, x, y, 20);
        }
    }
}

