/*
 * Decompiled with CFR 0.152.
 */
package com.whatsapp.api.ui;

import com.whatsapp.api.ui.TextUtils;
import com.whatsapp.api.ui.UIField;
import com.whatsapp.api.ui.UIManager;
import java.util.Vector;
import javax.microedition.lcdui.Font;
import javax.microedition.lcdui.Graphics;

public class CutoutFlowTextField
extends UIManager {
    private String _textbuf;
    private String _laidOutFirstLine;
    private Vector _laidOutText;
    private Font _font;
    private int _fontHeight;
    private int _cutoutWidth;
    private int _cutoutHeight;
    private int _mode;
    private int _previousWidth = -1;

    public CutoutFlowTextField(String s, Font font, int mode) {
        super(0L);
        this._textbuf = s;
        this._font = font;
        this._fontHeight = this._font.getHeight();
        this._mode = mode;
    }

    public void add(UIField f) {
        if (this.getNumChildren() > 0) {
            throw new IllegalStateException("can only have one child");
        }
        super.add(f);
        this._previousWidth = -1;
    }

    public void paint(Graphics g, int x, int y, int width, int height) {
        g.setColor(0);
        g.setFont(this._font);
        if (this._mode == 40) {
            for (int i = 0; i < this._laidOutText.size(); ++i) {
                String s = (String)this._laidOutText.elementAt(i);
                g.drawString(s, x, y + i * this._fontHeight, 20);
            }
        } else {
            g.drawString(this._laidOutFirstLine, x + this._cutoutWidth, y, 20);
            int boost = Math.max(0, this._cutoutHeight - this._fontHeight);
            for (int i = 0; i < this._laidOutText.size(); ++i) {
                String s = (String)this._laidOutText.elementAt(i);
                g.drawString(s, x, y + boost + (i + 1) * this._fontHeight, 20);
            }
        }
        super.paint(g, x, y, width, height);
    }

    public void sublayout(int width, int height) {
        int usedHeight;
        if (this._previousWidth == width) {
            return;
        }
        UIField cutoutF = this.getChildAt(0);
        cutoutF.layout(width / 2, this._fontHeight);
        this._cutoutHeight = cutoutF.getHeight() + cutoutF.getMarginTop() + cutoutF.getMarginBottom();
        this._cutoutWidth = cutoutF.getWidth() + cutoutF.getMarginLeft() + cutoutF.getMarginRight();
        if (this._mode == 40) {
            this._laidOutText = TextUtils.simpleWrap(this._font, this._textbuf, width);
            String lastLine = (String)this._laidOutText.lastElement();
            int boost = 0;
            if (this._font.stringWidth(lastLine) + this._cutoutWidth < width) {
                cutoutF.setManagerPosition(width - this._cutoutWidth, (this._laidOutText.size() - 1) * this._fontHeight);
                boost = Math.max(0, this._cutoutHeight - this._fontHeight);
            } else {
                cutoutF.setManagerPosition(width - this._cutoutWidth, this._laidOutText.size() * this._fontHeight);
                boost = this._cutoutHeight;
            }
            usedHeight = this._fontHeight * this._laidOutText.size() + boost;
        } else {
            int vdiff = this._fontHeight - cutoutF.getHeight();
            int vadjust = Math.max(vdiff / 2, cutoutF.getMarginTop());
            cutoutF.setManagerPosition(cutoutF.getMarginLeft(), vadjust);
            Vector firstPass = TextUtils.simpleWrap(this._font, this._textbuf, width - this._cutoutWidth);
            if (firstPass.size() > 0) {
                this._laidOutFirstLine = (String)firstPass.elementAt(0);
                if (firstPass.size() > 1) {
                    String remainderStr = this._textbuf.substring(this._laidOutFirstLine.length());
                    char firstChar = remainderStr.charAt(0);
                    if (firstChar == '\n' || firstChar == ' ' || firstChar == '\t') {
                        remainderStr = remainderStr.substring(1);
                    }
                    this._laidOutText = TextUtils.simpleWrap(this._font, remainderStr, width);
                } else {
                    this._laidOutText = new Vector();
                }
            } else {
                this._laidOutFirstLine = "";
                this._laidOutText = new Vector();
            }
            usedHeight = (this._laidOutText.size() + 1) * this._fontHeight;
            if (this._cutoutHeight > this._fontHeight) {
                usedHeight += this._cutoutHeight - this._fontHeight;
            }
        }
        this.setExtent(width, usedHeight);
        this._previousWidth = width;
    }
}

