/*
 * Decompiled with CFR 0.152.
 */
package com.whatsapp.api.ui;

import com.whatsapp.api.ui.UIField;

public class Command {
    private static final int LSK = 0;
    private static final int RSK = 1;
    private static final int MSK = 2;
    private static int curPriority;
    static final Type OPTIONS;
    protected static final Type EDITOR_LSK;
    protected static final Type EDITOR_MSK;
    protected static final Type EDITOR_RSK;
    protected static final Type FIELD_DEFAULT;
    protected static final Type FIELD;
    public static final Type STOP;
    public static final Type OK;
    public static final Type CANCEL;
    public static final Type ITEM;
    public static final Type SCREEN;
    public static final Type HELP;
    public static final Type BACK;
    public static final Type EXIT;
    static final Type EDITOR_OPT;
    public final String label;
    public final String longLabel;
    public final Type commandType;
    public final int priority;
    private boolean enabled = true;

    protected static Type convertCommandType(int commandType) {
        switch (commandType) {
            case 6: {
                return STOP;
            }
            case 4: {
                return OK;
            }
            case 3: {
                return CANCEL;
            }
            case 8: {
                return ITEM;
            }
            case 1: {
                return SCREEN;
            }
            case 5: {
                return HELP;
            }
            case 2: {
                return BACK;
            }
            case 7: {
                return EXIT;
            }
        }
        throw new IllegalArgumentException("ui/command-bar-field/command-type/" + commandType + "/cannot-convert");
    }

    public Command(javax.microedition.lcdui.Command cmd) {
        this(cmd.getLabel(), cmd.getLongLabel(), Command.convertCommandType(cmd.getCommandType()), cmd.getPriority());
    }

    public Command(String label, Type commandType, int priority) {
        this(label, null, commandType, priority, true);
    }

    public Command(String label, Type commandType, int priority, boolean enabled) {
        this(label, null, commandType, priority, enabled);
    }

    public Command(String shortLabel, String longLabel, Type commandType, int priority) {
        this(shortLabel, longLabel, commandType, priority, true);
    }

    public Command(String shortLabel, String longLabel, Type commandType, int priority, boolean enabled) {
        this.label = shortLabel;
        this.longLabel = longLabel;
        this.commandType = commandType;
        this.priority = priority;
        this.enabled = enabled;
    }

    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    int compareTo(Command otherCmd) {
        int typePriority = this.commandType.priority;
        int otherTypePriority = otherCmd.commandType.priority;
        if (typePriority != otherTypePriority) {
            return otherTypePriority - typePriority;
        }
        return this.priority - otherCmd.priority;
    }

    Command getBaseCommand() {
        return this;
    }

    static {
        OPTIONS = new Type(curPriority++, 0);
        EDITOR_LSK = new Type(curPriority, 0);
        EDITOR_MSK = new Type(curPriority, 2);
        EDITOR_RSK = new Type(curPriority++, 1);
        FIELD_DEFAULT = new Type(curPriority++);
        FIELD = new Type(curPriority++);
        STOP = new Type(curPriority++, 1);
        OK = new Type(curPriority++, 2);
        CANCEL = new Type(curPriority++, 1);
        ITEM = new Type(curPriority++, 2);
        SCREEN = new Type(curPriority++, 2);
        HELP = new Type(curPriority++, 2);
        BACK = new Type(curPriority++, 1);
        EXIT = new Type(curPriority++, 1);
        EDITOR_OPT = new Type(curPriority++, 0);
    }

    static class FieldType
    extends Type {
        final Type baseType;

        private FieldType(Type baseType, Type type) {
            super(baseType.priority, type.softKey);
            this.baseType = baseType;
        }
    }

    public static class Type {
        final int priority;
        final int softKey;

        private Type(int priority, int softKey) {
            this.priority = priority;
            this.softKey = softKey;
        }

        private Type(int priority) {
            this(priority, -1);
        }

        Type create(Type type) {
            return new FieldType(this, type);
        }
    }

    public static interface Listener {
        public boolean commandAction(Command var1, UIField var2);
    }
}

