/*
 * Decompiled with CFR 0.152.
 */
package com.whatsapp.api.sapi;

import com.nokia.mid.s40.codec.DataDecoder;
import com.nokia.mid.s40.codec.DataEncoder;
import com.nokia.mid.s40.io.LocalMessageProtocolConnection;
import com.whatsapp.api.sapi.LocalSAPIMessageListener;
import com.whatsapp.api.sapi.SAPIClient;
import com.whatsapp.api.sapi.SMSListener;
import java.io.IOException;
import javax.microedition.io.Connector;

public class SMS
implements LocalSAPIMessageListener {
    private LocalMessageProtocolConnection nmsConnection;
    private String VERSION = "2.[0-10]";
    private String serverURL = "localmsg://nokia.messaging";
    private int byteSize = 500;
    private SAPIClient client;
    SMSListener listener;

    public SMS(SMSListener listr) {
        this.listener = listr;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void connect() throws IOException {
        LocalMessageProtocolConnection nmsConnection;
        this.nmsConnection = nmsConnection = (LocalMessageProtocolConnection)Connector.open((String)this.serverURL);
        LocalMessageProtocolConnection localMessageProtocolConnection = nmsConnection;
        synchronized (localMessageProtocolConnection) {
            if (nmsConnection != null) {
                this.client = new SAPIClient(nmsConnection, this, this.VERSION, this.byteSize);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean closeConnection() throws IOException {
        LocalMessageProtocolConnection nmsConnection = this.nmsConnection;
        if (nmsConnection != null) {
            LocalMessageProtocolConnection localMessageProtocolConnection = nmsConnection;
            synchronized (localMessageProtocolConnection) {
                if (this.client != null) {
                    this.client.close();
                } else {
                    nmsConnection.close();
                    nmsConnection = null;
                }
            }
            return true;
        }
        return false;
    }

    public void localSAPIMessageReceived(String method, DataDecoder decoder) {
        if ((method = method.toLowerCase()).equals("subscribemessages")) {
            try {
                this.decodeSubscribeMesagesMethod(decoder);
            }
            catch (IOException ex) {
                ex.printStackTrace();
            }
        } else if (method.equals("messagenotify")) {
            try {
                this.decodeMessageNotifyMethod(decoder);
            }
            catch (IOException ex) {
                ex.printStackTrace();
            }
        } else if (!method.equals("deletemessages") && method.equals("getmessageentity")) {
            try {
                this.decodeGetMessageEntityMethod(decoder);
            }
            catch (IOException ex) {
                ex.printStackTrace();
            }
        }
    }

    public void SAPIconnectionClosed(int reason) {
        this.listener.SMSServerClosed(reason);
    }

    public void commonSAPIMessageReceived(String msg) {
        this.listener.SMSsystemMessageReceived(msg);
    }

    public void SAPIready() {
        this.listenIncomingSMS();
    }

    private void decodeSubscribeMesagesMethod(DataDecoder decoder) throws IOException {
        short transid = (short)decoder.getInteger(5);
        String status = decoder.getString(10);
        if ((status = status.toLowerCase()).equals("ok")) {
            this.listener.SMSServerReady();
        } else {
            this.listener.SMSNotificationServiceError(transid);
        }
    }

    private void decodeDeleteMesagesMethod(DataDecoder decoder) throws IOException {
    }

    private void decodeMessageNotifyMethod(DataDecoder decoder) throws IOException {
        short subscriptionId = (short)decoder.getInteger(5);
        String type = decoder.getString(10);
        long messageId = decoder.getInteger(7);
        if (type.equals("SMS")) {
            this.getMessageEntity(messageId);
        }
    }

    private void decodeGetMessageEntityMethod(DataDecoder decoder) throws IOException {
        short transid = (short)decoder.getInteger(5);
        String status = decoder.getString(10);
        long messageId = decoder.getInteger(7);
        if ((status = status.toLowerCase()).equals("ok")) {
            System.out.println("Received Message=" + messageId);
            decoder.getStart(15);
            String body = decoder.getString(11);
            String address = decoder.getString(10);
            this.listener.SMSReceived(address, body, messageId);
        }
    }

    private short listenIncomingSMS() {
        short transid = (short)(System.currentTimeMillis() % 255L);
        if (this.client != null) {
            try {
                byte[] data_out = null;
                DataEncoder encoder = new DataEncoder("Conv-BEB");
                encoder.putStart(14, "event");
                encoder.put(13, "name", "SubscribeMessages");
                encoder.put(5, "trans_id", (long)transid);
                encoder.putEnd(14, "event");
                data_out = encoder.getData();
                if (data_out != null) {
                    this.client.sendData(data_out);
                }
                data_out = null;
                encoder = null;
            }
            catch (IOException ex) {
                ex.printStackTrace();
            }
        }
        return transid;
    }

    public short deleteMessage(long messageId) {
        short transid = (short)(System.currentTimeMillis() % 255L);
        if (this.client != null) {
            try {
                byte[] data_out = null;
                DataEncoder encoder = new DataEncoder("Conv-BEB");
                encoder.putStart(14, "event");
                encoder.put(13, "name", "DeleteMessages");
                encoder.put(5, "trans_id", (long)transid);
                encoder.putStart(16, "entries");
                encoder.put(7, "message_id", messageId);
                encoder.putEnd(16, "entries");
                encoder.putEnd(14, "event");
                data_out = encoder.getData();
                if (data_out != null) {
                    this.client.sendData(data_out);
                }
                data_out = null;
                encoder = null;
            }
            catch (IOException ex) {
                ex.printStackTrace();
            }
        }
        return transid;
    }

    private short getMessageEntity(long messageId) {
        short transid = (short)(System.currentTimeMillis() % 255L);
        if (this.client != null) {
            try {
                byte[] data_out = null;
                DataEncoder encoder = new DataEncoder("Conv-BEB");
                encoder.putStart(14, "event");
                encoder.put(13, "name", "GetMessageEntity");
                encoder.put(5, "trans_id", (long)transid);
                encoder.put(7, "message_id", messageId);
                encoder.putStart(16, "entries");
                encoder.put(10, "entity_element", "body_text");
                encoder.put(10, "entity_element", "address");
                encoder.putEnd(16, "entries");
                encoder.putEnd(14, "event");
                data_out = encoder.getData();
                if (data_out != null) {
                    this.client.sendData(data_out);
                }
                data_out = null;
                encoder = null;
            }
            catch (IOException ex) {
                ex.printStackTrace();
            }
        }
        return transid;
    }
}

