/*
 * Decompiled with CFR 0.152.
 */
package com.whatsapp.api.sapi;

import com.nokia.mid.s40.codec.DataDecoder;
import com.nokia.mid.s40.codec.DataEncoder;
import com.nokia.mid.s40.io.LocalMessageProtocolConnection;
import com.whatsapp.api.sapi.LocalSAPIMessageListener;
import com.whatsapp.api.sapi.SAPIClient;
import com.whatsapp.api.sapi.SAPIContactListener;
import com.whatsapp.api.util.Utilities;
import java.io.IOException;
import java.util.Calendar;
import java.util.Enumeration;
import java.util.Hashtable;
import javax.microedition.io.Connector;

public class SAPIContacts
implements LocalSAPIMessageListener {
    private LocalMessageProtocolConnection phoneStatusConnection;
    private String VERSION = "2.[0-10]";
    private String serverURL = "localmsg://nokia.contacts";
    private int byteSize = 2000;
    private SAPIClient client;
    SAPIContactListener listener;

    public SAPIContacts(SAPIContactListener listr) {
        this.listener = listr;
    }

    public void connect() throws IOException {
        this.phoneStatusConnection = (LocalMessageProtocolConnection)Connector.open((String)this.serverURL);
        this.client = new SAPIClient(this.phoneStatusConnection, this, this.VERSION, this.byteSize);
    }

    public void closeConnection() {
        if (this.client != null) {
            this.client.close();
        }
    }

    public void localSAPIMessageReceived(String method, DataDecoder decoder) {
        if (method.equals("Notify")) {
            try {
                long transId = decoder.getInteger(7);
                byte change = (byte)decoder.getInteger(2);
                if (decoder.getName().equals("Contact")) {
                    Hashtable contact = this.decodeContac(decoder);
                    switch (change) {
                        case 1: {
                            this.listener.contactAdded(contact);
                            break;
                        }
                        case 2: {
                            this.listener.contactDeleted(contact);
                            break;
                        }
                        case 3: {
                            this.listener.contactUpdated(contact);
                        }
                    }
                }
            }
            catch (IOException ex) {
                Utilities.logData("!!!IOEX:" + ex.getMessage());
                ex.printStackTrace();
            }
        }
    }

    public void SAPIconnectionClosed(int reason) {
        this.client = null;
        this.listener.contactsConnectionClosed("ConnectionClosed:" + reason);
    }

    public void commonSAPIMessageReceived(String msg) {
        this.listener.contactsSystemMessageReceived(msg);
    }

    public void SAPIready() {
    }

    public long enableDisableNotifications(boolean enable) {
        if (this.client == null) {
            return -1L;
        }
        long timestamp = System.currentTimeMillis();
        try {
            byte[] data_out = null;
            DataEncoder encoder = new DataEncoder("Conv-BEB");
            encoder.putStart(14, "event");
            String notify = enable ? "NotifySubscribe" : "NotifyUnsubscribe";
            encoder.put(13, "name", notify);
            encoder.put(7, "trans_id", timestamp);
            encoder.putEnd(14, "event");
            data_out = encoder.getData();
            if (data_out != null) {
                this.client.sendData(data_out);
                Utilities.logData("Contact Notifications:" + enable);
            }
            data_out = null;
            encoder = null;
        }
        catch (IOException ex) {
            Utilities.logData("IOE:" + ex.getMessage());
            this.listener.contactsSystemMessageReceived(ex.getMessage());
            timestamp = -1L;
        }
        return timestamp;
    }

    private Hashtable decodeContac(DataDecoder decoder) throws IOException {
        Utilities.logData("-Decoding Contact");
        decoder.getStart(15);
        Hashtable<String, String> contact = new Hashtable<String, String>();
        String temp = null;
        while (decoder.listHasMoreItems()) {
            temp = decoder.getName();
            temp = temp.toLowerCase();
            Utilities.logData("name:" + temp);
            if (temp.equals("contactid")) {
                contact.put(temp, decoder.getString(11));
                continue;
            }
            if (temp.equals("firstname")) {
                contact.put(temp, decoder.getString(11));
                continue;
            }
            if (temp.equals("lastname")) {
                contact.put(temp, decoder.getString(11));
                continue;
            }
            if (temp.equals("nickname")) {
                contact.put(temp, decoder.getString(11));
                continue;
            }
            if (temp.equals("displayname")) {
                contact.put(temp, decoder.getString(11));
                continue;
            }
            if (temp.equals("title")) {
                contact.put(temp, decoder.getString(11));
                continue;
            }
            if (temp.equals("company")) {
                contact.put(temp, decoder.getString(11));
                continue;
            }
            if (temp.equals("notes")) {
                contact.put(temp, decoder.getString(11));
                continue;
            }
            if (temp.equals("groupnames")) {
                this.decodeGroupNames(decoder, contact);
                continue;
            }
            if (temp.equals("numbers")) {
                this.decodeNumbers(decoder, contact);
                continue;
            }
            if (temp.equals("defaultnumber")) {
                this.decodeDefaultNumbers(decoder, contact);
                continue;
            }
            if (temp.equals("defaultemail")) {
                contact.put(temp, decoder.getString(11));
                continue;
            }
            if (temp.equals("emails")) {
                this.decodeMailAddresses(temp, decoder, contact);
                continue;
            }
            if (temp.equals("source")) {
                contact.put(temp, "" + decoder.getInteger(7));
                continue;
            }
            if (temp.equals("pictureurl")) {
                contact.put(temp, decoder.getString(11));
                continue;
            }
            if (temp.equals("weburl")) {
                contact.put(temp, decoder.getString(11));
                continue;
            }
            if (temp.equals("ringtoneurl")) {
                contact.put(temp, decoder.getString(11));
                continue;
            }
            if (temp.equals("animatedtoneurl")) {
                contact.put(temp, decoder.getString(11));
                continue;
            }
            if (temp.equals("postaladdresses")) {
                this.decodePostalAddress(decoder, contact);
                continue;
            }
            if (temp.equals("otheraddresses")) {
                this.decodeOtherAddress(decoder, contact);
                continue;
            }
            if (temp.equals("birthday")) {
                this.decodeDateElement(temp, decoder, contact);
                continue;
            }
            if (temp.equals("anniversary")) {
                this.decodeDateElement(temp, decoder, contact);
                continue;
            }
            if (!temp.equals("imaddresses")) continue;
            this.decodeMailAddresses(temp, decoder, contact);
        }
        Utilities.logData("-Contac Complete \n\n\n");
        Enumeration keys = contact.keys();
        while (keys.hasMoreElements()) {
            String key = (String)keys.nextElement();
            Utilities.logData("\n" + key + "=" + contact.get(key));
        }
        Utilities.logData("\n\n\n");
        return contact;
    }

    private void decodeDefaultNumbers(DataDecoder decoder, Hashtable contact) throws IOException {
        decoder.getStart(15);
        while (decoder.listHasMoreItems()) {
            int type = (int)decoder.getInteger(7);
            String number = decoder.getString(11);
            contact.put("defaultnumber_" + this.getDataType(type), number);
        }
        decoder.getEnd(15);
    }

    private void decodeMailAddresses(String type, DataDecoder decoder, Hashtable contact) throws IOException {
        decoder.getStart(16);
        int mailNumber = 1;
        boolean array_end = false;
        while (!array_end) {
            try {
                String mail = decoder.getString(11);
                contact.put(type + "_" + mailNumber, mail);
            }
            catch (IOException e) {
                array_end = true;
                decoder.getEnd(16);
            }
            if (array_end) continue;
            ++mailNumber;
        }
    }

    private void decodeDateElement(String element, DataDecoder decoder, Hashtable contact) throws IOException {
        decoder.getStart(15);
        Calendar cal = Calendar.getInstance();
        while (decoder.listHasMoreItems()) {
            String nextElementName = decoder.getName().toLowerCase();
            if (nextElementName.equals("year")) {
                cal.set(1, (int)decoder.getInteger(7));
                continue;
            }
            if (nextElementName.equals("month")) {
                cal.set(2, (byte)decoder.getInteger(2));
                continue;
            }
            if (nextElementName.equals("day")) {
                cal.set(5, (byte)decoder.getInteger(2));
                continue;
            }
            if (nextElementName.equals("hour")) {
                cal.set(11, (byte)decoder.getInteger(2));
                continue;
            }
            if (nextElementName.equals("minute")) {
                cal.set(12, (byte)decoder.getInteger(2));
                continue;
            }
            if (!nextElementName.equals("second")) continue;
            cal.set(13, (byte)decoder.getInteger(2));
        }
        contact.put(element, cal.getTime());
        decoder.getEnd(15);
    }

    private void decodeOtherAddress(DataDecoder decoder, Hashtable contact) throws IOException {
        decoder.getStart(16);
        int elementNumber = 1;
        boolean array_end = false;
        while (!array_end) {
            try {
                decoder.getStart(15);
                String kind = "";
                String address = "";
                while (decoder.listHasMoreItems()) {
                    String nextElementName = decoder.getName().toLowerCase();
                    if (nextElementName.equals("kind")) {
                        int type = (int)decoder.getInteger(7);
                        kind = this.getDataType(type);
                        continue;
                    }
                    if (!nextElementName.equals("address")) continue;
                    address = decoder.getString(11);
                }
                decoder.getEnd(15);
                contact.put("otherAddress_" + kind + "_" + elementNumber, address);
            }
            catch (IOException e) {
                array_end = true;
            }
            if (array_end) continue;
            ++elementNumber;
        }
        decoder.getEnd(16);
    }

    private void decodePostalAddress(DataDecoder decoder, Hashtable contact) throws IOException {
        decoder.getStart(16);
        boolean array_end = false;
        while (!array_end) {
            try {
                decoder.getStart(15);
                String kind = "";
                String street = "";
                String extendedAddress = "";
                String city = "";
                String state = "";
                String postalCode = "";
                String country = "";
                while (decoder.listHasMoreItems()) {
                    String nextElementName = decoder.getName().toLowerCase();
                    if (nextElementName.equals("kind")) {
                        int type = (int)decoder.getInteger(7);
                        kind = this.getDataType(type);
                        continue;
                    }
                    if (nextElementName.equals("street")) {
                        street = decoder.getString(11);
                        continue;
                    }
                    if (nextElementName.equals("extendedaddress")) {
                        extendedAddress = decoder.getString(11);
                        continue;
                    }
                    if (nextElementName.equals("city")) {
                        city = decoder.getString(11);
                        continue;
                    }
                    if (nextElementName.equals("state")) {
                        state = decoder.getString(11);
                        continue;
                    }
                    if (nextElementName.equals("postalcode")) {
                        postalCode = decoder.getString(11);
                        continue;
                    }
                    if (!nextElementName.equals("country")) continue;
                    country = decoder.getString(11);
                }
                decoder.getEnd(15);
                contact.put("postaladdress_" + kind, street + " " + extendedAddress + ", " + city + " " + state + ", " + postalCode + ", " + country);
            }
            catch (IOException e) {
                array_end = true;
            }
        }
        decoder.getEnd(16);
    }

    private void decodeGroupNames(DataDecoder decoder, Hashtable contact) throws IOException {
        decoder.getStart(16);
        int groupNumber = 1;
        boolean array_end = false;
        while (!array_end) {
            try {
                String group = decoder.getString(11);
                contact.put("groupnames_" + groupNumber, group);
            }
            catch (IOException e) {
                array_end = true;
                decoder.getEnd(16);
            }
            if (array_end) continue;
            ++groupNumber;
        }
    }

    private void decodeNumbers(DataDecoder decoder, Hashtable contact) throws IOException {
        decoder.getStart(16);
        boolean array_end = false;
        while (!array_end) {
            try {
                decoder.getStart(15);
                String kind = "";
                String number = "";
                while (decoder.listHasMoreItems()) {
                    String nextElementName = decoder.getName().toLowerCase();
                    if (nextElementName.equals("kind")) {
                        int type = (int)decoder.getInteger(7);
                        kind = this.getDataType(type);
                        continue;
                    }
                    if (!nextElementName.equals("number")) continue;
                    number = decoder.getString(11);
                }
                decoder.getEnd(15);
                int index = 0;
                String key = "";
                while (contact.containsKey(key = "number_" + kind + "_" + ++index)) {
                }
                contact.put(key, number);
            }
            catch (IOException e) {
                array_end = true;
            }
        }
        decoder.getEnd(16);
    }

    private String getDataType(int type) {
        switch (type) {
            case 0: {
                return "Unspecified";
            }
            case 1: {
                return "Home";
            }
            case 2: {
                return "Office";
            }
            case 3: {
                return "Other";
            }
            case 4: {
                return "Mobile";
            }
            case 5: {
                return "Fax";
            }
            case 6: {
                return "Video";
            }
            case 7: {
                return "Assistant";
            }
        }
        return "UnknownType";
    }
}

