/*
 * Decompiled with CFR 0.152.
 */
package com.whatsapp.api.sapi;

import com.nokia.mid.s40.codec.DataDecoder;
import com.nokia.mid.s40.codec.DataEncoder;
import com.nokia.mid.s40.io.LocalMessageProtocolConnection;
import com.whatsapp.api.sapi.LocalSAPIMessageListener;
import com.whatsapp.api.sapi.ProfilesListener;
import com.whatsapp.api.sapi.SAPIClient;
import com.whatsapp.api.util.Utilities;
import java.io.IOException;
import javax.microedition.io.Connector;

public class Profiles
implements LocalSAPIMessageListener {
    private LocalMessageProtocolConnection profilesConnection;
    private String VERSION = "1.[0-10]";
    private String serverURL = "localmsg://nokia.profile";
    private int byteSize = 1000;
    private SAPIClient client;
    private ProfilesListener listener;
    private boolean profileInfoRequested = false;

    public Profiles(ProfilesListener listr) {
        this.listener = listr;
    }

    public void connect() throws IOException {
        this.profilesConnection = (LocalMessageProtocolConnection)Connector.open((String)this.serverURL);
        this.client = new SAPIClient(this.profilesConnection, this, this.VERSION, this.byteSize);
    }

    public void closeConnection() {
        if (this.client != null) {
            this.client.close();
        }
    }

    public short requestCurrentProfileInfo() {
        short transid = -1;
        if (this.client != null) {
            try {
                byte[] data_out = null;
                DataEncoder encoder = new DataEncoder("Conv-BEB");
                encoder.putStart(14, "Event");
                encoder.put(13, "name", "GetProfiles");
                transid = (short)Math.abs((short)System.currentTimeMillis());
                encoder.put(5, "trans_id", (long)transid);
                encoder.putEnd(14, "Event");
                data_out = encoder.getData();
                if (data_out != null) {
                    this.client.sendData(data_out);
                    Utilities.logData("Profiles Info Requested");
                }
                data_out = null;
                encoder = null;
            }
            catch (IOException ex) {
                Utilities.logData("Profiles:  Error sending Profiles Info Message");
            }
        }
        return transid;
    }

    private short readProfile(int profileIndex) {
        short transid = -1;
        if (this.client != null) {
            try {
                byte[] data_out = null;
                DataEncoder encoder = new DataEncoder("Conv-BEB");
                encoder.putStart(14, "Event");
                encoder.put(13, "name", "ReadProfile");
                transid = (short)Math.abs((short)System.currentTimeMillis());
                encoder.put(5, "trans_id", (long)transid);
                encoder.put(2, "profile_index", (long)profileIndex);
                encoder.putEnd(14, "Event");
                data_out = encoder.getData();
                if (data_out != null) {
                    this.client.sendData(data_out);
                    Utilities.logData("Profile requested:" + profileIndex);
                }
                data_out = null;
                encoder = null;
            }
            catch (IOException ex) {
                Utilities.logData("Profiles:  Error sending ReadProfile Message");
            }
        }
        return transid;
    }

    public short receiveProfileNotifications(boolean activate) {
        short transid = -1;
        if (this.client != null) {
            try {
                byte[] data_out = null;
                DataEncoder encoder = new DataEncoder("Conv-BEB");
                encoder.putStart(14, "Event");
                encoder.put(13, "name", "SubscribeForProfileChange");
                transid = (short)Math.abs((short)System.currentTimeMillis());
                encoder.put(5, "trans_id", (long)transid);
                encoder.put(0, "subscribe", activate);
                encoder.putEnd(14, "Event");
                data_out = encoder.getData();
                if (data_out != null) {
                    this.client.sendData(data_out);
                    Utilities.logData("Profile notifications Requested:" + activate);
                }
                data_out = null;
                encoder = null;
            }
            catch (IOException ex) {
                Utilities.logData("Profiles:  Error sending SubscribeForProfileChange Message");
            }
        }
        return transid;
    }

    public void localSAPIMessageReceived(String method, DataDecoder decoder) {
        if (method.equals("GetProfiles")) {
            try {
                this.decodeGetProfilesMessage(decoder);
            }
            catch (IOException ex) {
                Utilities.logData("Profiles:  error decoding GetProfiles");
            }
        } else if (method.equals("ReadProfile")) {
            this.profileInfoRequested = false;
            try {
                this.decodeReadProfileMessage(decoder);
            }
            catch (IOException ex) {
                Utilities.logData("Profiles:  error decoding ReadProfile");
            }
        } else if (method.equals("ModifyProfile")) {
            try {
                short transid = (short)decoder.getInteger(5);
                String status = decoder.getString(10);
                this.listener.profilesSystemMessageReceived("ModifY:" + status);
            }
            catch (IOException ex) {
                Utilities.logData("Profiles:  error decoding ModifyProfile");
            }
        } else if (method.equals("ProfChangedNotification") && !this.profileInfoRequested) {
            this.profileInfoRequested = true;
            this.requestCurrentProfileInfo();
        }
    }

    public void SAPIconnectionClosed(int reason) {
        this.listener.profilesServerClosed(reason);
    }

    public void commonSAPIMessageReceived(String msg) {
        this.listener.profilesSystemMessageReceived(msg);
    }

    public void SAPIready() {
        this.listener.profilesServerReady();
    }

    private synchronized void decodeGetProfilesMessage(DataDecoder decoder) throws IOException {
        short transid = (short)decoder.getInteger(5);
        String status = decoder.getString(10);
        if ((status = status.toLowerCase()).equals("ok")) {
            decoder.getStart(15);
            int activeProfileIndex = -1;
            while (decoder.listHasMoreItems()) {
                int index = -1;
                boolean active = false;
                String name = null;
                decoder.getStart(15);
                while (decoder.listHasMoreItems()) {
                    String temp = decoder.getName();
                    if ((temp = temp.toLowerCase()).equals("profile_index")) {
                        index = (byte)decoder.getInteger(2);
                        continue;
                    }
                    if (temp.equals("profile_name")) {
                        name = decoder.getString(11);
                        continue;
                    }
                    if (!temp.equals("active")) continue;
                    active = decoder.getBoolean();
                }
                decoder.getEnd(15);
                if (!active || index == -1) continue;
                activeProfileIndex = index;
                break;
            }
            if (activeProfileIndex != -1) {
                this.readProfile(activeProfileIndex);
            }
        } else {
            this.listener.profilesSystemMessageReceived(status);
        }
    }

    private synchronized void decodeReadProfileMessage(DataDecoder decoder) throws IOException {
        short transid = (short)decoder.getInteger(5);
        String status = decoder.getString(10);
        if ((status = status.toLowerCase()).equals("ok")) {
            decoder.getStart(15);
            String ringingTone = null;
            byte ringintToneVolume = -1;
            String messageAlertType = null;
            String messageAlertTone = null;
            boolean vibrationEnabled = false;
            boolean applicationToneEnabled = false;
            while (decoder.listHasMoreItems()) {
                String temp = decoder.getName();
                if ((temp = temp.toLowerCase()).equals("ringing_tone")) {
                    ringingTone = decoder.getString(11);
                    continue;
                }
                if (temp.equals("ringing_tone_volume")) {
                    ringintToneVolume = (byte)decoder.getInteger(2);
                    continue;
                }
                if (temp.equals("message_alert_type")) {
                    messageAlertType = decoder.getString(10);
                    continue;
                }
                if (temp.equals("message_alert_tone")) {
                    messageAlertTone = decoder.getString(11);
                    continue;
                }
                if (temp.equals("vibration_enabled")) {
                    vibrationEnabled = decoder.getBoolean();
                    continue;
                }
                if (temp.equals("application_tone_enabled")) {
                    applicationToneEnabled = decoder.getBoolean();
                    continue;
                }
                int type = decoder.getType();
                switch (type) {
                    case 10: 
                    case 11: {
                        decoder.getString(type);
                        break;
                    }
                    case 2: 
                    case 5: {
                        decoder.getInteger(type);
                        break;
                    }
                    case 0: {
                        decoder.getBoolean();
                        break;
                    }
                    case 16: {
                        decoder.getStart(type);
                        decoder.getEnd(type);
                    }
                }
            }
            this.listener.profilesInfoReceived(ringingTone, ringintToneVolume, messageAlertType, messageAlertTone, vibrationEnabled, applicationToneEnabled);
        } else {
            this.listener.profilesSystemMessageReceived(status);
        }
    }

    private void modifyProfile(int profileIndex) {
        int transid = -1;
        if (this.client != null) {
            try {
                byte[] data_out = null;
                DataEncoder encoder = new DataEncoder("Conv-BEB");
                encoder.putStart(14, "Event");
                encoder.put(13, "name", "ModifyProfile");
                transid = (short)Math.abs((short)System.currentTimeMillis());
                encoder.put(5, "trans_id", (long)transid);
                encoder.put(2, "profile_index", (long)profileIndex);
                encoder.putStart(15, "modifications");
                encoder.put(11, "message_alert_tone", "");
                encoder.putEnd(15, "modifications");
                encoder.putEnd(14, "Event");
                data_out = encoder.getData();
                if (data_out != null) {
                    this.client.sendData(data_out);
                    Utilities.logData("Modify Profile requested:" + profileIndex);
                }
                data_out = null;
                encoder = null;
            }
            catch (IOException ex) {
                ex.printStackTrace();
            }
        }
    }
}

