/*
 * Decompiled with CFR 0.152.
 */
package com.whatsapp.api.sapi;

import com.nokia.mid.s40.codec.DataDecoder;
import com.nokia.mid.s40.codec.DataEncoder;
import com.nokia.mid.s40.io.LocalMessageProtocolConnection;
import com.whatsapp.api.sapi.LocalSAPIMessageListener;
import com.whatsapp.api.sapi.PhoneStatusListener;
import com.whatsapp.api.sapi.SAPIClient;
import com.whatsapp.api.util.Utilities;
import java.io.IOException;
import javax.microedition.io.Connector;

public class PhoneStatus
implements LocalSAPIMessageListener {
    private LocalMessageProtocolConnection phoneStatusConnection;
    private String VERSION = "1.[0-10]";
    private String serverURL = "localmsg://nokia.phone-status";
    private int byteSize = 500;
    private SAPIClient client;
    PhoneStatusListener listener;

    public PhoneStatus(PhoneStatusListener listr) {
        this.listener = listr;
    }

    public void connect() throws IOException {
        this.phoneStatusConnection = (LocalMessageProtocolConnection)Connector.open((String)this.serverURL);
        this.client = new SAPIClient(this.phoneStatusConnection, this, this.VERSION, this.byteSize);
    }

    public void closeConnection() {
        if (this.client != null) {
            this.client.close();
        }
    }

    public synchronized void getPhoneStatus() {
        if (this.client != null) {
            try {
                byte[] data_out = null;
                DataEncoder encoder = new DataEncoder("Conv-BEB");
                encoder.putStart(14, "event");
                encoder.put(13, "name", "Query");
                encoder.putStart(15, "subscriptions");
                encoder.put(10, "battery", "CurrentStateOnly");
                encoder.put(10, "network_status", "CurrentStateOnly");
                encoder.put(10, "wifi_status", "CurrentStateOnly");
                encoder.putEnd(15, "subscriptions");
                encoder.putEnd(14, "event");
                data_out = encoder.getData();
                if (data_out != null) {
                    this.client.sendData(data_out);
                    Utilities.logData("PhoneStatus Requested");
                }
                data_out = null;
                encoder = null;
            }
            catch (IOException ex) {
                ex.printStackTrace();
            }
        }
    }

    public synchronized void enableOrDisableNotifications(boolean battery, boolean network, boolean wifi) {
        if (this.client != null) {
            try {
                byte[] data_out = null;
                DataEncoder encoder = new DataEncoder("Conv-BEB");
                encoder.putStart(14, "event");
                encoder.put(13, "name", "Query");
                encoder.putStart(15, "subscriptions");
                encoder.put(10, "battery", battery ? "Enable" : "Disable");
                encoder.put(10, "network_status", network ? "Enable" : "Disable");
                encoder.put(10, "wifi_status", wifi ? "Enable" : "Disable");
                encoder.putEnd(15, "subscriptions");
                encoder.putEnd(14, "event");
                data_out = encoder.getData();
                if (data_out != null) {
                    this.client.sendData(data_out);
                    Utilities.logData("PhoneNotifications:" + battery + " " + network + " " + wifi);
                }
            }
            catch (IOException ex) {
                ex.printStackTrace();
            }
        }
    }

    public void localSAPIMessageReceived(String method, DataDecoder decoder) {
        if (method.equals("ChangeNotify")) {
            try {
                this.decodeChangeNotifyPhoneStatusMessages(decoder);
            }
            catch (IOException ex) {
                ex.printStackTrace();
            }
        } else if (method.equals("Query")) {
            try {
                this.decodePhoneStatusQueryMessage(decoder);
            }
            catch (IOException ex) {
                ex.printStackTrace();
            }
        }
    }

    public void SAPIconnectionClosed(int reason) {
        this.client = null;
        this.listener.phoneConnectionClosed("ConnectionClosed:" + reason);
    }

    public void commonSAPIMessageReceived(String msg) {
        this.listener.systemMessageReceived(msg);
    }

    public void SAPIready() {
    }

    private void decodeChangeNotifyPhoneStatusMessages(DataDecoder decoder) throws IOException {
        decoder.getString(10);
        decoder.getStart(15);
        String name = decoder.getName();
        decoder.getStart(14);
        if (name.equals("battery")) {
            this.listener.batteryChanged((byte)decoder.getInteger(2), decoder.getBoolean());
        } else if (name.equals("network_status")) {
            this.listener.networkChanged(decoder.getString(10));
        } else if (name.equals("wifi_status")) {
            this.listener.wifiChanged(decoder.getBoolean());
        } else {
            Utilities.logData("unknown name in PhoneStatus SAPI listener " + name);
        }
        decoder.getEnd(14);
        decoder.getEnd(15);
    }

    private void decodePhoneStatusQueryMessage(DataDecoder decoder) throws IOException {
        byte batteryStatus = -1;
        boolean isCharging = false;
        String networkStatus = null;
        boolean isWifiConnected = false;
        String temp = null;
        temp = decoder.getString(10);
        if (temp.equals("OK")) {
            decoder.getStart(15);
            while (decoder.listHasMoreItems()) {
                temp = decoder.getName();
                if (temp.equals("battery")) {
                    decoder.getStart(14);
                    batteryStatus = (byte)decoder.getInteger(2);
                    isCharging = decoder.getBoolean();
                    decoder.getEnd(14);
                    continue;
                }
                if (temp.equals("network_status")) {
                    decoder.getStart(14);
                    networkStatus = decoder.getString(10);
                    decoder.getEnd(14);
                    continue;
                }
                if (!temp.equals("wifi_status")) continue;
                decoder.getStart(14);
                isWifiConnected = decoder.getBoolean();
                decoder.getEnd(14);
            }
            decoder.getEnd(15);
            if (batteryStatus != -1) {
                this.listener.phoneStatusReceived(batteryStatus, isCharging, networkStatus, isWifiConnected);
            }
        } else {
            this.listener.systemMessageReceived("ErrorDecoding");
        }
    }
}

