/*
 * Decompiled with CFR 0.152.
 */
package com.whatsapp.api.sapi;

import com.nokia.mid.s40.codec.DataDecoder;
import com.nokia.mid.s40.codec.DataEncoder;
import com.nokia.mid.s40.io.LocalMessageProtocolConnection;
import com.whatsapp.api.sapi.ImageProcessingListener;
import com.whatsapp.api.sapi.LocalSAPIMessageListener;
import com.whatsapp.api.sapi.SAPIClient;
import com.whatsapp.api.util.Utilities;
import java.io.IOException;
import javax.microedition.io.Connector;

public class ImageProcessing
implements LocalSAPIMessageListener {
    private LocalMessageProtocolConnection imageProcessingConnection;
    private String VERSION = "1.[0-10]";
    private String serverURL = "localmsg://nokia.image-processing";
    private int byteSize = 500;
    private SAPIClient client;
    ImageProcessingListener listener;
    private int transCounter = 0;
    public static String ASPECT_UNLOCKED = "Unlocked";
    public static String ASPECT_LOCK_TO_X = "LockToX";
    public static String ASPECT_LOCK_TO_Y = "LockToY";
    public static String ASPECT_FULL_IMAGE = "FullImage";
    public static String ASPECT_LOCK_PARTIAL = "LockToPartialView";

    public ImageProcessing(ImageProcessingListener listr) {
        this.listener = listr;
    }

    public void connect() throws IOException {
        this.imageProcessingConnection = (LocalMessageProtocolConnection)Connector.open((String)this.serverURL);
        this.client = new SAPIClient(this.imageProcessingConnection, this, this.VERSION, this.byteSize);
    }

    public void closeConnection() {
        if (this.client != null) {
            this.client.close();
        }
    }

    public byte resizeImage(String path, int width, int height) {
        return this.resizeImage(path, width, height, ASPECT_LOCK_PARTIAL);
    }

    public byte resizeImage(String path, int width, int height, String aspect) {
        byte transid = -1;
        if (this.client != null) {
            try {
                byte[] data_out = null;
                DataEncoder encoder = new DataEncoder("Conv-BEB");
                encoder.putStart(14, "event");
                encoder.put(13, "name", "Scale");
                this.transCounter = (this.transCounter + 1) % 63;
                transid = (byte)this.transCounter;
                encoder.put(2, "trans_id", (long)transid);
                encoder.put(11, "filename", path);
                encoder.putStart(15, "limits");
                encoder.put(5, "max_vres", (long)height);
                encoder.put(5, "max_hres", (long)width);
                encoder.put(5, "max_kb", 100L);
                encoder.putEnd(15, "limits");
                encoder.put(10, "aspect", aspect);
                encoder.put(2, "quality", 80L);
                encoder.putEnd(14, "event");
                data_out = encoder.getData();
                if (data_out != null) {
                    this.client.sendData(data_out);
                    Utilities.logData("ResizeImage Requested");
                }
                data_out = null;
                encoder = null;
            }
            catch (IOException ex) {
                ex.printStackTrace();
            }
        }
        return transid;
    }

    public void localSAPIMessageReceived(String method, DataDecoder decoder) {
        Utilities.logData("IP message received:" + method);
        if (method.equals("Scale")) {
            try {
                this.decodeScaleMessage(decoder);
            }
            catch (IOException ex) {
                ex.printStackTrace();
            }
        }
    }

    public void SAPIconnectionClosed(int reason) {
        this.listener.imageProcessingSystemMessageReceived("Closed:" + reason);
    }

    public void commonSAPIMessageReceived(String msg) {
        this.listener.imageProcessingSystemMessageReceived(msg);
    }

    public void SAPIready() {
        this.listener.imageProcessingServerReady();
    }

    private void decodeScaleMessage(DataDecoder decoder) throws IOException {
        byte transid = (byte)decoder.getInteger(2);
        String status = decoder.getString(10);
        String filename = decoder.getString(11);
        Utilities.logData("IP status:" + status + " tid" + transid + " - filename" + filename);
        if (status.equals("Cancelled") || status.equals("Suspended") || status.equals("QueueFull") || status.equals("OutOfMemory") || status.equals("ImageTypeNotSupported") || status.equals("FileNotFound") || status.equals("InvalidID") || status.equals("InvalidParameters")) {
            this.listener.imageScaleError(transid, status);
        } else if (status.equals("Complete")) {
            this.listener.imageScaleComplete(transid, filename);
        }
    }
}

