/*
 * Decompiled with CFR 0.152.
 */
package com.whatsapp.api.contacts;

import com.whatsapp.api.contacts.ContactPIMKey;
import com.whatsapp.api.util.Serializer;
import com.whatsapp.api.util.Utilities;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.EOFException;
import java.io.IOException;

public class ContactStatusPIMKey {
    public static final Serializer SERIALIZER = new Serializer(){

        public void serializeToDOS(Object obj, DataOutputStream dOS) throws IOException {
            ((ContactStatusPIMKey)obj).serializeToDOS(dOS);
        }

        public Object unserializeFromDIS(DataInputStream dIS) throws IOException {
            return ContactStatusPIMKey.unserializeFromDIS(dIS);
        }
    };
    public final String _status;
    public final int _legacyCategory;
    public final ContactPIMKey _pimKey;

    public ContactStatusPIMKey(String status, int legacyCategory, ContactPIMKey pimKey) {
        this._status = status;
        this._legacyCategory = legacyCategory;
        this._pimKey = pimKey;
    }

    public void serializeToDOS(DataOutputStream dOS) throws IOException {
        Utilities.safeStringOut(this._status, dOS);
        dOS.writeInt(this._legacyCategory);
        this._pimKey.serializeToDOS(dOS);
    }

    public static Object unserializeFromDIS(DataInputStream dIS) throws IOException {
        String status = Utilities.readBlankAsNull(dIS);
        int category = dIS.readInt();
        ContactPIMKey cpk = null;
        if (dIS.available() > 0) {
            try {
                cpk = (ContactPIMKey)ContactPIMKey.unserializeFromDIS(dIS);
            }
            catch (EOFException ex) {
                // empty catch block
            }
        }
        return new ContactStatusPIMKey(status, category, cpk);
    }
}

