/*
 * Decompiled with CFR 0.152.
 */
package com.whatsapp.api.contacts;

import com.whatsapp.api.util.Utilities;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;

public class ContactStatusDetails {
    public String _jid;
    public String _phoneNumber;
    public String _status;
    public long _timeSinceSet;
    public int _category;
    public boolean _isHoldout;

    ContactStatusDetails() {
    }

    ContactStatusDetails(String jid, String phoneNumber, boolean isHoldout) {
        this._jid = jid;
        this._phoneNumber = phoneNumber;
        this._isHoldout = isHoldout;
    }

    ContactStatusDetails(String status, long timeSinceSet) {
        this._status = status;
        this._timeSinceSet = timeSinceSet;
    }

    ContactStatusDetails(String status, long timeSinceSet, String jid, String phoneNumber) {
        this(status, timeSinceSet);
        this._jid = jid;
        this._phoneNumber = phoneNumber;
    }

    public void updateInfo(ContactStatusDetails cSD) {
        if (cSD == null) {
            return;
        }
        if (!cSD._jid.equals(this._jid)) {
            Utilities.logData("@@@@ ASSERT FAIL: updating info of existing CSD " + this._jid + " with " + cSD._jid);
            return;
        }
        this._status = cSD._status;
        this._timeSinceSet = cSD._timeSinceSet;
        this._isHoldout = cSD._isHoldout;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        if (this._isHoldout) {
            sb.append("*HOLDOUT* - ");
        } else {
            sb.append("[");
            sb.append(this._status);
            sb.append("] - ");
        }
        sb.append(this._jid);
        return sb.toString();
    }

    public void serializeToDOS(DataOutputStream dOS) throws IOException {
        dOS.writeUTF(this._jid);
        dOS.writeUTF(this._phoneNumber);
        if (this._status != null) {
            dOS.writeUTF(this._status);
        } else {
            dOS.writeUTF("");
        }
        dOS.writeLong(this._timeSinceSet);
        dOS.writeInt(this._category);
        dOS.writeBoolean(this._isHoldout);
    }

    public static ContactStatusDetails unserializeFromDIS(DataInputStream dIS) throws IOException {
        ContactStatusDetails cSD = new ContactStatusDetails();
        cSD._jid = dIS.readUTF();
        cSD._phoneNumber = dIS.readUTF();
        cSD._status = dIS.readUTF();
        cSD._timeSinceSet = dIS.readLong();
        cSD._category = dIS.readInt();
        cSD._isHoldout = dIS.readBoolean();
        return cSD;
    }
}

