/*
 * Decompiled with CFR 0.152.
 */
package com.whatsapp.client.test;

import com.whatsapp.api.util.AppManager;
import com.whatsapp.api.util.Utilities;
import com.whatsapp.client.ApplicationData;
import com.whatsapp.client.ChatPane;
import com.whatsapp.client.Constants;
import com.whatsapp.client.ContactListPane;
import com.whatsapp.client.FGApp;
import com.whatsapp.client.InitForm;
import com.whatsapp.client.PhoneReg;
import com.whatsapp.client.PhoneRegBase;
import com.whatsapp.client.PhoneRegSMS;
import com.whatsapp.client.PhoneRegSMSFail;
import com.whatsapp.client.PhoneRegVoice;
import com.whatsapp.client.WelcomeScreen;
import javax.microedition.lcdui.Alert;
import javax.microedition.lcdui.AlertType;
import javax.microedition.lcdui.Command;
import javax.microedition.lcdui.CommandListener;
import javax.microedition.lcdui.Display;
import javax.microedition.lcdui.Displayable;
import javax.microedition.lcdui.Item;
import javax.microedition.midlet.MIDlet;
import javax.microedition.rms.RecordStoreException;

public class ContactListMidlet
extends MIDlet {
    public static final int MIDLET_NUMBER = 2;
    public Display _display;
    private static ContactListMidlet _instance;

    public static ContactListMidlet getInstance() {
        return _instance;
    }

    public void startApp() {
        _instance = this;
        this._display = Display.getDisplay((MIDlet)this);
        AppManager.initialize(2);
        Utilities.startLogging(false);
        Utilities.logData("fg running");
        String jidArg = System.getProperty(Constants.ARG_LAUNCH_JID);
        if (jidArg != null && jidArg.length() == 0) {
            jidArg = null;
        }
        FGApp fgApp = FGApp.getInstance();
        fgApp.initialize(jidArg);
        this.startupScreenflow();
    }

    public void pauseApp() {
        Utilities.syncLogData("FG Midlet paused");
    }

    public void destroyApp(boolean unconditional) {
        Utilities.syncLogData("FG Midlet destroyed with unconditional: " + unconditional);
    }

    public Displayable startupScreenflow() {
        Object ret;
        FGApp fgApp = FGApp.getInstance();
        if (ApplicationData.expired() && this.getAppProperty(Constants.MIDLET_VERSION).equals(ApplicationData.lastVersionRunAs())) {
            ret = new ExpiredAlert();
            this._display.setCurrent((Displayable)ret);
        } else if (ApplicationData.phoneRegStep() > 0) {
            PhoneRegBase regDisplay;
            try {
                switch (ApplicationData.phoneRegStep()) {
                    case 1: {
                        PhoneRegSMS phoneRegSMS = new PhoneRegSMS();
                        phoneRegSMS.startSMSReg();
                        regDisplay = phoneRegSMS;
                        break;
                    }
                    case 2: {
                        regDisplay = new PhoneRegSMSFail();
                        break;
                    }
                    case 3: {
                        regDisplay = new PhoneRegVoice();
                        break;
                    }
                    default: {
                        throw new IllegalArgumentException("reg/bad-step: " + ApplicationData.phoneRegStep());
                    }
                }
                fgApp.setTopPane((Object)regDisplay);
                this._display.setCurrent((Displayable)regDisplay);
            }
            catch (IllegalArgumentException ex) {
                Utilities.logData("reg/sms/error: " + ex.toString());
                try {
                    PhoneReg.resetReg();
                }
                catch (RecordStoreException rex) {
                    Utilities.logData("reg/settings-error: " + rex.toString());
                }
                PhoneReg fpF = new PhoneReg();
                fgApp.setTopPane((Object)fpF);
                this._display.setCurrentItem((Item)fpF.ccChoice);
                regDisplay = fpF;
            }
            ret = regDisplay;
        } else if (!ApplicationData.phoneNumberConfirmed() || ApplicationData.emptyPhoneNumber() || ApplicationData.emptyChatUserID()) {
            PhoneReg fpF;
            ret = fpF = new PhoneReg();
            fgApp.setTopPane(ret);
            this._display.setCurrentItem((Item)fpF.ccChoice);
        } else if (ApplicationData.emptyPushName()) {
            WelcomeScreen welcomeScr = new WelcomeScreen();
            ret = welcomeScr;
            this._display.setCurrent((Displayable)ret);
        } else if (!ApplicationData.didFirstSync()) {
            InitForm initF = new InitForm();
            ret = initF;
            this._display.setCurrent((Displayable)ret);
            fgApp.setTopPane((Object)initF);
            initF.startReg();
        } else {
            fgApp.setMyJid();
            String jidArg = System.getProperty(Constants.ARG_LAUNCH_JID);
            String isGroupArg = System.getProperty(Constants.ARG_IS_GROUP);
            boolean isGroup = isGroupArg != null && isGroupArg.equals("1");
            String forceTitle = System.getProperty(Constants.ARG_CHAT_TITLE);
            if (jidArg != null && !jidArg.equals(Constants.ARG_NEW_CHAT_JID)) {
                ContactListPane mainF = new ContactListPane(false, false);
                ChatPane cp = new ChatPane(jidArg, true, isGroup, forceTitle);
                ret = cp;
                this._display.setCurrent((Displayable)ret);
            } else {
                ContactListPane mainF = new ContactListPane(true, jidArg != null && jidArg.equals(Constants.ARG_NEW_CHAT_JID));
                ret = mainF;
                fgApp.setTopPane(ret);
                this._display.setCurrent((Displayable)mainF);
            }
        }
        return ret;
    }

    public void postShow(final Displayable displayable) {
        this._display.callSerially(new Runnable(){

            public void run() {
                ContactListMidlet.this._display.setCurrent(displayable);
            }
        });
    }

    public void postShow(final Alert alert, final Displayable nextDisplayable) {
        final Display display = Display.getDisplay((MIDlet)this);
        display.callSerially(new Runnable(){

            public void run() {
                display.setCurrent(alert, nextDisplayable);
            }
        });
    }

    private class ExpiredAlert
    extends Alert
    implements CommandListener {
        private final Command _upgradeCmd = new Command("upgrade", 4, 1);
        private final Command _exitCmd = new Command("exit", 7, 1);

        private ExpiredAlert() {
            super("attention", "This copy of WhatsApp has expired. Please click upgrade to start the upgrade process", null, AlertType.WARNING);
            this.addCommand(this._upgradeCmd);
            this.addCommand(this._exitCmd);
            this.setCommandListener(this);
        }

        public void commandAction(Command command, Displayable d) {
            if (command == this._upgradeCmd) {
                try {
                    ContactListMidlet.this.platformRequest(Constants.URL_OTA_INSTALL);
                }
                catch (Exception x) {
                    Alert errAlert = new Alert("browser launch failed", "Please go to this URL: " + Constants.URL_OTA_INSTALL, null, AlertType.ERROR);
                    ContactListMidlet.this._display.setCurrent((Displayable)errAlert);
                }
                ContactListMidlet.this.notifyDestroyed();
            } else if (command == this._exitCmd) {
                ContactListMidlet.this.notifyDestroyed();
            }
        }
    }
}

