/*
 * Decompiled with CFR 0.152.
 */
package com.whatsapp.client;

import com.whatsapp.api.util.Utilities;
import com.whatsapp.client.FGApp;
import com.whatsapp.client.Res;
import com.whatsapp.client.Settings;
import javax.microedition.lcdui.Alert;
import javax.microedition.lcdui.AlertType;
import javax.microedition.lcdui.Command;
import javax.microedition.lcdui.CommandListener;
import javax.microedition.lcdui.Display;
import javax.microedition.lcdui.Displayable;
import javax.microedition.lcdui.List;
import javax.microedition.lcdui.TextBox;
import javax.microedition.rms.RecordStoreException;

public class SettingsList
extends List
implements CommandListener,
Settings.Listener {
    private static final int CHAT_NAME_IDX = 0;
    private static final int ROAM_IDX = 1;
    private static final String[] ROAM_CHOICES = new String[]{Res.getString(83), Res.getString(89)};
    private static final int[] ROAM_VALUES = new int[]{0, 1};
    private final Command selectCommand;
    private final Command backCommand;
    private final Command okCommand;
    private final Command cancelCommand;
    private String chat_name;
    private int roam;
    private Displayable _parentScr;
    private Display _display;

    public SettingsList(Displayable parentScr, Display display) throws RecordStoreException {
        super(Res.getString(154), 3);
        this._parentScr = parentScr;
        this._display = display;
        this.setFitPolicy(1);
        this.selectCommand = new Command(Res.getString(144), 8, 1);
        this.setSelectCommand(this.selectCommand);
        this.backCommand = new Command(Res.getString(59), 2, 1);
        this.addCommand(this.backCommand);
        this.okCommand = new Command(Res.getString(109), 4, 1);
        this.cancelCommand = new Command(Res.getString(63), 3, 1);
        this.populate();
        Settings.addListener(this);
        this.setCommandListener(this);
    }

    public void onSettingChanged(int setting, boolean localOrigin) {
        switch (setting) {
            case 0: 
            case 1: {
                this.repopulate();
            }
        }
    }

    private void populate() throws RecordStoreException {
        this.chat_name = Settings.getString(0);
        this.append(Res.getString(68) + ':' + '\n' + this.chat_name, null);
        this.roam = Settings.getInt(1);
        this.append(Res.getString(67) + ':' + '\n' + ROAM_CHOICES[this.roam], null);
    }

    private void repopulate() {
        this.deleteAll();
        try {
            this.populate();
        }
        catch (RecordStoreException ex) {
            Utilities.logData("settings-list/populate/error: " + (Object)((Object)ex));
            this._display.setCurrent(new Alert(Res.getString(90), Res.getString(57), null, AlertType.ERROR), (Displayable)this);
        }
    }

    private void showTextEditor(String title, String text, int maxSize, int constraints, final int settingId) {
        final TextBox editor = new TextBox(title, text, maxSize, constraints);
        editor.addCommand(this.okCommand);
        editor.addCommand(this.cancelCommand);
        CommandListener listener = new CommandListener(){

            public void commandAction(Command cmd, Displayable d) {
                if (cmd == SettingsList.this.okCommand) {
                    try {
                        Settings.set(settingId, editor.getString());
                        SettingsList.this._display.setCurrent((Displayable)SettingsList.this);
                    }
                    catch (RecordStoreException ex) {
                        Utilities.logData("settings-list/set/error: " + (Object)((Object)ex));
                        SettingsList.this._display.setCurrent(new Alert(Res.getString(90), Res.getString(56), null, AlertType.ERROR), (Displayable)SettingsList.this);
                    }
                } else if (cmd == SettingsList.this.cancelCommand) {
                    SettingsList.this._display.setCurrent((Displayable)SettingsList.this);
                }
            }
        };
        editor.setCommandListener(listener);
        this._display.setCurrent((Displayable)editor);
    }

    private void showChooser(String title, String[] choices, final int[] values, int selected, final int settingId) {
        final List chooser = new List(title, 1, choices, null);
        chooser.setSelectedIndex(selected, true);
        chooser.addCommand(this.okCommand);
        chooser.addCommand(this.cancelCommand);
        CommandListener listener = new CommandListener(){

            public void commandAction(Command cmd, Displayable d) {
                if (cmd == SettingsList.this.okCommand) {
                    try {
                        Settings.set(settingId, values[chooser.getSelectedIndex()]);
                        SettingsList.this._display.setCurrent((Displayable)SettingsList.this);
                    }
                    catch (RecordStoreException ex) {
                        Utilities.logData("settings-list/set/error: " + (Object)((Object)ex));
                        SettingsList.this._display.setCurrent(new Alert(Res.getString(90), Res.getString(56), null, AlertType.ERROR), (Displayable)SettingsList.this);
                    }
                } else if (cmd == SettingsList.this.cancelCommand) {
                    SettingsList.this._display.setCurrent((Displayable)SettingsList.this);
                }
            }
        };
        chooser.setCommandListener(listener);
        this._display.setCurrent((Displayable)chooser);
    }

    public void commandAction(Command command, Displayable displayable) {
        if (command == this.selectCommand) {
            switch (this.getSelectedIndex()) {
                case 0: {
                    this.showTextEditor(Res.getString(68), this.chat_name, 20, 0, 0);
                    break;
                }
                case 1: {
                    this.showChooser(Res.getString(67), ROAM_CHOICES, ROAM_VALUES, this.roam, 1);
                }
            }
        } else if (command == this.backCommand) {
            this._display.setCurrent(this._parentScr);
            FGApp.getInstance().setTopPane(this._parentScr);
        }
    }
}

