/*
 * Decompiled with CFR 0.152.
 */
package com.whatsapp.client;

import com.whatsapp.api.sapi.SMS;
import com.whatsapp.api.sapi.SMSListener;
import com.whatsapp.api.util.DateTimeUtilities;
import com.whatsapp.api.util.Utilities;
import com.whatsapp.client.PhoneRegBase;
import com.whatsapp.client.Res;
import java.io.IOException;
import java.io.InterruptedIOException;
import java.util.Random;
import java.util.Timer;
import java.util.TimerTask;
import javax.microedition.io.Connector;
import javax.microedition.lcdui.Alert;
import javax.microedition.lcdui.AlertType;
import javax.microedition.lcdui.Command;
import javax.microedition.lcdui.CommandListener;
import javax.microedition.lcdui.Displayable;
import javax.microedition.lcdui.Gauge;
import javax.microedition.lcdui.Item;
import javax.microedition.rms.RecordStoreException;
import javax.wireless.messaging.Message;
import javax.wireless.messaging.MessageConnection;
import javax.wireless.messaging.TextMessage;

public class PhoneRegSMS
extends PhoneRegBase
implements CommandListener {
    private static final int SELF_SMS_TIMEOUT = 300000;
    private static final int SERVER_SMS_TIMEOUT = 300000;
    private static final int INDICATOR_UPDATE_PERIOD = 1000;
    private static final int AUTH_LEN = 32;
    private static final int AUTH_PORT_MIN = 16000;
    private static final int AUTH_PORT_MAX = 16999;
    private final Command editCommand = new Command(Res.getString(88), 2, 0);
    private static final int ATTEMPT_MAX = 2;
    private int attempt = 1;
    private final Gauge indicator = new Gauge(null, false, 100, 0);
    private final Timer timeoutTimer = new Timer();
    private final Timer uiTimer = new Timer();
    private MessageSender sender = null;
    private MessageReader reader = null;
    private ServerSendMessageReader serverSendReader = null;

    public PhoneRegSMS() throws IllegalArgumentException {
        super(Res.getString(155));
        if (this.number == null || this.cc == -1) {
            throw new IllegalArgumentException("phone number or cc not set");
        }
        this.append(Res.getString(152, this.smsNumber));
        this.append((Item)this.indicator);
        this.append(Res.getString(124));
        this.addCommand(this.editCommand);
        this.setCommandListener(this);
    }

    public void commandAction(Command cmd, Displayable d) {
        if (cmd == this.editCommand) {
            this.mid._display.setCurrent((Alert)new EditConfirmAlert(), (Displayable)this);
        }
    }

    private void updateIndicator(int diff) {
        int timeout = 600000;
        int percentDone = diff * 100 / timeout;
        int timeLeft = timeout - diff;
        this.indicator.setValue(percentDone);
        this.indicator.setLabel(Res.getString(184, Integer.toString(this.attempt)) + ' ' + '(' + DateTimeUtilities.timeFormatMS(timeLeft) + ')');
    }

    public void startSMSReg() {
        Utilities.logData("reg/sms/start");
        this.startCodeRequest("self");
        final long start = System.currentTimeMillis();
        this.uiTimer.scheduleAtFixedRate(new TimerTask(){

            public void run() {
                PhoneRegSMS.this.updateIndicator((int)(this.scheduledExecutionTime() - start));
            }
        }, 0L, 1000L);
        this.timeoutTimer.schedule(new TimerTask(){

            public void run() {
                PhoneRegSMS.this.onSelfSMSTimeout();
            }
        }, 300000L);
    }

    public void stopSMSReg() {
        Utilities.logData("reg/sms/stop");
        this.uiTimer.cancel();
        this.timeoutTimer.cancel();
        this.stopSelfSendSMS();
        this.stopServerSendSMS();
    }

    protected void gotoNextRegStep() {
        this.stopSMSReg();
        try {
            PhoneRegSMS.nextRegStep();
            this.mid.startupScreenflow();
        }
        catch (RecordStoreException ex) {
            Utilities.logData("reg/sms/next/rms-error: " + ex.toString());
        }
    }

    public void notifyHide() {
        this.stopSMSReg();
    }

    protected void onRegRequestError(String msg) {
        this.showErrorResetReg(msg);
    }

    protected void onCodeRequestDone(String method, String status, String result) {
        if (status != null && status.equals("success-attached") && method.equals("self") && result != null) {
            this.startSelfSendSMS(result);
            return;
        }
        super.onCodeRequestDone(method, status, result);
    }

    protected void onCodeRequestError(String method, String msg) {
        this.showErrorResetReg(msg);
    }

    private void startSelfSendSMS(String code) {
        if (this.isSending() || this.isReading()) {
            Utilities.logData("reg/sms/self/start/already-started");
            return;
        }
        Random rand = new Random(System.currentTimeMillis());
        int srcPort = 16000 + rand.nextInt(999);
        int dstPort = 16000 + rand.nextInt(999);
        StringBuffer authBuf = new StringBuffer(32);
        for (int i = 0; i < 32; ++i) {
            char ch = (char)(48 + rand.nextInt(62));
            if (ch > '9') {
                ch = (char)(ch + 7);
            }
            if (ch > 'Z') {
                ch = (char)(ch + 6);
            }
            authBuf.append(ch);
        }
        String auth = authBuf.toString();
        String text = authBuf.insert(0, "WhatsApp ").append(" Internal, can be deleted").toString();
        Utilities.logData("reg/sms/self/start");
        this.reader = new MessageReader(this.smsNumber, auth, srcPort, dstPort, code);
        this.sender = new MessageSender(this.smsNumber, text, srcPort, dstPort);
        this.reader.start();
        this.sender.start();
    }

    private void onSelfSMSTimeout() {
        Utilities.logData("reg/sms/self/timeout");
        boolean wasRequesting = this.isRequesting();
        this.stopSelfSendSMS();
        if (!wasRequesting) {
            this.startServerSendSMS();
        } else {
            this.showErrorResetReg(null);
        }
    }

    private void stopSelfSendSMS() {
        Utilities.logData("reg/sms/self/stop");
        this.stopCodeRequest("self");
        if (this.isSending()) {
            this.sender.stop();
        }
        if (this.isReading()) {
            this.reader.stop();
        }
    }

    private boolean isSending() {
        return this.sender != null && !this.sender.isStopped();
    }

    private boolean isReading() {
        return this.reader != null && !this.reader.isStopped();
    }

    private void startServerSendSMS() {
        if (this.isCodeRequesting("sms") || this.isReadingServerSend()) {
            Utilities.logData("reg/sms/server/start/already-started");
            return;
        }
        this.attempt = 2;
        this.timeoutTimer.schedule(new TimerTask(){

            public void run() {
                PhoneRegSMS.this.onServerSendSMSTimeout();
            }
        }, 300000L);
        Utilities.logData("reg/sms/server/start");
        this.serverSendReader = new ServerSendMessageReader();
        this.serverSendReader.start();
        this.startCodeRequest("sms");
    }

    private void onServerSendSMSTimeout() {
        Utilities.logData("reg/sms/server/timeout");
        boolean wasRequesting = this.isRequesting();
        this.stopServerSendSMS();
        if (!wasRequesting) {
            this.gotoNextRegStep();
        } else {
            this.showErrorResetReg(null);
        }
    }

    private void stopServerSendSMS() {
        Utilities.logData("reg/sms/server/stop");
        this.stopCodeRequest("sms");
        if (this.isReadingServerSend()) {
            this.serverSendReader.stop();
        }
    }

    private boolean isReadingServerSend() {
        return this.serverSendReader != null && !this.serverSendReader.isStopped();
    }

    private class EditConfirmAlert
    extends Alert
    implements CommandListener {
        private final Command yesCommand = new Command(Res.getString(181), 4, 0);
        private final Command noCommand = new Command(Res.getString(107), 3, 1);

        private EditConfirmAlert() {
            super(null, Res.getString(185), null, AlertType.WARNING);
            this.setCommandListener(this);
            this.addCommand(this.yesCommand);
            this.addCommand(this.noCommand);
        }

        public void commandAction(Command command, Displayable d) {
            if (command == this.yesCommand) {
                try {
                    PhoneRegBase.resetReg();
                    PhoneRegSMS.this.stopSMSReg();
                    PhoneRegSMS.this.mid.startupScreenflow();
                }
                catch (RecordStoreException ex) {
                    Utilities.logData("reg/sms/reset/rms-error: " + ex.toString());
                }
            } else if (command == this.noCommand) {
                PhoneRegSMS.this.mid._display.setCurrent((Displayable)PhoneRegSMS.this);
            }
        }
    }

    private class ServerSendMessageReader
    extends Thread
    implements SMSListener {
        private static final String CODE_MESSAGE_HEADER = "WhatsApp code ";
        private static final long CLOSE_WAIT_TIME = 2000L;
        private final SMS sapi = new SMS(this);
        private boolean stopped = false;
        private boolean wantsStop = false;

        private ServerSendMessageReader() {
        }

        public void stop() {
            this.wantsStop = true;
            try {
                if (this.sapi.closeConnection()) {
                    Utilities.logData("reg/sms/server/reader/stop");
                    this.stopped = true;
                }
            }
            catch (IOException ex) {
                Utilities.logData("reg/sms/server/reader/close/io-error: " + ex.toString());
                this.stopped = true;
            }
        }

        public boolean isStopped() {
            return this.stopped || this.wantsStop;
        }

        public void run() {
            try {
                this.sapi.connect();
            }
            catch (IOException ex) {
                Utilities.logData("reg/sms/server/reader/connect/io-error: " + ex.toString());
            }
            if (this.wantsStop) {
                this.stopped = true;
                try {
                    this.sapi.closeConnection();
                    Utilities.logData("reg/sms/server/reader/stop");
                }
                catch (IOException ex) {
                    Utilities.logData("reg/sms/server/reader/close/io-error: " + ex.toString());
                }
            }
        }

        public void SMSsystemMessageReceived(String message) {
        }

        public void SMSServerReady() {
        }

        public void SMSServerClosed(int reason) {
        }

        public void SMSNotificationServiceError(int transid) {
            Utilities.logData("reg/sms/server/reader/error");
        }

        public void SMSReceived(String sender, String message, long msgId) {
            int end;
            if (message == null) {
                return;
            }
            Utilities.logData("reg/sms/server/recv");
            int start = message.indexOf(CODE_MESSAGE_HEADER) + CODE_MESSAGE_HEADER.length();
            if (start < CODE_MESSAGE_HEADER.length()) {
                return;
            }
            for (end = start; end < message.length() && Character.isDigit(message.charAt(end)); ++end) {
            }
            if (start == end) {
                return;
            }
            this.sapi.deleteMessage(msgId);
            Utilities.logData("reg/sms/server/pass");
            PhoneRegSMS.this.startRegRequest(message.substring(start, end));
            try {
                Thread.sleep(2000L);
            }
            catch (InterruptedException ex) {
                // empty catch block
            }
            this.stop();
        }
    }

    private class MessageReader
    extends MessageConnectionThread {
        private final String smsNumber;
        private final String auth;
        private final int srcPort;
        private final int dstPort;
        private final String code;

        public MessageReader(String smsNumber, String auth, int srcPort, int dstPort, String code) {
            this.smsNumber = smsNumber;
            this.auth = auth;
            this.srcPort = srcPort;
            this.dstPort = dstPort;
            this.code = code;
        }

        public void run() {
            if (this.recv()) {
                PhoneRegSMS.this.startRegRequest(this.code);
            } else if (!this.stopped) {
                PhoneRegSMS.this.stopSelfSendSMS();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean recv() {
            Utilities.logData("reg/sms/self/recv/start");
            MessageConnection conn = null;
            try {
                String listenAddr = "sms://:" + this.dstPort;
                conn = this.openConnection(listenAddr);
                Utilities.logData("reg/sms/self/recv");
                Message msg = conn.receive();
                Utilities.logData("reg/sms/self/recv'd");
                if (msg == null || !(msg instanceof TextMessage)) {
                    Utilities.logData("reg/sms/self/recv/not-sms");
                    boolean bl = false;
                    return bl;
                }
                String senderAddr = this.smsNumber + ":" + this.srcPort;
                int srcPortLen = senderAddr.length() - this.smsNumber.length();
                String address = ((TextMessage)msg).getAddress();
                if (address == null) {
                    Utilities.logData("reg/sms/self/recv/no-address");
                    boolean bl = false;
                    return bl;
                }
                int N = Math.max(2 + srcPortLen, Math.min(senderAddr.length(), address.length()) - 3);
                String senderAddrSuffix = senderAddr.substring(senderAddr.length() - N);
                if (!address.endsWith(senderAddrSuffix)) {
                    Utilities.logData("reg/sms/self/recv/bad-address");
                    boolean bl = false;
                    return bl;
                }
                Utilities.logData("reg/sms/self/verify/pass3");
                String text = ((TextMessage)msg).getPayloadText();
                if (text == null || text.indexOf(this.auth) == -1) {
                    Utilities.logData("reg/sms/self/recv/bad-auth-code");
                    boolean bl = false;
                    return bl;
                }
                boolean bl = true;
                return bl;
            }
            catch (InterruptedIOException ex) {
                if (!this.stopped) {
                    Utilities.logData("reg/sms/self/recv/interrupted");
                }
            }
            catch (IOException ex) {
                if (!this.stopped) {
                    Utilities.logData("reg/sms/self/recv/io-error: " + ex.toString());
                }
            }
            finally {
                if (conn != null) {
                    try {
                        conn.close();
                    }
                    catch (IOException ex) {
                        Utilities.logData("reg/sms/self/recv/close/io-error: " + ex.toString());
                    }
                }
            }
            return false;
        }
    }

    private class MessageSender
    extends MessageConnectionThread {
        private final String smsNumber;
        private final String text;
        private final int srcPort;
        private final int dstPort;

        public MessageSender(String smsNumber, String text, int srcPort, int dstPort) {
            this.smsNumber = smsNumber;
            this.text = text;
            this.srcPort = srcPort;
            this.dstPort = dstPort;
        }

        public void run() {
            if (!this.send() && !this.stopped) {
                PhoneRegSMS.this.stopSelfSendSMS();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean send() {
            Utilities.logData("reg/sms/self/send/start");
            MessageConnection conn = null;
            try {
                String srcAddr = "sms://:" + this.srcPort;
                conn = this.openConnection(srcAddr);
                String dstAddr = "sms://" + this.smsNumber + ":" + this.dstPort;
                TextMessage msg = (TextMessage)conn.newMessage("text", dstAddr);
                msg.setPayloadText(this.text);
                Utilities.logData("reg/sms/self/send");
                conn.send((Message)msg);
                Utilities.logData("reg/sms/self/sent");
                boolean bl = true;
                return bl;
            }
            catch (InterruptedIOException ex) {
                if (!this.stopped) {
                    Utilities.logData("reg/sms/self/send/interrupted");
                }
            }
            catch (IOException ex) {
                if (!this.stopped) {
                    Utilities.logData("reg/sms/self/send/io-error: " + ex.toString());
                }
            }
            catch (SecurityException ex) {
                Utilities.logData("reg/sms/self/send/permission-denied: " + ex.toString());
            }
            finally {
                if (conn != null) {
                    try {
                        conn.close();
                    }
                    catch (IOException ex) {
                        Utilities.logData("reg/sms/self/send/close/io-error: " + ex.toString());
                    }
                }
            }
            return false;
        }
    }

    private static class MessageConnectionThread
    extends Thread {
        private MessageConnection conn;
        private boolean opened = false;
        protected boolean stopped = false;
        protected boolean wantsStop = false;

        private MessageConnectionThread() {
        }

        protected MessageConnection openConnection(String addr) throws IOException {
            if (this.opened) {
                throw new IllegalArgumentException("connection already opened");
            }
            this.conn = (MessageConnection)Connector.open((String)addr);
            this.opened = true;
            if (this.wantsStop) {
                this.stopped = true;
                this.conn.close();
                throw new InterruptedIOException("stopped");
            }
            return this.conn;
        }

        public void stop() {
            this.wantsStop = true;
            if (!this.opened) {
                return;
            }
            this.stopped = true;
            try {
                this.conn.close();
            }
            catch (IOException ex) {
                Utilities.logData("reg/sms/self/conn/close/io-error: " + ex.toString());
            }
        }

        public boolean isStopped() {
            return this.stopped || this.wantsStop || this.opened && !this.isAlive();
        }
    }
}

