/*
 * Decompiled with CFR 0.152.
 */
package com.whatsapp.client;

import com.whatsapp.api.contacts.Syncer;
import com.whatsapp.api.util.Utilities;
import com.whatsapp.client.ApplicationData;
import com.whatsapp.client.Constants;
import com.whatsapp.client.FGApp;
import com.whatsapp.client.Res;
import com.whatsapp.client.Settings;
import com.whatsapp.client.test.ContactListMidlet;
import com.whatsapp.org.it.yup.xml.KXmlParser;
import com.whatsapp.org.xmlpull.v1.XmlPullParserException;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.InterruptedIOException;
import javax.microedition.io.Connector;
import javax.microedition.io.HttpsConnection;
import javax.microedition.lcdui.Alert;
import javax.microedition.lcdui.AlertType;
import javax.microedition.lcdui.Displayable;
import javax.microedition.lcdui.Form;
import javax.microedition.rms.RecordStoreException;

public abstract class PhoneRegBase
extends Form {
    protected WARequest request = null;
    protected final ContactListMidlet mid = ContactListMidlet.getInstance();
    protected final int cc = ApplicationData.countryCallingCode();
    protected final String number = ApplicationData.phoneNumber();
    protected final String smsNumber = PhoneRegBase.getSMSNumber(this.cc, this.number);

    protected PhoneRegBase(String name) {
        super(name);
    }

    protected void notifyHide() {
    }

    protected void showErrorResetReg() {
        this.showErrorResetReg(null);
    }

    protected void showErrorResetReg(String msg) {
        try {
            PhoneRegBase.resetReg();
            this.notifyHide();
            this.showError(msg, this.mid.startupScreenflow());
        }
        catch (RecordStoreException ex) {
            Utilities.logData("reg/reset/rms-error: " + ex.toString());
            this.showError(Res.getString(55));
        }
    }

    protected void showError() {
        this.showError(null, null);
    }

    protected void showError(String msg) {
        this.showError(msg, null);
    }

    protected void showError(Displayable next) {
        this.showError(null, next);
    }

    protected void showError(String msg, Displayable next) {
        if (msg == null) {
            msg = Res.getString(74);
        }
        if (next == null) {
            next = this;
        }
        this.mid._display.setCurrent(new Alert(Res.getString(90), msg, null, AlertType.WARNING), next);
    }

    protected void startExistRequest(final int cc, final String number) {
        if (this.isRequesting()) {
            Utilities.logData("reg/req/exist/already-started");
            return;
        }
        Utilities.logData("reg/req/exist/start");
        this.request = new WAExistsRequest(cc, number){

            protected void onDone() {
                Utilities.logData("reg/req/exist/" + this.status);
                PhoneRegBase.this.onExistRequestDone(cc, number, this.status, this.result);
            }

            protected void onError(Throwable t) {
                Utilities.logData("reg/req/exist/error: " + t.toString());
                PhoneRegBase.this.onExistRequestError(cc, number, null);
            }
        };
        this.request.start();
    }

    protected void onExistRequestDone(int cc, String number, String status, String result) {
        if (status == null) {
            this.onExistRequestError(cc, number, null);
            return;
        }
        if (status.equals("ok")) {
            if (result == null) {
                Utilities.logData("reg/req/exist/ok/no-login-id");
                this.onExistRequestError(cc, number, null);
                return;
            }
            try {
                PhoneRegBase.saveReg(cc, number);
                PhoneRegBase.saveLogin(result);
                PhoneRegBase.finishReg();
                this.notifyHide();
                this.mid.startupScreenflow();
            }
            catch (RecordStoreException ex) {
                Utilities.logData("reg/req/exist/rms-error: " + ex.toString());
                this.onExistRequestError(cc, number, Res.getString(55));
            }
        }
    }

    protected void onExistRequestError(int cc, String number, String msg) {
        this.showError(msg);
    }

    protected void startCodeRequest(String method) {
        if (this.isRequesting()) {
            Utilities.logData("reg/req/code/" + method + "/already-started");
            return;
        }
        Utilities.logData("reg/req/code/" + method + "/start");
        this.request = new WACodeRequest(this.cc, this.number, method){

            protected void onDone() {
                Utilities.logData("reg/req/code/" + this.method + '/' + this.status);
                PhoneRegBase.this.onCodeRequestDone(this.method, this.status, this.result);
            }

            protected void onError(Throwable t) {
                Utilities.logData("reg/req/code/" + this.method + "/error" + t.toString());
                PhoneRegBase.this.onCodeRequestError(this.method, null);
            }
        };
        this.request.start();
    }

    protected void onCodeRequestDone(String method, String status, String result) {
        if (status == null) {
            this.onCodeRequestError(method, null);
            return;
        }
        if (status.equals("success-attached")) {
            if (result == null) {
                Utilities.logData("reg/req/code/" + method + "/no-code");
                this.onCodeRequestError(method, null);
                return;
            }
            if (!method.equals("self")) {
                this.startRegRequest(result);
            }
        } else if (!status.equals("success-sent")) {
            if (status.equals("fail-too-recent")) {
                String msg = result != null ? (method.equals("voice") ? Res.getString(187, result) : Res.getString(186, result)) : (method.equals("voice") ? Res.getString(189) : Res.getString(188));
                this.onCodeRequestError(method, msg);
            } else if (status.equals("fail-too-many")) {
                this.showErrorResetReg(Res.getString(116));
            } else {
                this.onCodeRequestError(method, null);
            }
        }
    }

    protected void onCodeRequestError(String method, String msg) {
        this.showError(msg);
    }

    protected void startRegRequest(String code) {
        if (this.isRequesting()) {
            Utilities.logData("reg/req/register/already-started");
            return;
        }
        Utilities.logData("reg/req/register/start");
        this.request = new WARegRequest(this.cc, this.number, code){

            protected void onDone() {
                Utilities.logData("reg/req/register/" + this.status);
                PhoneRegBase.this.onRegRequestDone(this.status, this.result, this.login);
            }

            protected void onError(Throwable t) {
                Utilities.logData("reg/req/register/error: " + t.toString());
                PhoneRegBase.this.onRegRequestError(null);
            }
        };
        this.request.start();
    }

    protected void onRegRequestDone(String status, String result, String login) {
        if (status == null) {
            this.onRegRequestError(null);
            return;
        }
        if (status.equals("ok")) {
            if (login == null) {
                Utilities.logData("reg/req/register/ok/no-login");
                this.onRegRequestError(null);
                return;
            }
            try {
                PhoneRegBase.saveLogin(login);
                PhoneRegBase.finishReg();
                this.notifyHide();
                this.mid.startupScreenflow();
            }
            catch (RecordStoreException ex) {
                Utilities.logData("reg/req/register/rms-error: " + ex.toString());
                this.onRegRequestError(Res.getString(55));
            }
        } else if (status.equals("too-many-guesses")) {
            this.showErrorResetReg(Res.getString(116));
        } else {
            this.onRegRequestError(null);
        }
    }

    protected void onRegRequestError(String msg) {
        this.showError(msg);
    }

    protected void stopCodeRequest(String method) {
        WARequest request = this.request;
        if (request != null && !request.isStopped() && request instanceof WACodeRequest && ((WACodeRequest)request).method.equals(method)) {
            request.stop();
        }
    }

    protected void stopRequest(Class cls) {
        WARequest request = this.request;
        if (request != null && !request.isStopped() && cls.isInstance(request)) {
            request.stop();
        }
    }

    protected boolean isCodeRequesting(String method) {
        WARequest request = this.request;
        return request != null && !request.isStopped() && request instanceof WACodeRequest && ((WACodeRequest)request).method.equals(method);
    }

    protected boolean isRequesting(Class cls) {
        WARequest request = this.request;
        return request != null && !request.isStopped() && cls.isInstance(request);
    }

    protected boolean isRequesting() {
        return this.request != null && !this.request.isStopped();
    }

    public static void nextRegStep() throws RecordStoreException {
        Settings.set(4, ApplicationData.phoneRegStep() + 1);
    }

    public static void finishReg() throws RecordStoreException {
        Settings.set(4, -1);
        Settings.set(12, System.getProperty(Constants.PROPERTY_IMSI));
        if (ApplicationData.didFirstSync()) {
            FGApp.getInstance().sendZeroDataAlertToBG((byte)73);
        }
    }

    public static void resetReg() throws RecordStoreException {
        Settings.clear(2);
        Settings.clear(4);
    }

    public static void saveReg(int cc, String number) throws RecordStoreException {
        Settings.rebuildCache();
        Settings.set(3, cc);
        Settings.set(2, number);
    }

    public static void saveLogin(String login) throws RecordStoreException {
        Settings.set(5, login);
    }

    public static String getSMSNumber(int cc, String number) {
        switch (cc) {
            case 52: {
                return number;
            }
        }
        return "+" + cc + number;
    }

    public static abstract class WARequest
    extends Thread {
        private static final byte[] BASE_URL = new byte[]{123, 103, 103, 99, 96, 41, 60, 60, 97, 61, 100, 123, 114, 103, 96, 114, 99, 99, 61, 125, 118, 103, 60, 101, 34, 60};
        private final String method;
        private final ByteArrayOutputStream queryString = new ByteArrayOutputStream();
        private HttpsConnection conn;
        private boolean opened = false;
        private boolean stopped = false;
        private boolean wantsStop = false;
        private boolean onResponseCalled;
        protected String status = null;
        protected String result = null;

        protected void onProgress(int percentDone) {
        }

        protected void onResponse(String name, String value) {
            this.onResponseCalled = true;
            if (name.equals("status")) {
                this.status = value;
            } else if (name.equals("result")) {
                this.result = value;
            }
        }

        protected abstract void onDone();

        protected final void onError() {
        }

        protected abstract void onError(Throwable var1);

        protected WARequest(String method) {
            this.method = method;
        }

        protected void addParam(String name, String value) {
            try {
                Syncer.UTF8URLEncoder.appendPair(name, value, false, this.queryString);
            }
            catch (IOException ex) {
                Utilities.logData("reg/req/" + this.method + "/add-param/io-error" + ex.toString());
            }
        }

        public void stop() {
            this.wantsStop = true;
            if (!this.opened) {
                return;
            }
            this.stopped = true;
            try {
                this.conn.close();
            }
            catch (IOException ex) {
                Utilities.logData("reg/req/" + this.method + "/conn/close/io-error: " + ex.toString());
            }
        }

        public boolean isStopped() {
            return this.stopped || this.wantsStop || this.opened && !this.isAlive();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public void run() {
            InputStream in = null;
            try {
                this.conn = (HttpsConnection)Connector.open((String)(Utilities.decodeString(BASE_URL) + this.method + ".php?" + this.queryString), (int)1, (boolean)true);
                this.opened = true;
                if (this.wantsStop) {
                    this.stopped = true;
                    this.conn.close();
                    throw new InterruptedIOException("stopped");
                }
                this.onProgress(10);
                this.conn.setRequestProperty(Constants.HTTP_REQUEST_PROPERTY_USER_AGENT, Syncer.getUserAgent());
                this.onProgress(20);
                int code = this.conn.getResponseCode();
                this.onProgress(30);
                switch (code) {
                    case 200: {
                        in = this.conn.openInputStream();
                        KXmlParser parser = new KXmlParser();
                        parser.setInput(new InputStreamReader(in, Constants.CHARSET_UTF8));
                        this.onProgress(60);
                        parser.nextTag();
                        parser.require(2, null, this.method);
                        parser.nextTag();
                        parser.require(2, null, "response");
                        for (int i = 0; i < parser.getAttributeCount(); ++i) {
                            this.onResponseCalled = false;
                            this.onResponse(parser.getAttributeName(i), parser.getAttributeValue(i));
                            if (this.onResponseCalled) continue;
                            Utilities.logData("reg/req/" + this.method + "/error: super.onResponse() not called!");
                            this.onError(null);
                            return;
                        }
                        break;
                    }
                }
            }
            catch (InterruptedIOException ex) {
                if (this.stopped) return;
                Utilities.logData("reg/req/" + this.method + "/interrupted: " + ex.toString());
                this.onError(ex);
                return;
            }
            catch (IOException ex) {
                if (this.stopped) return;
                Utilities.logData("reg/req/" + this.method + "/io-error: " + ex.toString());
                this.onError(ex);
                return;
            }
            catch (XmlPullParserException ex) {
                Utilities.logData("reg/req/" + this.method + "/xml-error: " + ex.toString());
                this.onError(ex);
                return;
            }
            finally {
                if (in != null) {
                    try {
                        in.close();
                    }
                    catch (IOException ex) {
                        Utilities.logData("reg/req/" + this.method + "/input/close/io-error: " + ex.toString());
                    }
                }
                if (this.conn != null) {
                    try {
                        this.conn.close();
                    }
                    catch (IOException ex) {
                        Utilities.logData("reg/req/" + this.method + "/conn/close/io-error: " + ex.toString());
                    }
                }
            }
            this.stopped = true;
            this.onDone();
        }
    }

    public static abstract class WARegRequest
    extends WARequest {
        protected String login = null;

        protected WARegRequest(int cc, String in, String code) {
            super("register");
            this.addParam("cc", Integer.toString(cc));
            this.addParam("in", in);
            this.addParam("udid", Utilities.getChatPassword());
            this.addParam("code", code);
        }

        protected final void onResponse(String name, String value) {
            if (name.equals("login")) {
                this.login = value;
            }
            super.onResponse(name, value);
        }
    }

    public static abstract class WACodeRequest
    extends WARequest {
        public final String method;

        protected WACodeRequest(int cc, String in, String method) {
            super("code");
            String mnc;
            this.method = method;
            String locale = System.getProperty("microedition.locale");
            String language = locale != null && locale.length() >= 2 ? locale.substring(0, 2) : "zz";
            String country = locale != null && locale.length() >= 5 ? locale.substring(3, 5) : "ZZ";
            String mccMnc = System.getProperty("com.nokia.mid.mnc");
            String mcc = mccMnc != null && mccMnc.length() >= 3 ? mccMnc.substring(0, 3) : "000";
            String string = mnc = mccMnc != null && mccMnc.length() >= 4 ? mccMnc.substring(3) : "000";
            while (mnc.length() < 3) {
                mnc = '0' + mnc;
            }
            String imsi = System.getProperty(Constants.PROPERTY_IMSI);
            this.addParam("cc", Integer.toString(cc));
            this.addParam("in", in);
            this.addParam("to", cc + in);
            this.addParam("lg", language);
            this.addParam("lc", country);
            this.addParam("mcc", mcc);
            this.addParam("mnc", mnc);
            this.addParam("method", method);
            this.addParam("imsi", imsi != null ? imsi : "00000000000000");
        }
    }

    public static abstract class WAExistsRequest
    extends WARequest {
        protected WAExistsRequest(int cc, String in) {
            super("exist");
            this.addParam("cc", Integer.toString(cc));
            this.addParam("in", in);
            this.addParam("udid", Utilities.getChatPassword());
        }
    }
}

