/*
 * Decompiled with CFR 0.152.
 */
package com.whatsapp.client;

import com.whatsapp.api.ui.UIField;
import com.whatsapp.client.FunXMPP;
import javax.microedition.lcdui.Font;
import javax.microedition.lcdui.Graphics;

public class MessageStatusIcon
extends UIField {
    public static final int MIN_CHUNK_FOR_DOUBLE_STROKE = 5;
    public static final long HIDE_CLIENT_ACK = 1L;
    FunXMPP.FMessage _chatMessage;
    public boolean _isFailAlert = false;
    private long _style;
    private int _prefWidth = -1;
    private int _prefHeight = -1;

    public MessageStatusIcon(FunXMPP.FMessage fmsg, long style) {
        super(0L);
        this._style = style;
        this._chatMessage = fmsg;
    }

    public void layout(int width, int height) {
        if (this._prefWidth == -1) {
            Font defFont = Font.getDefaultFont();
            int calcWidth = defFont.stringWidth("XX");
            this._prefWidth = Math.max(calcWidth, 23);
            this._prefHeight = Math.max(defFont.getHeight(), 20);
        }
        this.setExtent(this._prefWidth, this._prefHeight);
    }

    private static void drawCheck(Graphics g, int width, int height, int chunk, int xShift, int yShift, int foreColor, int shadowColor) {
        g.setColor(foreColor);
        g.drawLine(2 + xShift, 2 * chunk + 2 + yShift, chunk + 1 + xShift, 3 * chunk + 1 + yShift);
        g.drawLine(chunk + 1 + xShift, 3 * chunk + 1 + yShift, 3 * chunk + 1 + xShift, chunk + 1 + yShift);
        if (chunk >= 5) {
            g.drawLine(2 + xShift, 2 * chunk + 1 + yShift, chunk + 2 + xShift, 3 * chunk + 1 + yShift);
            g.drawLine(3 + xShift, 2 * chunk + 1 + yShift, chunk + 2 + xShift, 3 * chunk + yShift);
            g.drawLine(chunk + 2 + xShift, 3 * chunk + 1 + yShift, 3 * chunk + 2 + xShift, chunk + 1 + yShift);
            g.drawLine(chunk + 2 + xShift, 3 * chunk - 1 + yShift, 3 * chunk + xShift, chunk + 1 + yShift);
            g.setColor(shadowColor);
            g.drawLine(chunk + 3 + xShift, 3 * chunk + 1 + yShift, 3 * chunk + 2 + xShift, chunk + 2 + yShift);
        }
    }

    private static void serverAck(Graphics g, int x, int y, int width, int height, boolean reverseVideo) {
        int shadowColor;
        int foreColor;
        int smallestDim = Math.min(width, height);
        int chunk = smallestDim / 4;
        if (reverseVideo) {
            foreColor = 0xFFFFFF;
            shadowColor = 0x808080;
        } else {
            foreColor = 32768;
            shadowColor = 0x90EE90;
        }
        MessageStatusIcon.drawCheck(g, width, height, chunk, x, y, foreColor, shadowColor);
    }

    private static void clientAck(Graphics g, int x, int y, int width, int height, boolean reverseVideo) {
        int shadowColor;
        int foreColor;
        int smallestDim = Math.min(width, height);
        int chunk = smallestDim / 4;
        if (reverseVideo) {
            foreColor = 0xFFFFFF;
            shadowColor = 0x808080;
        } else {
            foreColor = 32768;
            shadowColor = 0x90EE90;
        }
        MessageStatusIcon.drawCheck(g, width, height, chunk, chunk + x, y, foreColor, shadowColor);
        MessageStatusIcon.drawCheck(g, width, height, chunk, x, y, foreColor, shadowColor);
    }

    private static void drawTriangle(Graphics g, int x, int y, int width, int height) {
        int[] xPts = new int[]{width / 3, 2 * width / 3, width / 3};
        int[] yPts = new int[]{height / 8, height / 2, 7 * height / 8};
        yPts[2] = yPts[2] + (yPts[2] - yPts[0]) % 2;
        g.fillTriangle(x + xPts[0], y + yPts[0], x + xPts[1], y + yPts[1], x + xPts[2], y + yPts[2]);
    }

    private static void drawAlert(Graphics g, int x, int y, int width, int height) {
        g.setColor(0xFF0000);
        int[] xPts = new int[]{width / 3, 2 * width / 3, width / 3};
        int[] yPts = new int[]{height / 8, height / 2, 7 * height / 8};
        g.fillTriangle(x + xPts[0], y + yPts[0], x + xPts[1], y + yPts[1], x + xPts[2], y + yPts[2]);
    }

    private static void drawFail(Graphics g, int x, int y, int width, int height, boolean reverseVideo) {
        int smallestDim = Math.min(width, height);
        int chunk = smallestDim / 4;
        int foreColor = reverseVideo ? 0xFFFFFF : 0xFF0000;
        g.setColor(foreColor);
        g.drawLine(x + chunk + 0, y + chunk + 0, x + chunk * 3 + 0, y + chunk * 3 + 0);
        g.drawLine(x + chunk + 1, y + chunk + 0, x + chunk * 3 + 0, y + chunk * 3 - 1);
        g.drawLine(x + chunk + 0, y + chunk + 1, x + chunk * 3 - 1, y + chunk * 3 + 0);
        g.drawLine(x + chunk * 3 + 0, y + chunk + 0, x + chunk + 0, y + chunk * 3 + 0);
        g.drawLine(x + chunk * 3 - 1, y + chunk + 0, x + chunk + 0, y + chunk * 3 - 1);
        g.drawLine(x + chunk * 3 + 0, y + chunk + 1, x + chunk + 1, y + chunk * 3 + 0);
    }

    private static void drawSending(Graphics g, int x, int y, int width, int height) {
        int smallestDim = Math.min(width, height);
        int watchWidth = smallestDim * 5 / 6;
        int xOrig = x + (width / 2 - watchWidth / 2);
        int yOrig = y + (height / 2 - watchWidth / 2);
        g.setColor(0x8B0000);
        g.fillRoundRect(xOrig, yOrig, watchWidth, watchWidth, 4, 4);
        g.setColor(0xFFFFFF);
        g.fillRoundRect(xOrig + 2, yOrig + 2, watchWidth - 4, watchWidth - 4, 4, 4);
        g.setColor(0x8B0000);
        g.drawLine(x + width / 2, y + height / 2, x + width / 2, y + (height / 2 - watchWidth / 4));
        g.drawLine(x + width / 2, y + height / 2, x + width / 2 + watchWidth / 4, y + height / 2);
    }

    public static void paintStatusIcon(Graphics g, FunXMPP.FMessage fmsg, int x, int y, int width, int height, boolean hideClientAck, boolean unread, boolean reverseVideo) {
        int origColor = g.getColor();
        if (!fmsg.key.from_me) {
            if (unread) {
                g.setColor(14329120);
            } else {
                g.setColor(0xD3D3D3);
            }
            MessageStatusIcon.drawTriangle(g, x, y, width, height);
        } else if (fmsg.status == 4 || hideClientAck && fmsg.status == 5) {
            MessageStatusIcon.serverAck(g, x, y, width, height, reverseVideo);
        } else if (fmsg.status == 5) {
            MessageStatusIcon.clientAck(g, x, y, width, height, reverseVideo);
        } else if (fmsg.status == 6) {
            MessageStatusIcon.drawAlert(g, x, y, width, height);
        } else if (fmsg.status == 7) {
            MessageStatusIcon.drawFail(g, x, y, width, height, reverseVideo);
        } else {
            MessageStatusIcon.drawSending(g, x, y, width, height);
        }
        g.setColor(origColor);
    }

    public void paint(Graphics g, int x, int y, int width, int height) {
        boolean hideClientAck = (this._style & 1L) != 0L;
        MessageStatusIcon.paintStatusIcon(g, this._chatMessage, x, y, width, height, hideClientAck, true, false);
    }
}

