/*
 * Decompiled with CFR 0.152.
 */
package com.whatsapp.client;

import com.whatsapp.api.util.ImageDisplay;
import com.whatsapp.api.util.Utilities;
import com.whatsapp.client.Constants;
import com.whatsapp.client.FunXMPP;
import com.whatsapp.client.MessageStoreProvider;
import java.io.InputStream;
import javax.microedition.io.Connector;
import javax.microedition.io.file.FileConnection;
import javax.microedition.lcdui.Image;

public class MediaData {
    public boolean downloaded;
    public FunXMPP.FMessage fmsg;
    public String filename;
    public String scaledFilename;
    public String mimeType;
    public Image thumbnail;
    public long filenameKey = -1L;
    public int externalThumbCount = 0;
    public static final int IMAGE_MAX_DIMENSION = 800;

    public MediaData(FunXMPP.FMessage wa_message, String origFile, String scaledFile) {
        this.fmsg = wa_message;
        this.setFilename(new String[]{origFile, scaledFile});
        this.downloaded = true;
    }

    public MediaData(FunXMPP.FMessage wa_message, long filenameKey) {
        this(wa_message, filenameKey, -1);
    }

    public MediaData(FunXMPP.FMessage wa_message, long filenameKey, int externalThumbs) {
        this.fmsg = wa_message;
        this.filenameKey = filenameKey;
        this.externalThumbCount = externalThumbs;
        Utilities.logData("unserialized an MD from disk with filename key " + filenameKey + " thumbnail count " + externalThumbs + " for fmsg " + wa_message.key.id);
    }

    public MediaData(FunXMPP.FMessage wa_message) {
        this.fmsg = wa_message;
    }

    public void setFilename(String[] newFilenames) {
        this.downloaded = true;
        this.filename = newFilenames[0];
        this.mimeType = this.getMimeType(MediaData.getExt(this.filename));
        this.scaledFilename = newFilenames[1];
        Utilities.logData("set a filename pair in md: " + this.filename + ";" + this.scaledFilename);
    }

    public void pullFilenames() {
        if (this.filenameKey >= 0L) {
            String[] myFiles = MessageStoreProvider.getMessageStore().getMMSFilenames(this.filenameKey);
            this.setFilename(myFiles);
        } else if (this.fmsg.key.from_me) {
            this.downloaded = true;
        }
    }

    public void inflate() {
        this.pullFilenames();
        this.fmsg.acceptVisitor(new FunXMPP.FMessageVisitor(){

            public void audio(FunXMPP.FMessage fMessage) {
                String iconFilename = MediaData.this.fmsg.key.from_me ? Constants.IMAGE_ICON_AUDIO_OUT_THUMB : Constants.IMAGE_ICON_AUDIO_IN_THUMB;
                try {
                    MediaData.this.thumbnail = Image.createImage((String)iconFilename);
                }
                catch (Exception x) {
                    MediaData.this.thumbnail = Image.createImage((int)80, (int)80);
                }
            }

            public void contact(FunXMPP.FMessage fMessage) {
                MediaData.this.downloaded = true;
                try {
                    MediaData.this.thumbnail = Image.createImage((String)Constants.IMAGE_ICON_VCARD_THUMB);
                }
                catch (Exception x) {
                    MediaData.this.thumbnail = Image.createImage((int)80, (int)80);
                }
            }

            public void image(FunXMPP.FMessage fMessage) {
                MediaData.this.pullExternalThumb();
                if (MediaData.this.thumbnail == null && fMessage.data != null && fMessage.data.length() > 0) {
                    MediaData.this.thumbnail = ImageDisplay.getImageFromThumb(fMessage);
                }
                if (MediaData.this.thumbnail == null) {
                    try {
                        MediaData.this.thumbnail = Image.createImage((String)Constants.IMAGE_ICON_VIDEO_THUMB);
                    }
                    catch (Exception x) {
                        MediaData.this.thumbnail = Image.createImage((int)51, (int)51);
                    }
                }
            }

            public void location(FunXMPP.FMessage fMessage) {
                MediaData.this.downloaded = true;
                if (fMessage.data != null && fMessage.data.length() > 0) {
                    MediaData.this.thumbnail = ImageDisplay.getImageFromThumb(fMessage);
                }
                if (MediaData.this.thumbnail == null) {
                    try {
                        MediaData.this.thumbnail = Image.createImage((String)Constants.IMAGE_ICON_MAP_THUMB);
                    }
                    catch (Exception x) {
                        MediaData.this.thumbnail = Image.createImage((int)80, (int)80);
                    }
                }
            }

            public void undefined(FunXMPP.FMessage fMessage) {
            }

            public void system(FunXMPP.FMessage fMessage) {
            }

            public void video(FunXMPP.FMessage fMessage) {
                if (fMessage.data != null && fMessage.data.length() > 0) {
                    MediaData.this.thumbnail = ImageDisplay.getImageFromThumb(fMessage);
                }
                if (MediaData.this.thumbnail == null) {
                    try {
                        MediaData.this.thumbnail = Image.createImage((String)Constants.IMAGE_ICON_VIDEO_THUMB);
                    }
                    catch (Exception x) {
                        MediaData.this.thumbnail = Image.createImage((int)80, (int)80);
                    }
                }
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean pullExternalThumb() {
        boolean bl;
        FileConnection fileC;
        block20: {
            if (this.externalThumbCount <= 0) {
                return false;
            }
            String thumbFilename = MessageStoreProvider.getMessageStore().getExternalThumbnailFile(this.fmsg.key, this.externalThumbCount);
            fileC = null;
            InputStream is = null;
            try {
                fileC = (FileConnection)Connector.open((String)thumbFilename, (int)1);
                Utilities.logData("thumb file " + thumbFilename + " is size " + fileC.fileSize());
                is = fileC.openInputStream();
                this.thumbnail = Image.createImage((InputStream)is);
                bl = true;
                if (is == null) break block20;
            }
            catch (Throwable t) {
                try {
                    Utilities.logData("blew up pulling thumb for " + this.fmsg.key + ' ' + t.toString());
                    boolean bl2 = false;
                    return bl2;
                }
                catch (Throwable throwable) {
                    throw throwable;
                }
                finally {
                    if (is != null) {
                        try {
                            is.close();
                        }
                        catch (Exception x) {}
                    }
                    if (fileC != null) {
                        try {
                            fileC.close();
                        }
                        catch (Exception x) {}
                    }
                }
            }
            try {
                is.close();
            }
            catch (Exception x) {
                // empty catch block
            }
        }
        if (fileC == null) return bl;
        try {
            fileC.close();
            return bl;
        }
        catch (Exception x) {
            // empty catch block
        }
        return bl;
    }

    protected String getMimeType(String extension) {
        String lowerExt = extension.toLowerCase();
        if (lowerExt.equals(Constants.MEDIA_EXTENSION_JPG)) {
            return Constants.MEDIA_MIME_TYPE_JPEG;
        }
        if (lowerExt.startsWith(Constants.MEDIA_EXTENSION_3GP)) {
            if (this.fmsg.media_wa_type == 2) {
                return Constants.MEDIA_MIME_TYPE_AUDIO_3GPP;
            }
            return Constants.MEDIA_MIME_TYPE_VIDEO_3GPP;
        }
        if (lowerExt.equals(Constants.MEDIA_EXTENSION_AMR)) {
            return Constants.MEDIA_MIME_TYPE_AMR;
        }
        if (lowerExt.equals(Constants.MEDIA_EXTENSION_GIF)) {
            return Constants.MEDIA_MIME_TYPE_GIF;
        }
        if (lowerExt.equals(Constants.MEDIA_EXTENSION_MP3)) {
            return Constants.MEDIA_MIME_TYPE_AUDIO_MPEG;
        }
        if (lowerExt.equals(Constants.MEDIA_EXTENSION_MP4)) {
            return Constants.MEDIA_MIME_TYPE_MP4;
        }
        if (lowerExt.equals(Constants.MEDIA_EXTENSION_PNG)) {
            return Constants.MEDIA_MIME_TYPE_PNG;
        }
        return Constants.MEDIA_MIME_TYPE_OCTET;
    }

    public static String getExt(String filename) {
        int lastDot = filename.lastIndexOf(46);
        if (lastDot == -1) {
            return Constants.STRING_EMPTY_STRING;
        }
        return filename.substring(lastDot + 1);
    }

    public static String rewriteDownloadURL(FunXMPP.FMessage fmsg) {
        if (fmsg == null || fmsg.media_url == null) {
            return null;
        }
        String url = fmsg.media_url;
        if (url.endsWith(Constants.MEDIA_EXTENSION_CAF)) {
            int spos = url.indexOf("whatsapp.net/");
            String result = url.substring(0, spos + 13) + "a.php?i=" + url.substring(spos + 12, url.length() - 3) + Constants.MEDIA_EXTENSION_MP3;
            return result;
        }
        if (fmsg.media_wa_type == 3 && url.toLowerCase().endsWith(Constants.MEDIA_EXTENSION_MOV)) {
            int spos = url.indexOf("whatsapp.net/");
            String result = url.substring(0, spos + 13) + "v.php?i=" + url.substring(spos + 12, url.length() - 3) + Constants.MEDIA_EXTENSION_3GP;
            return result;
        }
        return url;
    }

    public static boolean hasURL(byte wa_type) {
        return wa_type == 1 || wa_type == 2 || wa_type == 3;
    }
}

