/*
 * Decompiled with CFR 0.152.
 */
package com.whatsapp.client;

import com.whatsapp.api.util.S40MD5Digest;
import com.whatsapp.api.util.Utilities;
import com.whatsapp.client.AudioDisplayForm;
import com.whatsapp.client.ChatPane;
import com.whatsapp.client.Constants;
import com.whatsapp.client.FGApp;
import com.whatsapp.client.FunXMPP;
import com.whatsapp.client.MediaData;
import com.whatsapp.client.MessageStore;
import com.whatsapp.client.VideoDisplayForm;
import com.whatsapp.client.test.ContactListMidlet;
import javax.microedition.lcdui.Displayable;
import javax.microedition.lcdui.Image;

public abstract class MMSCreator {
    public MediaData _md;
    public FunXMPP.FMessage _fmsg;
    public ChatPane _parentScr;
    public String _sourceFile;

    public MMSCreator(ChatPane parentScr, String sourceFile) {
        this._parentScr = parentScr;
        this._sourceFile = sourceFile;
    }

    public MediaData getMD() {
        return this._md;
    }

    public abstract void prePreviewProcessFile();

    public abstract void postChoiceProcessFile();

    protected static String getCryptoFilename() {
        String seed = FGApp.getInstance()._myPlainJid + System.currentTimeMillis();
        S40MD5Digest md5 = new S40MD5Digest();
        md5.update(seed.getBytes());
        byte[] rawBytes = md5.digest();
        return new String(Utilities.bytesToHex(rawBytes));
    }

    public static class AudioCreator
    extends MMSCreator {
        public AudioCreator(ChatPane parentScr, String pickerSourceFile) {
            super(parentScr, "file:///" + pickerSourceFile.replace('\\', '/'));
        }

        public void prePreviewProcessFile() {
            this._fmsg = new FunXMPP.FMessage(this._parentScr._jid, Constants.STRING_EMPTY_STRING, null);
            this._md = new MediaData(this._fmsg, this._sourceFile, null);
            FGApp.getInstance().getMessageStore().addMMSFilename(this._sourceFile, null, new MessageStore.MMSKeyStoreCallback(){
                private long _offset;

                public void setOffset(long offset) {
                    Utilities.logData("send of audio got offset " + offset + " for orig file " + AudioCreator.this._sourceFile);
                    this._offset = offset;
                }

                public void operationCompleted() {
                    AudioCreator.this._md.filenameKey = this._offset;
                }
            });
            this._fmsg.thumb_image = this._md;
            this._fmsg.status = 1;
            this._fmsg.media_wa_type = (byte)2;
            this._fmsg.media_name = AudioCreator.getCryptoFilename() + '.' + MediaData.getExt(this._sourceFile);
            AudioDisplayForm vdForm = new AudioDisplayForm((Displayable)this._parentScr, 0L, this._sourceFile, this._md.mimeType, this);
            FGApp.getInstance().setTopPane((Object)vdForm);
            ContactListMidlet.getInstance()._display.setCurrent((Displayable)vdForm);
        }

        public void postChoiceProcessFile() {
            FGApp.getInstance().setMMSState(1);
            try {
                this._md.thumbnail = Image.createImage((String)Constants.IMAGE_ICON_AUDIO_OUT_THUMB);
            }
            catch (Exception x) {
                this._md.thumbnail = Image.createImage((int)51, (int)51);
            }
            this._parentScr.sendNewMMSMessage(this._md);
        }
    }

    public static class VideoCreator
    extends MMSCreator {
        public VideoCreator(ChatPane parentScr, String pickerSourceFile) {
            super(parentScr, "file:///" + pickerSourceFile.replace('\\', '/'));
        }

        public void prePreviewProcessFile() {
            this._fmsg = new FunXMPP.FMessage(this._parentScr._jid, Constants.STRING_EMPTY_STRING, null);
            this._md = new MediaData(this._fmsg, this._sourceFile, null);
            FGApp.getInstance().getMessageStore().addMMSFilename(this._sourceFile, null, new MessageStore.MMSKeyStoreCallback(){
                private long _offset;

                public void setOffset(long offset) {
                    Utilities.logData("send of video got offset " + offset + " for orig file " + VideoCreator.this._sourceFile);
                    this._offset = offset;
                }

                public void operationCompleted() {
                    VideoCreator.this._md.filenameKey = this._offset;
                }
            });
            this._fmsg.thumb_image = this._md;
            this._fmsg.status = 1;
            this._fmsg.media_wa_type = (byte)3;
            this._fmsg.media_name = VideoCreator.getCryptoFilename() + '.' + MediaData.getExt(this._sourceFile);
            VideoDisplayForm vdForm = new VideoDisplayForm((Displayable)this._parentScr, 0L, this._sourceFile, this._md.mimeType, this);
            FGApp.getInstance().setTopPane((Object)vdForm);
            ContactListMidlet.getInstance()._display.setCurrent((Displayable)vdForm);
        }

        public void postChoiceProcessFile() {
            FGApp.getInstance().setMMSState(1);
            try {
                this._md.thumbnail = Image.createImage((String)Constants.IMAGE_ICON_VIDEO_THUMB);
            }
            catch (Exception x) {
                this._md.thumbnail = Image.createImage((int)80, (int)80);
            }
            this._parentScr.sendNewMMSMessage(this._md);
        }
    }

    public static class ImageCreator
    extends MMSCreator {
        public ImageCreator(ChatPane parentScr, String sourceFile) {
            super(parentScr, sourceFile);
        }

        public void prePreviewProcessFile() {
        }

        public void postChoiceProcessFile() {
            FGApp.getInstance().setMMSState(1);
            this._fmsg = new FunXMPP.FMessage(this._parentScr._jid, Constants.STRING_EMPTY_STRING, null);
            this._md = new MediaData(this._fmsg, this._sourceFile, null);
            this._fmsg.thumb_image = this._md;
            this._fmsg.status = 1;
            this._fmsg.media_wa_type = 1;
            this._fmsg.media_name = ImageCreator.getCryptoFilename() + '.' + MediaData.getExt(this._sourceFile);
            try {
                this._md.thumbnail = Image.createImage((String)Constants.IMAGE_ICON_VIDEO_THUMB);
            }
            catch (Exception x) {
                this._md.thumbnail = Image.createImage((int)51, (int)51);
            }
            this._parentScr.sendNewMMSMessage(this._md);
            Utilities.logData("image creator new md, downloaded is " + this._md.downloaded);
        }

        public void gotImageScaleError() {
        }
    }
}

