/*
 * Decompiled with CFR 0.152.
 */
package com.whatsapp.client;

import com.whatsapp.api.contacts.ContactInfoDetails;
import com.whatsapp.api.contacts.ContactPhotoCache;
import com.whatsapp.api.contacts.ContactStatusPIMKey;
import com.whatsapp.api.ui.Command;
import com.whatsapp.api.ui.ListField;
import com.whatsapp.api.util.Utilities;
import com.whatsapp.client.ChatPane;
import com.whatsapp.client.ContactListItem;
import com.whatsapp.client.ContactListPane;
import com.whatsapp.client.EmptyMessageListItem;
import com.whatsapp.client.FGApp;
import com.whatsapp.client.Res;
import com.whatsapp.client.TabState;
import com.whatsapp.client.test.ContactListMidlet;
import java.io.IOException;
import java.util.Vector;
import javax.microedition.lcdui.Alert;
import javax.microedition.lcdui.AlertType;
import javax.microedition.lcdui.Displayable;
import javax.microedition.lcdui.Image;

public class FavsTabState
extends TabState
implements ContactPhotoCache.ChangeListener {
    private Vector _cmdPack = new Vector();
    private Command _sortCmd = new Command(Res.getString(158), Command.SCREEN, 4);
    private Command _reloadCmd = new Command(Res.getString(129), Command.SCREEN, 3);
    private Vector _visibleImages;

    public FavsTabState(ContactListPane parentScr, int index) {
        super(parentScr, index);
        this._cmdPack.addElement(this._sortCmd);
        this._cmdPack.addElement(this._reloadCmd);
    }

    public void onContactPhotoChanged() {
        this._parentScr.tabNeedsRefresh(this, false);
    }

    private Vector filterFavsByName(Vector jidVec) {
        Vector<String> res = new Vector<String>();
        int s = jidVec.size();
        FGApp fgApp = FGApp.getInstance();
        for (int i = 0; i < s; ++i) {
            String curJid = (String)jidVec.elementAt(i);
            String curName = fgApp.getDisplayableNameFromJid(curJid);
            if (!this.subnameCheck(curName)) continue;
            res.addElement(curJid);
        }
        return res;
    }

    public void filterList(String filter, boolean forceRefresh) {
        if (filter == null || filter.length() == 0) {
            this._filteredList = null;
            this._curFilter = null;
        } else {
            String oldFilter = this._curFilter;
            this._curFilter = filter.toLowerCase();
            if (!forceRefresh && oldFilter != null && this._curFilter.startsWith(oldFilter)) {
                this._filteredList = this.filterFavsByName(this._filteredList);
            } else {
                this._curFilter = filter.toLowerCase();
                this._filteredList = this.filterFavsByName(FGApp.getInstance().getFavs().getList());
            }
        }
    }

    public int getNumListItems() {
        if (this._curFilter != null) {
            return this._filteredList.size();
        }
        return FGApp.getInstance().getFavs().size();
    }

    public Vector getListItems(int logicalStart, int numItems) {
        Vector useSortedHistories = this._curFilter == null ? FGApp.getInstance().getFavs().getList() : this._filteredList;
        Vector excerpt = this.safeExcerpt(useSortedHistories, logicalStart, numItems);
        Vector<ListField.Item> items = new Vector<ListField.Item>(numItems);
        Vector<Image> images = new Vector<Image>(numItems);
        FGApp fgApp = FGApp.getInstance();
        ContactPhotoCache.stopAllGetAsync();
        for (int i = 0; i < excerpt.size(); ++i) {
            ContactListItem newItem;
            String curJid = (String)excerpt.elementAt(i);
            ContactStatusPIMKey cspk = fgApp.getStatusPIMKeyFromJid(curJid);
            String name = null;
            String status = null;
            Image photo = null;
            String catLabel = null;
            if (cspk != null) {
                status = cspk._status;
                try {
                    ContactInfoDetails cid = null;
                    if (cspk._pimKey != null) {
                        cid = fgApp.getDetailsFromJid(curJid);
                    }
                    if (cid != null) {
                        int phoneIdx = cspk._pimKey._phoneIndex;
                        if (phoneIdx < cid._phoneCats.length) {
                            catLabel = ContactInfoDetails.getPhoneCategoryLabel(cid._phoneCats[phoneIdx]);
                        }
                        name = cid.getFullName();
                        photo = ContactPhotoCache.getAsync(cid._uid, this);
                    }
                }
                catch (IOException ex) {
                    Utilities.logData("favs/get-items/get-cid/io-error: " + ex);
                }
                if (catLabel == null && cspk._legacyCategory != -1) {
                    catLabel = ContactInfoDetails.getPhoneCategoryLabel(cspk._legacyCategory);
                }
            }
            if (status == null) {
                status = Res.getString(106);
            }
            if (name == null) {
                name = fgApp.getDisplayableNameFromJid(curJid);
            }
            if (photo != null) {
                images.addElement(photo);
                newItem = new ContactListItem(name, status, catLabel, photo);
            } else {
                newItem = new ContactListItem(name, status, catLabel);
            }
            items.addElement(newItem);
        }
        this._visibleImages = images;
        this._masterList = useSortedHistories;
        if (items.isEmpty() && this._curFilter == null) {
            items.addElement(new EmptyMessageListItem(Res.getString(156)));
        }
        return items;
    }

    public String getTabText() {
        FGApp fgApp = FGApp.getInstance();
        int syncState = fgApp.getSyncState();
        if (syncState == 1) {
            return Res.getString(130) + fgApp.getSyncProgress() + '%';
        }
        if (syncState == 2) {
            return Res.getString(131) + fgApp.getSyncProgress() + '%';
        }
        return Res.getString(92);
    }

    public boolean needsHighlight() {
        return FGApp.getInstance().getSyncState() != 0;
    }

    public void selectItem(int index) {
        if (this._masterList == null || index < 0 || index >= this._masterList.size()) {
            Utilities.logData("favs illegal select Item: index " + index + " list " + this._masterList);
            return;
        }
        String curJid = (String)this._masterList.elementAt(index);
        if (curJid.equals(FGApp.getInstance()._myPlainJid)) {
            Alert selfAlert = new Alert(Res.getString(90), Res.getString(183), null, AlertType.ERROR);
            ContactListMidlet.getInstance()._display.setCurrent(selfAlert, (Displayable)this._parentScr);
            return;
        }
        ChatPane cp = new ChatPane(curJid);
        ContactListMidlet.getInstance()._display.setCurrent((Displayable)cp);
    }

    public Vector getCommands() {
        return this._cmdPack;
    }

    public boolean tabCommandHandler(Command cmd) {
        if (cmd == this._sortCmd) {
            Thread t = new Thread(){

                public void run() {
                    FGApp.getInstance().getFavs().sort();
                    FavsTabState.this._parentScr.tabNeedsRefresh(FavsTabState.this, false);
                    FGApp.getInstance().getFavs().saveToDisk();
                }
            };
            t.start();
        } else if (cmd == this._reloadCmd) {
            FGApp.getInstance().refreshContacts();
        } else {
            return false;
        }
        return true;
    }

    public void deleteItem(int index) {
    }
}

