/*
 * Decompiled with CFR 0.152.
 */
package com.whatsapp.client;

import com.whatsapp.api.util.BufferedReader;
import com.whatsapp.api.util.Utilities;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.UnsupportedEncodingException;
import java.util.Vector;

class CountryPhoneInfo {
    public static final int NUMBER_MIN_LENGTH = 5;
    public static final int NUMBER_MAX_LENGTH = 14;
    public static final int CC_MAX_LENGTH = 3;
    private static final String FILENAME = "/countries.tsv";
    private static boolean loaded = false;
    private static String[] names;
    private static Object[] countries;
    static /* synthetic */ Class class$com$whatsapp$client$CountryPhoneInfo;

    CountryPhoneInfo() {
    }

    private static void load() throws IOException {
        String line;
        BufferedReader in;
        if (loaded) {
            return;
        }
        InputStream is = (class$com$whatsapp$client$CountryPhoneInfo == null ? (class$com$whatsapp$client$CountryPhoneInfo = CountryPhoneInfo.class$("com.whatsapp.client.CountryPhoneInfo")) : class$com$whatsapp$client$CountryPhoneInfo).getResourceAsStream(FILENAME);
        if (is == null) {
            throw new IOException("countries/load/countries.tsv/not-found");
        }
        try {
            in = new BufferedReader(new InputStreamReader(is, "UTF-8"));
        }
        catch (UnsupportedEncodingException ex) {
            Utilities.logData("countries/load/unsupported-encoding: UTF-8");
            in = new BufferedReader(new InputStreamReader(is));
        }
        Vector<Country> countries = new Vector<Country>();
        while ((line = in.readLine()) != null) {
            String[] fields = CountryPhoneInfo.splitLine(line, '\t', new String[6]);
            try {
                countries.addElement(new Country(fields));
            }
            catch (NumberFormatException ex) {
                Utilities.logData("countries/load/bad-number: " + line);
            }
            catch (IllegalArgumentException ex) {
                Utilities.logData("countries/load/bad-line: " + line);
            }
        }
        Object[] countriesArray = new Object[countries.size()];
        countries.copyInto(countriesArray);
        String[] names = new String[countriesArray.length];
        for (int i = 0; i < names.length; ++i) {
            names[i] = ((Country)countriesArray[i]).name;
        }
        CountryPhoneInfo.countries = countriesArray;
        CountryPhoneInfo.names = names;
        loaded = true;
    }

    private static int[] splitLineInts(String line, char separator) throws NumberFormatException {
        String[] fields = CountryPhoneInfo.splitLine(line, separator);
        if (fields == null) {
            return null;
        }
        int fieldCount = fields.length;
        int[] intFields = new int[fieldCount];
        for (int i = 0; i < fieldCount; ++i) {
            intFields[i] = Integer.parseInt(fields[i]);
        }
        return intFields;
    }

    private static String[] splitLine(String line, char separator) {
        if (line.length() == 0) {
            return null;
        }
        int start = 0;
        int fieldCount = 1;
        while ((start = line.indexOf(separator, start) + 1) != 0) {
            ++fieldCount;
        }
        return CountryPhoneInfo.splitLine(line, separator, new String[fieldCount]);
    }

    private static String[] splitLine(String line, char separator, String[] fields) {
        if (line.length() == 0) {
            return fields;
        }
        int fieldCount = fields.length;
        int fieldIdx = 0;
        int start = 0;
        while (fieldIdx < fieldCount) {
            int end = line.indexOf(separator, start);
            if (end == -1) {
                fields[fieldIdx] = line.substring(start);
                break;
            }
            fields[fieldIdx++] = line.substring(start, end);
            start = end + 1;
        }
        return fields;
    }

    public static String[] getCountryNames() throws IOException {
        CountryPhoneInfo.load();
        return names;
    }

    public static Country getCountry(int idx) throws IOException {
        CountryPhoneInfo.load();
        return (Country)countries[idx];
    }

    public static int indexOfMcc(int mcc) throws IOException {
        CountryPhoneInfo.load();
        for (int i = 0; i < countries.length; ++i) {
            int[] mccs = ((Country)CountryPhoneInfo.countries[i]).mccs;
            for (int j = 0; j < mccs.length; ++j) {
                if (mccs[j] != mcc) continue;
                return i;
            }
        }
        return -1;
    }

    public static Country parseCCNumber(String ccNumber) throws NumberFormatException, IOException {
        CountryPhoneInfo.load();
        for (int i = 0; i < countries.length; ++i) {
            Country country = (Country)countries[i];
            String ccString = '+' + Integer.toString(country.cc);
            if (ccNumber.length() < ccString.length() || !ccString.equals(ccNumber.substring(0, ccString.length()))) continue;
            return country;
        }
        throw new NumberFormatException();
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    public static class Country {
        public static final int FIELD_COUNT = 6;
        public final String name;
        public final int cc;
        public final int[] mccs;
        public final int[] lengths;
        public final boolean allowsZeroes;
        public final int maxLength;

        private Country(String[] fields) throws NumberFormatException, IllegalArgumentException {
            if (fields.length < 6) {
                throw new IllegalArgumentException();
            }
            String iso = fields[0];
            String name = fields[1];
            String cc = fields[2];
            String mccs = fields[3];
            String lengths = fields[4];
            String allowsZeroes = fields[5];
            if (name == null || cc == null) {
                throw new IllegalArgumentException();
            }
            this.name = name + ' ' + '(' + '+' + cc + ')';
            this.cc = Integer.parseInt(cc);
            this.mccs = mccs != null && mccs.trim().length() > 0 ? CountryPhoneInfo.splitLineInts(mccs, ',') : new int[0];
            if (lengths != null && lengths.trim().length() > 0) {
                this.lengths = CountryPhoneInfo.splitLineInts(lengths, ',');
                int maxLength = this.lengths[0];
                for (int i = 1; i < this.lengths.length; ++i) {
                    int length = this.lengths[i];
                    if (length <= maxLength) continue;
                    maxLength = length;
                }
                this.maxLength = maxLength;
            } else {
                this.lengths = new int[0];
                this.maxLength = 14;
            }
            this.allowsZeroes = allowsZeroes != null && allowsZeroes.equals("true");
        }

        public boolean checkNumberLength(String number) {
            int length = this.trimForSMS(number).length();
            if (this.lengths.length == 0) {
                return length >= 5 && length <= 14;
            }
            for (int j = 0; j < this.lengths.length; ++j) {
                if (this.lengths[j] != length) continue;
                return true;
            }
            return false;
        }

        public int getMaxNumberLength(String number) {
            String trimmed = this.trimForSMS(number);
            return this.maxLength + number.length() - trimmed.length();
        }

        public String trimForSMS(String phone) {
            int i;
            if (this.allowsZeroes) {
                return phone;
            }
            int length = phone.length();
            for (i = 0; i < length && phone.charAt(i) == '0'; ++i) {
            }
            return phone.substring(i);
        }
    }
}

