/*
 * Decompiled with CFR 0.152.
 */
package com.whatsapp.client;

import com.whatsapp.api.ui.Command;
import com.whatsapp.api.ui.FieldManager;
import com.whatsapp.api.ui.InputEditorField;
import com.whatsapp.api.ui.ListField;
import com.whatsapp.api.ui.SpinnerDialog;
import com.whatsapp.api.ui.UIField;
import com.whatsapp.api.util.Utilities;
import com.whatsapp.client.AboutForm;
import com.whatsapp.client.AllContactsTabState;
import com.whatsapp.client.CanvasScreen;
import com.whatsapp.client.ChatState;
import com.whatsapp.client.ChatsTabState;
import com.whatsapp.client.Constants;
import com.whatsapp.client.FGApp;
import com.whatsapp.client.FavsTabState;
import com.whatsapp.client.FunXMPP;
import com.whatsapp.client.MessageStore;
import com.whatsapp.client.Res;
import com.whatsapp.client.SettingsList;
import com.whatsapp.client.StatusForm;
import com.whatsapp.client.TabRow;
import com.whatsapp.client.TabState;
import com.whatsapp.client.test.ContactListMidlet;
import java.util.Vector;
import javax.microedition.lcdui.Alert;
import javax.microedition.lcdui.AlertType;
import javax.microedition.lcdui.Display;
import javax.microedition.lcdui.Displayable;
import javax.microedition.lcdui.Graphics;
import javax.microedition.rms.RecordStoreException;

public class ContactListPane
extends CanvasScreen
implements Command.Listener,
ListField.Container,
MessageStore.Listener,
ChatState.Listener {
    private final TabRow _tabRow;
    private final InputEditorField _inputEditor = new InputEditorField(this, null, 32, 524288, -1, 1, 1);
    private static final int FAVS_TAB_IDX = 0;
    private static final int CHATS_TAB_IDX = 1;
    private static final int ALL_CONTACTS_TAB_IDX = 2;
    private TabState _activeTab;
    private int _activeTabIdx = -1;
    public final ChatsTabState _chatsTab = new ChatsTabState(this, 1);
    public final FavsTabState _favsTab = new FavsTabState(this, 0);
    public final AllContactsTabState _allContactsTab = new AllContactsTabState(this, 2);
    public final TabState[] _tabs = new TabState[]{this._favsTab, this._chatsTab, this._allContactsTab};
    public boolean _filterShowing = false;
    Command _openItemCmd = new Command(Res.getString(144), Command.ITEM, 1);
    Command _deleteItemCmd = new Command(Res.getString(78), Command.ITEM, 0);
    Command _settingsCmd = new Command(Res.getString(154), Command.SCREEN, 2);
    Command _aboutCmd = new Command(Res.getString(53), Command.SCREEN, 1);
    Command _statusCmd = new Command(Res.getString(160), Command.SCREEN, 0);
    Command _hideCmd = new Command(Res.getString(91), Command.EXIT, 0);
    private Vector _tabCommandPack;
    private final ListField _clFld = new ListField(this);
    private boolean _loading;
    private SpinnerDialog _loadingDialog;

    public ContactListPane(boolean visibleAtStart, boolean launchContacts) {
        super(0xFFFFFF);
        this.addCommand(this._openItemCmd);
        this.addCommand(this._settingsCmd);
        this.addCommand(this._aboutCmd);
        this.addCommand(this._statusCmd);
        this.addCommand(this._hideCmd);
        if (launchContacts) {
            this._activeTab = this._favsTab;
            this._activeTabIdx = 0;
        } else {
            this._activeTab = this._chatsTab;
            this._activeTabIdx = 1;
        }
        String[] tabNames = new String[this._tabs.length];
        for (int i = 0; i < this._tabs.length; ++i) {
            tabNames[i] = this._tabs[i].getTabText();
        }
        this._tabRow = new TabRow(tabNames, this._activeTabIdx, false, true);
        this.updateItemCommands();
        this.addActiveTabCommands();
        if (visibleAtStart && !launchContacts) {
            this._loading = true;
            this._loadingDialog = new SpinnerDialog(this, Res.getString(104), true);
        } else {
            this._loading = false;
        }
        this._inputEditor.setListener(this);
        FieldManager vfm = new FieldManager(1L, true){

            public void setFocus(boolean focus) {
                ContactListPane.this._tabRow.setFocus(focus);
                super.setFocus(focus);
            }
        };
        vfm.add(this._tabRow);
        vfm.add(this._clFld);
        this.addField(vfm);
        if (this._loadingDialog != null) {
            this.addOverlay(this._loadingDialog);
        }
        this.traverse(6);
        this.sizeChanged(this.getWidth(), this.getHeight());
        if (this._loading) {
            this._loadingDialog.start();
        }
        FGApp.getInstance().setMainScreen(this);
    }

    public int getHeightForList() {
        return -1;
    }

    public int getRowHeight() {
        return this._activeTab.getRowHeight();
    }

    public int getNumListItems() {
        if (this._activeTab.isTrulyEmpty()) {
            return 1;
        }
        return this._activeTab.getNumListItems();
    }

    public boolean shouldListKeepFocus(int direction) {
        if (direction == 6) {
            return !this._filterShowing;
        }
        return true;
    }

    public Vector getListItems(int logicalStart, int numItems) {
        return this._activeTab.getListItems(logicalStart, numItems);
    }

    public void showFilter(int keyCode) {
        if (keyCode > 0 && this._inputEditor.editor.size() < this._inputEditor.editor.getMaxSize()) {
            this._inputEditor.editor.insert(String.valueOf((char)keyCode), this._inputEditor.editor.size());
            this.inputAction(this._inputEditor, 1);
        }
        if (!this._filterShowing) {
            this.insertFieldAt(this._inputEditor, 0);
            this._filterShowing = true;
        }
        this.moveFocus(this._inputEditor);
    }

    public void hideFilter() {
        this.traverse(1);
        this.removeField(this._inputEditor);
        this._inputEditor.editor.setContent(Constants.STRING_EMPTY_STRING);
        this._activeTab.filterList(null);
        this._filterShowing = false;
        this._clFld.jumpToTop();
    }

    public void inputAction(InputEditorField inputEditor, int actions) {
        if ((actions & 1) != 0) {
            if (this._inputEditor.editor.size() == 0) {
                this.hideFilter();
                this.doRepaint();
            } else {
                this._activeTab.filterList(this._inputEditor.editor.getContent());
                this._clFld.jumpToTop();
            }
            this.updateItemCommands();
        }
        super.inputAction(inputEditor, actions);
    }

    public boolean commandAction(Command cmd, UIField field) {
        if (cmd == this._openItemCmd) {
            this._activeTab.selectItem(this.getSelectedIndex());
        } else if (cmd == this._deleteItemCmd) {
            this._activeTab.deleteItem(this.getSelectedIndex());
        } else if (cmd == this._settingsCmd) {
            Display d = ContactListMidlet.getInstance()._display;
            try {
                SettingsList settingsLst = new SettingsList((Displayable)this, d);
                d.setCurrent((Displayable)settingsLst);
                FGApp.getInstance().setTopPane(settingsLst);
            }
            catch (RecordStoreException rmsx) {
                Alert a = new Alert(Res.getString(90), Res.getString(57), null, AlertType.ERROR);
                d.setCurrent(a, (Displayable)this);
            }
        } else if (cmd == this._aboutCmd) {
            Display d = ContactListMidlet.getInstance()._display;
            AboutForm aF = new AboutForm();
            d.setCurrent((Displayable)aF);
            FGApp.getInstance().setTopPane(aF);
        } else if (cmd == this._statusCmd) {
            Display d = ContactListMidlet.getInstance()._display;
            StatusForm sF = new StatusForm();
            d.setCurrent((Displayable)sF);
            FGApp.getInstance().setTopPane((Object)sF);
        } else if (cmd == this._hideCmd) {
            Utilities.syncLogData("fg app user quit");
            ContactListMidlet.getInstance().notifyDestroyed();
        } else if (!this._activeTab.tabCommandHandler(cmd)) {
            return super.commandAction(cmd, field);
        }
        return true;
    }

    public void tabNeedsRefresh(TabState requester, boolean repaintTabs) {
        boolean needsRepaint = false;
        if (requester == this._activeTab) {
            if (this._filterShowing) {
                this._activeTab.filterList(this._inputEditor.editor.getContent(), true);
            }
            this.updateItemCommands();
            needsRepaint = true;
        }
        if (repaintTabs) {
            this._tabRow.setName(requester.getIndex(), requester.getTabText());
            this._tabRow.setHighlight(requester.getIndex(), requester.needsHighlight());
            needsRepaint = true;
        }
        if (needsRepaint) {
            this.doRepaint();
        }
    }

    public void initialChatsLoadComplete() {
        this.stopLoading();
        if (this._activeTab != this._favsTab && FGApp.getInstance().getChatHistoryCache().size() == 0) {
            this._tabRow.setCenter(0);
            this.setActiveTab(0);
        } else {
            this.tabNeedsRefresh(this._chatsTab, true);
        }
    }

    public void messageReceipt(FunXMPP.FMessage.Key msgKey, int status) {
        this.tabNeedsRefresh(this._chatsTab, false);
    }

    public void chatHistoryDeleted(String jid) {
        this.tabNeedsRefresh(this._chatsTab, false);
    }

    public void groupChatMetadataUpdate(String gjid) {
        this.tabNeedsRefresh(this._chatsTab, false);
    }

    public void newFullMessage(FunXMPP.FMessage fmsg) {
        this.tabNeedsRefresh(this._chatsTab, true);
    }

    public void newSkeletalMessage(FunXMPP.FMessage fmsg) {
        this.newFullMessage(fmsg);
    }

    public void newChatState(int newState) {
    }

    public void newContactChatState(String jid, int newState, long timestamp) {
        if ((newState == 0 || newState == 1) && this._activeTab == this._chatsTab) {
            this.doRepaint();
        }
    }

    private synchronized void addActiveTabCommands() {
        if (this._tabCommandPack != null) {
            return;
        }
        this._tabCommandPack = this._activeTab.getCommands();
        for (int i = 0; i < this._tabCommandPack.size(); ++i) {
            Command curCmd = (Command)this._tabCommandPack.elementAt(i);
            this.addCommand(curCmd);
        }
    }

    private synchronized void removeTabCommands() {
        if (this._tabCommandPack != null) {
            for (int i = 0; i < this._tabCommandPack.size(); ++i) {
                Command curCmd = (Command)this._tabCommandPack.elementAt(i);
                this.removeCommand(curCmd);
            }
        }
        this._tabCommandPack = null;
    }

    public int getSelectedIndex() {
        return this._clFld.getFocusedLogicalRow();
    }

    public void setActiveTab(int tabIdx) {
        if (tabIdx == this._activeTabIdx) {
            return;
        }
        this._activeTabIdx = tabIdx;
        this._activeTab = this._tabs[tabIdx];
        this.hideFilter();
        this._clFld.jumpToTop();
        this.updateItemCommands();
        this.removeTabCommands();
        this.addActiveTabCommands();
        this.doRepaint();
    }

    public TabState getActiveTab() {
        return this._activeTab;
    }

    private void addDeleteCommand() {
        if (this._activeTab == this._chatsTab) {
            this.addCommand(this._deleteItemCmd);
        } else {
            this.removeCommand(this._deleteItemCmd);
        }
    }

    protected void paint(Graphics g) {
        this._inputEditor.setVisible(this._filterShowing);
        super.paint(g);
    }

    protected boolean handleKeyPressed(int keyCode) {
        if (this._loading) {
            return true;
        }
        if (keyCode == -2 || keyCode == -1) {
            FGApp.getInstance().requestNotificationState(false);
        }
        if (super.handleKeyPressed(keyCode)) {
            return true;
        }
        if (keyCode == 32) {
            this._clFld.pageMove(1);
            this.doRepaint();
            return true;
        }
        if (keyCode == 8) {
            this.getActiveTab().deleteItem(this.getSelectedIndex());
            return true;
        }
        if (keyCode == -55 || keyCode == -50) {
            this._clFld.jumpToTop();
            this.doRepaint();
            return true;
        }
        if (keyCode > 10) {
            this.showFilter(keyCode);
            this.doRepaint();
            return true;
        }
        if (keyCode == -3) {
            this.setActiveTab(this._tabRow.adjustCenter(-1));
            return true;
        }
        if (keyCode == -4) {
            this.setActiveTab(this._tabRow.adjustCenter(1));
            return true;
        }
        return false;
    }

    protected void onFocusChanged() {
        if (this._loading) {
            return;
        }
        this.updateItemCommands();
        if (this._cmdBar.hasFocus()) {
            this._inputEditor.pauseFocus();
        } else {
            this._inputEditor.resumeFocus();
        }
        this.doRepaint();
    }

    protected void showNotify() {
        FGApp.getInstance().requestNotificationState(false);
    }

    public void stopLoading() {
        if (this._loading) {
            this._loading = false;
            this._loadingDialog.stop();
            this.removeOverlay(this._loadingDialog);
            this._loadingDialog = null;
        }
    }

    private void updateItemCommands() {
        if (this._cmdBar.hasFocus()) {
            return;
        }
        if (this._clFld.hasFocus() && !this._activeTab.isTrulyEmpty() || this._inputEditor.hasFocus() && this._activeTab.getNumListItems() == 1) {
            this._openItemCmd.setEnabled(true);
            this.addDeleteCommand();
        } else {
            this._openItemCmd.setEnabled(false);
            this.removeCommand(this._deleteItemCmd);
        }
    }
}

