/*
 * Decompiled with CFR 0.152.
 */
package com.whatsapp.client;

import com.whatsapp.api.ui.ListField;
import com.whatsapp.api.ui.Rect;
import com.whatsapp.api.ui.TextUtils;
import com.whatsapp.api.util.Utilities;
import com.whatsapp.client.ChatHistory;
import com.whatsapp.client.ChatsListItem;
import com.whatsapp.client.Constants;
import com.whatsapp.client.TabState;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;

public class ContactListItem
implements ListField.Item {
    protected static final int ROW_HEIGHT = 44;
    public static final Image defaultContactImg = ContactListItem.initImageFromResource(Constants.IMAGE_ICON_DEFAULT_CONTACT);
    public static final Image defaultGroupImg = ContactListItem.initImageFromResource(Constants.IMAGE_ICON_GROUP_CONTACT);
    public String _name;
    public String _status;
    public String _catLabel;
    public Image _image;
    public ChatHistory _hist;

    private static Image initImageFromResource(String name) {
        Image res;
        try {
            res = Image.createImage((String)name);
        }
        catch (Exception x) {
            Utilities.logData("failure initializing image: " + name);
            res = Image.createImage((int)44, (int)44);
        }
        return res;
    }

    public ContactListItem(String name, String status, String catLabel) {
        this(name, status, catLabel, defaultContactImg);
    }

    public ContactListItem(String name, String status, String catLabel, Image image) {
        this._name = name;
        this._status = status;
        this._catLabel = catLabel;
        this._image = image;
    }

    public void paintListRow(Graphics g, int x, int y, int width, int height, boolean focused) {
        int imageWidth;
        int foregroundCol;
        Rect clip = new Rect(g.getClipX(), g.getClipY(), g.getClipWidth(), g.getClipHeight());
        g.clipRect(x, y, width, height);
        if (focused) {
            foregroundCol = 0xFFFFFF;
            TabState.paintFocusedBackground(g, x, y, width, height);
        } else {
            foregroundCol = 0;
        }
        if (this._image != null) {
            g.drawImage(this._image, x, y, 0);
            imageWidth = 44;
        } else {
            imageWidth = 5;
        }
        g.setFont(ChatsListItem.normalFont);
        int labelWidth = 2;
        if (this._catLabel != null) {
            if (!focused) {
                g.setColor(6591981);
            } else {
                g.setColor(foregroundCol);
            }
            labelWidth = g.getFont().stringWidth(this._catLabel) + 2;
            g.drawString(this._catLabel, x + width - labelWidth, y, 20);
        }
        int nameX = x + imageWidth;
        int nameY = y + (this._status == null ? height / 2 - ChatsListItem.normalFont.getHeight() / 2 : 0);
        int nameWidth = width - (imageWidth + labelWidth + 5);
        g.setClip(clip.x, clip.y, clip.width, clip.height);
        g.clipRect(nameX, nameY, nameWidth, height);
        g.setColor(foregroundCol);
        TextUtils.drawStringElided(g, this._name, nameX, nameY, nameWidth);
        g.setClip(clip.x, clip.y, clip.width, clip.height);
        g.clipRect(x, y, width - 1, height);
        if (this._status != null) {
            if (!focused) {
                g.setColor(0x4D4D4D);
            }
            int statusX = x + imageWidth;
            int statusY = y + 22;
            int statusWidth = width - (imageWidth + 1);
            TextUtils.drawStringElided(g, this._status, statusX, statusY, statusWidth);
        }
        g.setClip(clip.x, clip.y, clip.width, clip.height);
        g.clipRect(x, y, width, height);
        g.setColor(0x808080);
        g.drawLine(x, y + 44 - 1, x + width, y + 44 - 1);
        g.setClip(clip.x, clip.y, clip.width, clip.height);
    }
}

