/*
 * Decompiled with CFR 0.152.
 */
package com.whatsapp.client;

import com.whatsapp.api.util.AppManager;
import com.whatsapp.api.util.DateTimeUtilities;
import com.whatsapp.api.util.SafeThread;
import com.whatsapp.api.util.Utilities;
import com.whatsapp.client.BGApp;
import com.whatsapp.client.Constants;
import com.whatsapp.client.FunXMPP;
import com.whatsapp.client.FunXMPPRunner;
import com.whatsapp.client.UsageStats;
import java.util.Random;
import java.util.Timer;
import java.util.TimerTask;

public class ChatState {
    int _state = 3;
    long _timeChanged = System.currentTimeMillis();
    long _lastUserWakeup = 0L;
    final Object _connectLock = new Object();
    final Object _inflightLock = new Object();
    int _inflightRecons = 0;
    int _startupTaskState = 0;
    int _consecFails = 0;
    int _totalDrops = 0;
    final int[] _retryIntvls = new int[]{1, 2, 3, 5, 8, 13, 21, 34, 55, 89, 144, 233, 377, 610, 987, 1597, 2584};
    int _xmpp_account_kind = -1;
    long _xmpp_expire_date = 0L;
    long _mms_total_bytes;
    long _mms_total_seconds;
    long _last_disconnect = -1L;
    int _last_login_trigger = -1;
    boolean _didOneOfflineAlert = false;
    UsageStats _usageStats;
    Timer _timer = new Timer();
    public static final int TRIGGER_APP_START = 0;
    public static final int TRIGGER_COVERAGE = 1;
    public static final int TRIGGER_USER_ACTIVITY = 2;
    public static final int TRIGGER_INCOMING_PUSH = 3;
    public static final int TRIGGER_AUTO_POLL = 4;
    public static final int TRIGGER_PUSH_SETTINGS_CHANGED = 5;
    public static final int TRIGGER_RECONNECT = 6;
    public static final int TRIGGER_REREGISTERED = 7;
    private static ChatState _instance;

    public static ChatState initialize() {
        ChatState curState = new ChatState();
        curState._usageStats = new UsageStats();
        _instance = curState;
        SentinelTask.reschedule(curState, SentinelTask.MAX_SILENT_INTERVAL);
        curState._timer.schedule((TimerTask)new PeriodicSyncer(), 1200000L, 86460000L);
        return curState;
    }

    public static ChatState getState() {
        return _instance;
    }

    public void setState(int new_state) {
        Utilities.logData("ChatState change " + Constants.STATE_WORDS[this._state] + Constants.STRING_ARROW + Constants.STATE_WORDS[new_state]);
        long now = System.currentTimeMillis();
        if (this._state == 0 && new_state == 3) {
            Utilities.logData("was connected for: " + DateTimeUtilities.readableElapsedTime(now - this._timeChanged));
            KeepAliveTask.disconnect(now - this._timeChanged);
            this._last_disconnect = now;
        }
        this._state = new_state;
        this._timeChanged = now;
        if (new_state == 0) {
            this._consecFails = 0;
            KeepAliveTask.kickoff(this);
            this._didOneOfflineAlert = false;
            if (this._last_disconnect > 0L) {
                Utilities.logData("was disconnected for: " + DateTimeUtilities.readableElapsedTime(now - this._last_disconnect));
            } else {
                Utilities.logData("first connect");
            }
        }
        BGApp.getInstance().sendToFG(new byte[]{(byte)new_state}, (byte)2);
    }

    public void userTypingWakeup() {
        if (System.currentTimeMillis() - this._lastUserWakeup > 60000L) {
            this._lastUserWakeup = System.currentTimeMillis();
            this.doConnect(2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean doConnect(int trigger) {
        if (AppManager.isForeground()) {
            Utilities.logData("APP error... trying to wake up chatstate in FG");
            return true;
        }
        if (this._state == 4 && trigger != 7) {
            Utilities.logData("password is bad, discarding trigger " + trigger);
            return true;
        }
        Object object = this._connectLock;
        synchronized (object) {
            if (this._state == 3 || this._state == 4) {
                Utilities.logData("got lock, with trigger " + trigger + " connecting to chat [" + this._totalDrops + " total drops]");
                this._last_login_trigger = trigger;
                BGApp.getInstance()._xmppRunner.wakeUp();
                ++this._totalDrops;
                return true;
            }
            Utilities.logData("doConnect bailing on non-disconnected state " + Constants.STATE_WORDS[this._state]);
        }
        return false;
    }

    private int chooseRetryMins() {
        int numChoices = this._retryIntvls.length;
        if (this._consecFails > numChoices - 1) {
            return this._retryIntvls[numChoices - 1];
        }
        return this._retryIntvls[this._consecFails];
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void processFail() {
        Utilities.logData("entering processFail with state " + Constants.STATE_WORDS[this._state] + " and inflights " + this._inflightRecons);
        Object object = this._inflightLock;
        synchronized (object) {
            if (this._inflightRecons > 0) {
                Utilities.logData("ProcessFail finds inflight already, no new task.");
                return;
            }
            ++this._inflightRecons;
        }
        int mins = this.chooseRetryMins();
        ++this._consecFails;
        if (this._consecFails > this._retryIntvls.length && this._xmpp_expire_date < System.currentTimeMillis()) {
            Utilities.logData("expired and at the end of all intervals... not scheduling another delayed connect");
            return;
        }
        Random rnd = new Random();
        int jitter = rnd.nextInt(10000);
        Utilities.logData("ProcessFail after consec fail " + this._consecFails + ", launching timed chat connector with delay " + mins + " mins + " + jitter + " millis of jitter");
        this._timer.schedule((TimerTask)new ReconnectTask(this), 60000L * (long)mins + (long)jitter);
    }

    public static boolean isStartupComplete() {
        ChatState cs = ChatState.getState();
        if (cs == null) {
            return false;
        }
        int startupBits = 33;
        return (cs._startupTaskState & 0x21) == 33;
    }

    static class PeriodicSyncer
    extends TimerTask {
        PeriodicSyncer() {
        }

        public void run() {
            try {
                BGApp.getInstance().periodicSystemColdSync();
            }
            catch (Throwable t) {
                Utilities.logData("periodic syncer blowup: " + t.toString());
            }
        }
    }

    static class KeepAliveTask
    extends TimerTask {
        private ChatState _cs;
        private static KeepAliveTask _curTask;
        private static long _nextInterval;
        public static long MIN_INTERVAL;

        public static void disconnect(long connectedInterval) {
            long tentativeInt;
            if (_curTask != null) {
                _curTask.cancel();
                _curTask = null;
            }
            if ((tentativeInt = connectedInterval - 60000L) < MIN_INTERVAL) {
                _nextInterval = MIN_INTERVAL;
            } else if (connectedInterval <= SentinelTask.MAX_SILENT_INTERVAL) {
                _nextInterval = tentativeInt;
            }
        }

        public static void kickoff(ChatState cs) {
            if (_nextInterval > 0L) {
                _curTask = new KeepAliveTask(cs);
                cs._timer.schedule((TimerTask)_curTask, _nextInterval, _nextInterval);
                Utilities.logData("recurring keepalive kicked off with interval " + DateTimeUtilities.readableElapsedTime(_nextInterval));
            }
        }

        public KeepAliveTask(ChatState cs) {
            this._cs = cs;
        }

        public void run() {
            try {
                if (this._cs._state == 0) {
                    Utilities.logData("sending keepalive NOP with interval " + DateTimeUtilities.readableElapsedTime(_nextInterval));
                    SafeThread t = new SafeThread(){

                        public void safeRun() {
                            BGApp.getInstance().sendXMPPPing(false);
                        }
                    };
                    t.start();
                }
            }
            catch (Throwable t) {
                Utilities.logData("blowup in keepalive nop: " + t.toString());
            }
        }

        static {
            _nextInterval = -1L;
            MIN_INTERVAL = 120000L;
        }
    }

    static class SentinelTask
    extends TimerTask {
        public static long MAX_SILENT_INTERVAL = 1320000L;
        ChatState _cs;

        public SentinelTask(ChatState cs) {
            this._cs = cs;
        }

        public static void reschedule(ChatState cs, long wakeup) {
            cs._timer.schedule((TimerTask)new SentinelTask(cs), wakeup);
            Utilities.logData("new SentinelTask scheduled for wakeup mins from now: " + wakeup / 60000L);
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public void run() {
            try {
                FunXMPPRunner xmppRunner = BGApp.getInstance()._xmppRunner;
                FunXMPP.Connection fConn = xmppRunner._connection;
                if (this._cs._state == 0) {
                    if (fConn != null) {
                        long quietInterval = System.currentTimeMillis() - fConn.lastTreeRead;
                        if (quietInterval <= MAX_SILENT_INTERVAL) {
                            SentinelTask.reschedule(this._cs, MAX_SILENT_INTERVAL - quietInterval);
                            return;
                        }
                        Utilities.logData("sending ping after quiet on xmpp conn for 1QI mins " + quietInterval / 60000L);
                        Thread t = new Thread(){

                            public void run() {
                                BGApp.getInstance().sendXMPPPing(true);
                            }
                        };
                        t.start();
                    } else {
                        Utilities.logData("sentinel sees null fun conn in connected state");
                    }
                } else if (this._cs._state == 1) {
                    long curStateHeld = (System.currentTimeMillis() - this._cs._timeChanged) / 1000L;
                    Utilities.logData("LOCKED? sentinel sees SOCKETING_CONNECTING held for seconds: " + curStateHeld);
                } else if (this._cs._state == 2) {
                    long curStateHeld = (System.currentTimeMillis() - this._cs._timeChanged) / 1000L;
                    Utilities.logData("LOCKED? sentinel sees XMPP_CONNECTING held for seconds: " + curStateHeld);
                } else if (this._cs._state == 3) {
                    Utilities.logData("sentinel sees DISCONNECTED, inflight recons: " + this._cs._inflightRecons);
                } else {
                    if (this._cs._state == 4) {
                        Utilities.logData("sentinel sees PASSWD_FAIL, no more sentinel");
                        return;
                    }
                    Utilities.logData("sentinel sees unknown chat state " + this._cs._state);
                }
                SentinelTask.reschedule(this._cs, MAX_SILENT_INTERVAL);
                return;
            }
            catch (Throwable t) {
                Utilities.logData("SentinelTask blowup: " + t.toString());
            }
        }
    }

    class ReconnectTask
    extends TimerTask {
        ChatState _cs;

        public ReconnectTask(ChatState cs) {
            this._cs = cs;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            try {
                Object object = this._cs._inflightLock;
                synchronized (object) {
                    if (this._cs._inflightRecons > 0) {
                        --this._cs._inflightRecons;
                    }
                }
                if (this._cs._state == 3) {
                    Utilities.logData("ReconnectTask woke up and is trying to connect");
                    boolean res = this._cs.doConnect(6);
                    if (!res && this._cs._state == 3) {
                        this._cs.processFail();
                    }
                } else {
                    Utilities.logData("ReconnectTask woke up but it looks like we're already connected or connecting.");
                }
            }
            catch (Throwable t) {
                Utilities.logData("ReconnectTask blowup: " + t.toString());
            }
        }
    }

    public static interface Listener {
        public void newChatState(int var1);

        public void newContactChatState(String var1, int var2, long var3);
    }
}

