/*
 * Decompiled with CFR 0.152.
 */
package com.whatsapp.client;

import com.whatsapp.api.ui.FieldManager;
import com.whatsapp.client.ChatLine;
import com.whatsapp.client.ChatsListItem;
import com.whatsapp.client.ShadedLabelField;
import javax.microedition.lcdui.Graphics;

public class ChatGroupBubble
extends FieldManager {
    public static final long TAIL_LEFT = 1L;
    public static final long TAIL_RIGHT = 2L;
    public static final long NO_BORDER = 4L;
    public static final int FROM_US_COLOR = 0xFFFFFF;
    public static final int FROM_THEM_COLOR = 0xCCCCFF;
    public static final int TAIL_WIDTH = 8;
    public static final int TAIL_HEIGHT = 8;
    public static final int TAIL_VPOS = 6;
    private ShadedLabelField _header;
    private int _headerCount;
    private long _style;
    private int _backgroundColor;

    public ChatGroupBubble(long style) {
        super(4L, true);
        this._style = style;
        boolean tailLeft = (this._style & 1L) != 0L;
        boolean tailRight = (this._style & 2L) != 0L;
        this.setPadding(1, (tailRight ? 8 : 1) + 1, 1, (tailLeft ? 8 : 0) + 1);
        this._backgroundColor = tailRight ? 0xFFFFFF : 0xCCCCFF;
        this._headerCount = 0;
    }

    public ChatGroupBubble(String titleText, long style) {
        this(style);
        this._header = new ShadedLabelField(titleText, ChatsListItem.smallFont);
        this.add(this._header);
        this._headerCount = 1;
    }

    public void setText(String s) {
        if (this._header != null) {
            this._header.setText(s);
        }
    }

    public void setBackgroundColor(int c) {
        this._backgroundColor = c;
    }

    public void appendChatLine(ChatLine chatLine) {
        this.add(chatLine);
    }

    public void prependChatLine(ChatLine chatLine) {
        this.insertAt(chatLine, this._headerCount);
    }

    public ChatLine firstChatline() {
        if (this.getNumChildren() > this._headerCount) {
            return (ChatLine)this.getChildAt(this._headerCount);
        }
        return null;
    }

    public int getHeaderHeight() {
        if (this._header != null) {
            return this._header.getHeight() + 2;
        }
        return 0;
    }

    public void paint(Graphics g, int x, int y, int width, int height) {
        boolean noBorder;
        boolean tailLeft = (this._style & 1L) != 0L;
        boolean tailRight = (this._style & 2L) != 0L;
        boolean bl = noBorder = (this._style & 4L) != 0L;
        if (!noBorder) {
            int[] yPts;
            int[] xPts;
            g.setColor(0);
            int borderXLeft = x + (tailLeft ? 8 : 0);
            int roundedRectWidth = this.getWidth() - (tailLeft ? 9 : 1) - (tailRight ? 9 : 1);
            g.setColor(this._backgroundColor);
            g.fillRect(borderXLeft, y, roundedRectWidth, this.getHeight());
            g.setColor(0);
            g.drawRect(borderXLeft, y, roundedRectWidth, this.getHeight() - 1);
            if (tailRight) {
                g.setColor(this._backgroundColor);
                xPts = new int[]{x + this.getWidth() - 8 - 1, x + this.getWidth() - 1, x + this.getWidth() - 8 - 1};
                yPts = new int[]{y + this.getHeight() - 14, y + this.getHeight() - 6, y + this.getHeight() - 6};
                g.fillTriangle(xPts[0], yPts[0], xPts[1], yPts[1], xPts[2], yPts[2]);
                g.drawLine(xPts[0] - 1, yPts[0], xPts[2] - 1, yPts[2] - 1);
                g.setColor(0);
                g.drawLine(xPts[0], yPts[0], xPts[1], yPts[1]);
                g.drawLine(xPts[1], yPts[1], xPts[2], yPts[2]);
            }
            if (tailLeft) {
                g.setColor(this._backgroundColor);
                xPts = new int[]{x + 8, x, x + 8};
                yPts = new int[]{y + this.getHeight() - 14, y + this.getHeight() - 6, y + this.getHeight() - 6};
                g.fillTriangle(xPts[0], yPts[0], xPts[1], yPts[1], xPts[2], yPts[2]);
                g.drawLine(xPts[0], yPts[0], xPts[2], yPts[2]);
                g.setColor(0);
                g.drawLine(xPts[0], yPts[0], xPts[1], yPts[1]);
                g.drawLine(xPts[1], yPts[1], xPts[2], yPts[2]);
            }
        }
        super.paint(g, x, y, width, height);
    }
}

