/*
 * Decompiled with CFR 0.152.
 */
package com.whatsapp.client;

import com.whatsapp.api.contacts.MMSUploader;
import com.whatsapp.api.util.Utilities;
import com.whatsapp.client.BGApp;
import com.whatsapp.client.FunXMPP;
import com.whatsapp.client.MediaData;
import com.whatsapp.client.MessageStore;
import com.whatsapp.client.MessageStoreProvider;
import com.whatsapp.client.UploadScaler;

public class BGMMSCreator {
    public FunXMPP.FMessage _fmsg;
    BGApp.MMSUploadInfo _mmsInfo;
    public boolean _retryMode = false;
    private boolean _cancelled = false;
    private boolean _keyWritebackInProgress = false;
    private boolean _urlWritebackInProgress = false;
    private static BGMMSCreator _curCreator = null;

    public BGMMSCreator(FunXMPP.FMessage fmsg, BGApp.MMSUploadInfo info, boolean retry) {
        this._mmsInfo = info;
        this._fmsg = fmsg;
        this._retryMode = retry;
    }

    public static synchronized boolean requestUpload(FunXMPP.FMessage fmsg, BGApp.MMSUploadInfo info, boolean retry) {
        if (_curCreator != null) {
            return false;
        }
        _curCreator = new BGMMSCreator(fmsg, info, retry);
        if (retry) {
            _curCreator.resetToUploading();
        } else {
            _curCreator.startMMS();
        }
        return true;
    }

    public static boolean isActive() {
        return _curCreator != null;
    }

    public static synchronized void creatorDone(BGMMSCreator creator) {
        if (_curCreator == creator) {
            _curCreator = null;
        } else {
            Utilities.logData("BGMMS MISMATCH");
        }
    }

    public static synchronized void cancelUpload() {
        if (_curCreator != null) {
            _curCreator.cancel();
        }
    }

    private void addInitialImageMMSKey() {
        final String systemPath = "file:///" + this._mmsInfo.fullPath;
        final MessageStore mStore = MessageStoreProvider.getMessageStore();
        mStore.addMMSFilename(systemPath, null, new MessageStore.MMSKeyStoreCallback(){
            private long _offset;

            public void setOffset(long offset) {
                Utilities.logData("preliminary image upload set offset " + offset + " for orig file " + systemPath);
                this._offset = offset;
            }

            public void operationCompleted() {
                MediaData md = (MediaData)BGMMSCreator.this._fmsg.thumb_image;
                md.filenameKey = this._offset;
                mStore.updateMessageStatus(BGMMSCreator.this._fmsg, true, new MessageStore.CompletionCallback(){

                    public void operationCompleted() {
                        BGMMSCreator.this.launchImage();
                    }
                });
            }
        });
    }

    private void launchImage() {
        UploadScaler uScaler = new UploadScaler(this._mmsInfo.fullPath, this);
        uScaler.initialize();
    }

    private void launchRegular() {
        Utilities.logData("launching mmsupload from bgmms with fullpath " + this._mmsInfo.fullPath);
        MMSUploader uploadThread = new MMSUploader(this._mmsInfo.fullPath, this._mmsInfo.contentType, BGApp.getInstance()._myPlainJid, this._fmsg.key, this._fmsg.media_name, this);
        uploadThread.start();
    }

    private void startMMS() {
        if (this._fmsg.media_wa_type == 1) {
            this.addInitialImageMMSKey();
        } else {
            this.launchRegular();
        }
    }

    private void resetToUploading() {
        this._fmsg.status = 1;
        MessageStoreProvider.getMessageStore().updateMessageStatus(this._fmsg, false, new MessageStore.CompletionCallback(){

            public void operationCompleted() {
                BGMMSCreator.this.retryMMS();
            }
        });
    }

    private void retryMMS() {
        MediaData fromDiskMD = (MediaData)this._fmsg.thumb_image;
        fromDiskMD.pullFilenames();
        this._mmsInfo = new BGApp.MMSUploadInfo();
        this._mmsInfo.contentType = fromDiskMD.mimeType;
        this._mmsInfo.cryptoName = this._fmsg.media_name;
        this._mmsInfo.key = this._fmsg.key;
        if (this._fmsg.media_wa_type == 1) {
            this._mmsInfo.fullPath = fromDiskMD.filename.substring(8);
            this.launchImage();
        } else {
            this._mmsInfo.fullPath = fromDiskMD.filename;
            this.launchRegular();
        }
    }

    private void cancel() {
        this._cancelled = true;
    }

    public boolean isCancelled() {
        return this._cancelled;
    }

    public synchronized void keyWriteBackToggle(boolean starting) {
        if (starting) {
            if (this._urlWritebackInProgress) {
                try {
                    Utilities.logData("upload scaled key writeback forced to wait.");
                    this.wait();
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            this._keyWritebackInProgress = true;
        } else {
            this._keyWritebackInProgress = false;
            this.notify();
        }
    }

    public synchronized void urlWriteBackToggle(boolean starting) {
        if (starting) {
            if (this._keyWritebackInProgress) {
                try {
                    Utilities.logData("upload url writeback forced to wait.");
                    this.wait();
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            this._urlWritebackInProgress = true;
        } else {
            this._urlWritebackInProgress = false;
            this.notify();
        }
    }
}

