/*
 * Decompiled with CFR 0.152.
 */
package com.whatsapp.client;

import com.whatsapp.api.util.DateTimeUtilities;
import com.whatsapp.api.util.Utilities;
import com.whatsapp.client.Constants;
import com.whatsapp.client.FGApp;
import com.whatsapp.client.MMSCreator;
import com.whatsapp.client.Res;
import com.whatsapp.client.test.ContactListMidlet;
import java.io.InputStream;
import javax.microedition.io.Connector;
import javax.microedition.io.file.FileConnection;
import javax.microedition.lcdui.Alert;
import javax.microedition.lcdui.AlertType;
import javax.microedition.lcdui.Command;
import javax.microedition.lcdui.CommandListener;
import javax.microedition.lcdui.CustomItem;
import javax.microedition.lcdui.Displayable;
import javax.microedition.lcdui.Form;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Item;
import javax.microedition.media.Manager;
import javax.microedition.media.MediaException;
import javax.microedition.media.Player;
import javax.microedition.media.control.VolumeControl;

public class AudioDisplayForm
extends Form
implements CommandListener {
    private String _fileLoc;
    private String _mimeType;
    private Displayable _parentScr;
    private Player _player;
    private VolumeControl _volControl;
    private boolean _mmsPreviewMode = false;
    private MMSCreator.AudioCreator _audCreator = null;
    private Command _backCmd = new Command(Res.getString(59), 2, 1);
    private Command _playCmd = new Command(Res.getString(115), 4, 1);
    private Command _stopCmd = new Command(Res.getString(161), 4, 1);
    private Command _chooseCmd = new Command(Res.getString(69), 4, 1);
    private Command _cancelCmd = new Command(Res.getString(63), 3, 1);
    FileConnection fileC = null;
    InputStream is = null;

    public AudioDisplayForm(Displayable parentScr, long timestamp, String fileLoc, String mimeType, MMSCreator.AudioCreator audioCreator) {
        super(Constants.STRING_EMPTY_STRING);
        this._fileLoc = fileLoc;
        this._mimeType = mimeType;
        Utilities.logData("audio screen launched with file " + fileLoc + " and mimetype " + mimeType);
        this._parentScr = parentScr;
        if (audioCreator != null) {
            this._audCreator = audioCreator;
            this._mmsPreviewMode = true;
            this.addCommand(this._chooseCmd);
            this.addCommand(this._cancelCmd);
            this.setTitle(Res.getString(123));
        } else {
            this.addCommand(this._backCmd);
            this.setTitle(DateTimeUtilities.simpleDayFormat(timestamp) + " " + DateTimeUtilities.shortTimeFormat(timestamp));
        }
        this.setCommandListener(this);
        this.append(Res.getString(103));
        BGLoader loader = new BGLoader();
        loader.start();
    }

    private void closeFileResources() {
        if (this.is != null) {
            try {
                this.is.close();
            }
            catch (Exception x) {
                // empty catch block
            }
        }
        if (this.fileC != null) {
            try {
                this.fileC.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public void commandAction(Command cmd, Displayable dsplbl) {
        if (cmd == this._backCmd || cmd == this._cancelCmd) {
            if (this._player != null) {
                try {
                    this._player.stop();
                }
                catch (MediaException mmx) {
                    // empty catch block
                }
                this._player.close();
            }
            this.closeFileResources();
            FGApp.getInstance().setTopPane(this._parentScr);
            ContactListMidlet.getInstance()._display.setCurrent(this._parentScr);
        } else if (cmd == this._playCmd) {
            if (this._player != null) {
                try {
                    this._player.start();
                    this.removeCommand(this._playCmd);
                    this.addCommand(this._stopCmd);
                }
                catch (Throwable t) {
                    Utilities.logData("couldnt play audio: " + t.toString());
                }
            }
        } else if (cmd == this._stopCmd) {
            if (this._player != null) {
                try {
                    this._player.stop();
                    this.removeCommand(this._stopCmd);
                    this.addCommand(this._playCmd);
                }
                catch (Throwable t) {
                    Utilities.logData("couldnt stop audio: " + t.toString());
                }
            }
        } else if (cmd == this._chooseCmd) {
            if (this._player != null) {
                try {
                    this._player.stop();
                }
                catch (MediaException mediaException) {
                    // empty catch block
                }
                this._player.close();
            }
            this.closeFileResources();
            this._audCreator.postChoiceProcessFile();
            FGApp.getInstance().setTopPane(this._parentScr);
            ContactListMidlet.getInstance()._display.setCurrent(this._parentScr);
        }
    }

    private class BGLoader
    extends Thread {
        private BGLoader() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            String errorTxt;
            boolean result;
            block11: {
                result = false;
                errorTxt = Constants.STRING_EMPTY_STRING;
                try {
                    AudioDisplayForm.this.fileC = (FileConnection)Connector.open((String)AudioDisplayForm.this._fileLoc, (int)1);
                    AudioDisplayForm.this.is = AudioDisplayForm.this.fileC.openInputStream();
                    AudioDisplayForm.this._player = Manager.createPlayer((InputStream)AudioDisplayForm.this.is, (String)AudioDisplayForm.this._mimeType);
                    AudioDisplayForm.this._player.realize();
                    AudioDisplayForm.this._player.prefetch();
                    AudioDisplayForm.this._volControl = (VolumeControl)AudioDisplayForm.this._player.getControl("VolumeControl");
                    if (AudioDisplayForm.this._volControl != null) {
                        AudioDisplayForm.this._volControl.setMute(false);
                        AudioDisplayForm.this.deleteAll();
                        AudioDisplayForm.this.addCommand(AudioDisplayForm.this._playCmd);
                        VolumeWidget widget = new VolumeWidget();
                        AudioDisplayForm.this.append((Item)widget);
                        ContactListMidlet.getInstance()._display.setCurrentItem((Item)widget);
                        result = true;
                        break block11;
                    }
                    errorTxt = Res.getString(75);
                }
                catch (MediaException jMX) {
                    if (jMX.getMessage().indexOf("Sounds not allowed") != -1) {
                        errorTxt = Res.getString(65);
                        break block11;
                    }
                    errorTxt = jMX.toString();
                }
                catch (Throwable t) {
                    if (AudioDisplayForm.this._player != null) {
                        try {
                            AudioDisplayForm.this._player.close();
                        }
                        catch (Throwable tt) {
                            // empty catch block
                        }
                    }
                    Utilities.logData("audio loader died: " + t.toString());
                    errorTxt = t.toString();
                }
            }
            if (!result) {
                Alert byeAlert = new Alert(Res.getString(58), errorTxt, null, AlertType.ERROR);
                AudioDisplayForm.this.closeFileResources();
                FGApp.getInstance().setTopPane(AudioDisplayForm.this._parentScr);
                ContactListMidlet.getInstance()._display.setCurrent(byeAlert, AudioDisplayForm.this._parentScr);
            }
        }
    }

    private class VolumeWidget
    extends CustomItem {
        static final int INCREMENT = 20;
        static final int totalBlocks = 6;
        static final int blockMargin = 5;

        public VolumeWidget() {
            super(null);
        }

        protected int getMinContentWidth() {
            return this.getPrefContentWidth(0);
        }

        protected int getMinContentHeight() {
            return 50;
        }

        protected int getPrefContentWidth(int i) {
            return AudioDisplayForm.this.getWidth() - 20;
        }

        protected int getPrefContentHeight(int i) {
            return 100;
        }

        protected boolean traverse(int dir, int viewportWidth, int viewportHeight, int[] visRect_inout) {
            int curVol = AudioDisplayForm.this._volControl.getLevel();
            boolean needsRepaint = false;
            if (dir == 1) {
                if (curVol < 100) {
                    if ((curVol += 20) > 100) {
                        curVol = 100;
                    }
                    AudioDisplayForm.this._volControl.setLevel(curVol);
                    needsRepaint = true;
                }
            } else if (dir == 6 && curVol > 0) {
                if ((curVol -= 20) < 0) {
                    curVol = 0;
                }
                AudioDisplayForm.this._volControl.setLevel(curVol);
                needsRepaint = true;
            }
            if (needsRepaint) {
                this.repaint();
            }
            return true;
        }

        protected void paint(Graphics g, int width, int height) {
            int curVol = AudioDisplayForm.this._volControl.getLevel();
            g.setColor(0xFFFFFF);
            g.fillRect(0, 0, width, height);
            int blockWidth = Math.min((width - 30) / 6, 25);
            int blockHeight = Math.min(50, height - 10);
            for (int i = 1; i < 6; ++i) {
                g.setColor(0x808080);
                int xpos = (5 + blockWidth) * i + 5;
                int ypos = 5;
                g.fillRect(xpos, ypos, blockWidth, blockHeight);
                g.setColor(0xD3D3D3);
                g.drawLine(xpos, ypos, xpos + blockWidth, ypos);
                g.drawLine(xpos, ypos, xpos, ypos + blockHeight);
            }
            if (curVol == 0) {
                g.setColor(0xFF0000);
                g.drawLine(5, 5, 5 + blockWidth, 5 + blockHeight);
                g.drawLine(5, 5 + blockHeight, 5 + blockWidth, 5);
            } else {
                int blocksToFill = Math.max(curVol / 20, 1);
                g.setColor(32768);
                for (int i = 0; i < blocksToFill; ++i) {
                    int xpos = (5 + blockWidth) * (i + 1) + 5;
                    int ypos = 5;
                    g.fillRect(xpos, ypos, blockWidth, blockHeight);
                }
            }
            g.setColor(0);
            g.drawString(Res.getString(175), 5, height - 5, 36);
        }
    }
}

