/*
 * Decompiled with CFR 0.152.
 */
package com.whatsapp.api.util;

import com.whatsapp.api.util.AppManager;
import com.whatsapp.api.util.DateTimeUtilities;
import com.whatsapp.api.util.S40MD5Digest;
import com.whatsapp.api.util.SafeThread;
import com.whatsapp.client.Constants;
import com.whatsapp.client.test.ContactListMidlet;
import com.whatsapp.client.test.WhatsAppBG;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.util.Vector;
import javax.microedition.io.Connector;
import javax.microedition.io.file.FileConnection;

public class Utilities {
    private static final byte DECODER_XOR_VALUE = 19;
    public static final String LOGFILE_NAME = "WhatsAppLog.txt";
    public static final String FG_PREFIX = "FG-";
    public static final String BG_PREFIX = "BG-";
    public static final int MAX_LOG_FILE_SIZE = 200000;
    private static final String KILL_ALERT = "notice";
    private static AsyncLogThread logger;
    static /* synthetic */ Class class$com$whatsapp$api$util$Utilities;

    public static String decodeString(byte[] data) {
        byte[] newData = new byte[data.length];
        for (int i = data.length - 1; i >= 0; --i) {
            newData[i] = (byte)(data[i] ^ 0x13);
        }
        return new String(newData);
    }

    public static String getMidletVersion() {
        if (AppManager.isBackground()) {
            return WhatsAppBG.getInstance().getAppProperty(Constants.MIDLET_VERSION);
        }
        return ContactListMidlet.getInstance().getAppProperty(Constants.MIDLET_VERSION);
    }

    public static String getChatPassword() {
        String imei = System.getProperty("com.nokia.mid.imei");
        StringBuffer buffer = new StringBuffer(imei);
        if (buffer.length() == 0) {
            Utilities.logData("UUUUUUUU couldnt find a cell-based UID in password");
            return null;
        }
        buffer = buffer.reverse();
        S40MD5Digest digest = new S40MD5Digest();
        digest.reset();
        try {
            digest.update(buffer.toString().getBytes(Constants.CHARSET_UTF8));
        }
        catch (UnsupportedEncodingException uux) {
            Utilities.logData("chat password doesn't like utf8");
            return null;
        }
        byte[] bytes = digest.digest();
        int bytesLength = bytes.length;
        buffer = new StringBuffer();
        for (int i = 0; i < bytesLength; ++i) {
            int unsignedByte = bytes[i] + 128;
            buffer.append(Integer.toString(unsignedByte, 16));
        }
        return buffer.toString();
    }

    public static void safeStringOut(String s, DataOutputStream dOS) throws IOException {
        if (s == null) {
            dOS.writeUTF(Constants.STRING_EMPTY_STRING);
        } else {
            dOS.writeUTF(s);
        }
    }

    public static String readBlankAsNull(DataInputStream dIS) throws IOException {
        String s = dIS.readUTF();
        if (s != null && s.length() == 0) {
            return null;
        }
        return s;
    }

    public static String safeIntern(String str) {
        if (str == null) {
            return null;
        }
        return str.intern();
    }

    private static byte forDigit(int b) {
        if (b < 10) {
            return (byte)(48 + b);
        }
        return (byte)(97 + b - 10);
    }

    public static byte[] bytesToHex(byte[] bytes) {
        byte[] ret = new byte[bytes.length * 2];
        int i = 0;
        for (int c = 0; c < bytes.length; ++c) {
            int ub = bytes[c];
            if (ub < 0) {
                ub += 256;
            }
            ret[i] = Utilities.forDigit(ub >> 4);
            ret[++i] = Utilities.forDigit(ub % 16);
            ++i;
        }
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    public static byte[] getResourceAsByteArray(String path) {
        void var1_1;
        byte[] data = null;
        InputStream is = null;
        try {
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            is = (class$com$whatsapp$api$util$Utilities == null ? (class$com$whatsapp$api$util$Utilities = Utilities.class$("com.whatsapp.api.util.Utilities")) : class$com$whatsapp$api$util$Utilities).getResourceAsStream(path);
            int i = -1;
            while ((i = is.read()) != -1) {
                baos.write(i);
            }
            data = baos.toByteArray();
        }
        catch (IOException ex) {
            ex.printStackTrace();
        }
        finally {
            if (is != null) {
                try {
                    is.close();
                }
                catch (Exception exception) {}
            }
        }
        return var1_1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    public static byte[] getFileAsByteArray(String path) {
        void var1_1;
        byte[] data = null;
        InputStream is = null;
        FileConnection fileC = null;
        try {
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            fileC = (FileConnection)Connector.open((String)path, (int)1);
            is = fileC.openInputStream();
            int i = -1;
            while ((i = is.read()) != -1) {
                baos.write(i);
            }
            data = baos.toByteArray();
        }
        catch (IOException ex) {
            ex.printStackTrace();
        }
        finally {
            if (is != null) {
                try {
                    is.close();
                }
                catch (Exception x) {}
            }
            if (fileC != null) {
                try {
                    fileC.close();
                }
                catch (Exception x) {}
            }
        }
        return var1_1;
    }

    public static String getLocalFilename(String filepath) {
        int lastBackSlash;
        if (filepath == null) {
            return Constants.STRING_EMPTY_STRING;
        }
        int lastSlash = filepath.lastIndexOf(47);
        int useSlash = Math.max(lastSlash, lastBackSlash = filepath.lastIndexOf(92));
        if (useSlash == -1) {
            return filepath;
        }
        return filepath.substring(useSlash + 1);
    }

    public static String incrementFilename(String filename) {
        String extension;
        String base;
        int lastDot = filename.lastIndexOf(46);
        if (lastDot < 0) {
            base = filename;
            extension = "";
        } else {
            base = filename.substring(0, lastDot);
            extension = filename.substring(lastDot);
        }
        int lastParenStart = -1;
        int lastParenEnd = 0;
        while ((lastParenStart = base.indexOf(40, lastParenStart + 1)) >= 0 && (lastParenEnd = base.indexOf(41, lastParenStart + 1)) >= 0) {
            try {
                int i = Integer.parseInt(base.substring(lastParenStart + 1, lastParenEnd));
                return base.substring(0, lastParenStart + 1) + (i + 1) + base.substring(lastParenEnd) + extension;
            }
            catch (NumberFormatException e) {
            }
        }
        return base + "(1)" + extension;
    }

    public static String makeOldLogFileName(String filename) {
        String extension;
        String base;
        int lastDot = filename.lastIndexOf(46);
        if (lastDot < 0) {
            base = filename;
            extension = "";
        } else {
            base = filename.substring(0, lastDot);
            extension = filename.substring(lastDot);
        }
        return base + "Old" + extension;
    }

    public static String getLogfilePath() {
        return System.getProperty("fileconn.dir.memorycard") + "WhatsApp/";
    }

    public static void startLogging(boolean checkDirs) {
        if (checkDirs) {
            String pathname = Utilities.getLogfilePath();
            FileConnection dirFC = null;
            try {
                dirFC = (FileConnection)Connector.open((String)pathname, (int)3);
                if (!dirFC.exists()) {
                    dirFC.mkdir();
                }
                dirFC.close();
            }
            catch (Throwable t) {
                System.err.println(t.toString());
                return;
            }
        }
        logger = new AsyncLogThread();
        logger.start();
    }

    public static void syncLogData(String s) {
        LogEntry le = new LogEntry(s, System.currentTimeMillis());
        String filename = Utilities.getLogfilePath() + Utilities.getLogPrefix() + LOGFILE_NAME;
        Utilities.logToFile(filename, le);
    }

    public static void logData(String s) {
        System.err.println(s);
        if (logger != null) {
            LogEntry le = new LogEntry(s, System.currentTimeMillis());
            logger.putLine(le);
        }
    }

    public static void logData(long code, String payload) {
        Utilities.logData("WAC" + code + " " + payload);
    }

    public static void logData(long code, int num, String payload) {
        Utilities.logData("WAC" + code + " WAV" + num + " " + payload);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static long logToFile(String filename, LogEntry le) {
        long l;
        FileConnection dataFC;
        block21: {
            dataFC = null;
            OutputStream os = null;
            try {
                long dataOffset;
                dataFC = (FileConnection)Connector.open((String)filename, (int)3);
                if (dataFC.exists()) {
                    dataOffset = dataFC.fileSize();
                } else {
                    dataFC.create();
                    dataOffset = 0L;
                }
                os = dataFC.openOutputStream(dataOffset);
                String timeStamp = DateTimeUtilities.logTimeFormat(le.timestamp);
                os.write(timeStamp.getBytes());
                os.write(32);
                os.write(le.str.getBytes(Constants.CHARSET_UTF8));
                os.write(10);
                os.flush();
                l = dataOffset;
                if (os == null) break block21;
            }
            catch (Throwable t) {
                try {
                    System.err.println("logToFile: " + t.toString());
                    long l2 = -1L;
                    return l2;
                }
                catch (Throwable throwable) {
                    throw throwable;
                }
                finally {
                    if (os != null) {
                        try {
                            os.close();
                        }
                        catch (Exception x) {}
                    }
                    if (dataFC != null) {
                        try {
                            dataFC.close();
                        }
                        catch (Exception x) {}
                    }
                }
            }
            try {
                os.close();
            }
            catch (Exception x) {
                // empty catch block
            }
        }
        if (dataFC == null) return l;
        try {
            dataFC.close();
            return l;
        }
        catch (Exception x) {
            // empty catch block
        }
        return l;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void logKillAlert() {
        String filename = Utilities.getLogfilePath() + KILL_ALERT;
        FileConnection dataFC = null;
        OutputStream os = null;
        try {
            dataFC = (FileConnection)Connector.open((String)filename, (int)3);
            if (!dataFC.exists()) {
                dataFC.create();
            }
            os = dataFC.openOutputStream(0L);
            os.write(1);
            os.write(1);
            os.flush();
        }
        catch (Throwable throwable) {
        }
        finally {
            if (os != null) {
                try {
                    os.close();
                }
                catch (Exception x) {}
            }
            if (dataFC != null) {
                try {
                    dataFC.close();
                }
                catch (Exception x) {}
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    public static long getAndClearKillAlert(boolean logworthy) {
        void var3_3;
        String filename = Utilities.getLogfilePath() + KILL_ALERT;
        FileConnection dataFC = null;
        long res = 0L;
        try {
            dataFC = (FileConnection)Connector.open((String)filename, (int)3);
            if (dataFC.exists()) {
                res = dataFC.lastModified();
                dataFC.delete();
            }
        }
        catch (Throwable t) {
            if (logworthy) {
                Utilities.logData("repeated fail to delete kill alert");
            }
        }
        finally {
            if (dataFC != null) {
                try {
                    dataFC.close();
                }
                catch (Exception exception) {}
            }
        }
        return (long)var3_3;
    }

    private static String rotateLog(String filename) {
        FileConnection fileC = null;
        try {
            fileC = (FileConnection)Connector.open((String)Utilities.makeOldLogFileName(filename), (int)3);
            if (fileC.exists()) {
                fileC.delete();
            }
            fileC.close();
            fileC = (FileConnection)Connector.open((String)filename, (int)3);
            String basename = fileC.getName();
            fileC.rename(Utilities.makeOldLogFileName(basename));
            fileC.close();
            return null;
        }
        catch (Throwable t) {
            return t.toString();
        }
    }

    private static String getLogPrefix() {
        if (AppManager.isForeground()) {
            return FG_PREFIX;
        }
        return BG_PREFIX;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static /* synthetic */ String access$000() {
        return Utilities.getLogPrefix();
    }

    public static class AsyncLogThread
    extends SafeThread {
        private Vector _queue = new Vector();
        private String _filename = Utilities.getLogfilePath() + Utilities.access$000() + "WhatsAppLog.txt";

        synchronized void putLine(LogEntry le) {
            this._queue.addElement(le);
            this.notify();
        }

        private synchronized LogEntry getLineToProcess() {
            if (this._queue.isEmpty()) {
                try {
                    this.wait();
                }
                catch (Exception x) {
                    // empty catch block
                }
            }
            LogEntry res = (LogEntry)this._queue.elementAt(0);
            this._queue.removeElementAt(0);
            return res;
        }

        public void safeRun() {
            while (true) {
                LogEntry curEntry;
                long curSize;
                if ((curSize = Utilities.logToFile(this._filename, curEntry = this.getLineToProcess())) > 200000L) {
                    String rotateErr = Utilities.rotateLog(this._filename);
                    String logline = "rotated log";
                    if (rotateErr != null) {
                        logline = logline + " with error " + rotateErr;
                    }
                    this.putLine(new LogEntry(logline, System.currentTimeMillis()));
                }
                Thread.yield();
            }
        }
    }

    private static class LogEntry {
        public long timestamp;
        public String str;

        public LogEntry(String s, long t) {
            this.timestamp = t;
            this.str = s;
        }
    }
}

