/*
 * Decompiled with CFR 0.152.
 */
package com.whatsapp.api.util;

import java.util.Vector;

public class Sort {
    private static void qSortInplaceRec(Object[] arr, int low, int high, Comparator c) {
        int i = low;
        int j = high;
        Object pivot = arr[low + (high - low) / 2];
        while (i <= j) {
            while (c.compare(arr[i], pivot) < 0) {
                ++i;
            }
            while (c.compare(arr[j], pivot) > 0) {
                --j;
            }
            if (i > j) continue;
            Sort.exchange(arr, i, j);
            ++i;
            --j;
        }
        if (low < j) {
            Sort.qSortInplaceRec(arr, low, j, c);
        }
        if (i < high) {
            Sort.qSortInplaceRec(arr, i, high, c);
        }
    }

    private static void exchange(Object[] arr, int i, int j) {
        Object temp = arr[i];
        arr[i] = arr[j];
        arr[j] = temp;
    }

    public static Vector quickSort(Vector v, Comparator c) {
        Object[] arr = new Object[v.size()];
        v.copyInto(arr);
        Sort.qSortInplaceRec(arr, 0, v.size() - 1, c);
        Vector<Object> ret = new Vector<Object>(v.size());
        for (int i = 0; i < v.size(); ++i) {
            ret.addElement(arr[i]);
        }
        return ret;
    }

    public static void insertionSortAdd(Vector v, Object newObj, Comparator comparator) {
        boolean placed = false;
        for (int i = 0; i < v.size(); ++i) {
            Object existing = v.elementAt(i);
            if (comparator.compare(newObj, existing) >= 0) continue;
            v.insertElementAt(newObj, i);
            placed = true;
            break;
        }
        if (!placed) {
            v.addElement(newObj);
        }
    }

    public static interface Comparator {
        public int compare(Object var1, Object var2);
    }
}

