/*
 * Decompiled with CFR 0.152.
 */
package com.whatsapp.api.util;

import com.whatsapp.api.util.Utilities;
import com.whatsapp.client.FunXMPP;
import com.whatsapp.org.bouncycastle.util.encoders.Base64Encoder;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import javax.microedition.lcdui.Image;

public class ImageDisplay {
    public static Image getImageFromThumb(FunXMPP.FMessage fmsg) {
        if (fmsg == null || fmsg.data == null) {
            return null;
        }
        Base64Encoder decoder = new Base64Encoder();
        ByteArrayOutputStream baOS = new ByteArrayOutputStream();
        try {
            decoder.decode(fmsg.data, baOS);
        }
        catch (IOException ex) {
            Utilities.logData("base64 decode failed: " + ex.toString());
            return null;
        }
        byte[] binData = baOS.toByteArray();
        return Image.createImage((byte[])binData, (int)0, (int)binData.length);
    }

    public static Image scaleImage(Image original, int newWidth, int newHeight) {
        return ImageDisplay.scaleImage(original, newWidth, newHeight, false);
    }

    public static Image scaleImage(Image original, int newWidth, int newHeight, boolean cropCenter) {
        int origWidth = original.getWidth();
        int origHeight = original.getHeight();
        int origX = 0;
        int origY = 0;
        if (cropCenter) {
            float origRatio = (float)origWidth / (float)origHeight;
            float newRatio = (float)newWidth / (float)newHeight;
            if (origRatio > newRatio) {
                int cropX = origWidth - (int)((float)origHeight * newRatio);
                origWidth -= cropX / 2;
                origX += cropX / 2 + cropX % 2;
            } else {
                int cropY = origHeight - (int)((float)origWidth / newRatio);
                origHeight -= cropY / 2;
                origY += cropY / 2 + cropY % 2;
            }
        }
        int[] rawInput = new int[origHeight * origWidth];
        original.getRGB(rawInput, 0, origWidth, origX, origY, origWidth, origHeight);
        int[] rawOutput = new int[newWidth * newHeight];
        int YD = origHeight / newHeight * origWidth - origWidth;
        int YR = origHeight % newHeight;
        int XD = origWidth / newWidth;
        int XR = origWidth % newWidth;
        int outOffset = 0;
        int inOffset = 0;
        int YE = 0;
        for (int y = newHeight; y > 0; --y) {
            int XE = 0;
            for (int x = newWidth; x > 0; --x) {
                rawOutput[outOffset++] = rawInput[inOffset];
                inOffset += XD;
                if ((XE += XR) < newWidth) continue;
                XE -= newWidth;
                ++inOffset;
            }
            inOffset += YD;
            if ((YE += YR) < newHeight) continue;
            YE -= newHeight;
            inOffset += origWidth;
        }
        return Image.createRGBImage((int[])rawOutput, (int)newWidth, (int)newHeight, (boolean)false);
    }
}

