/*
 * Decompiled with CFR 0.152.
 */
package com.whatsapp.api.util;

import com.nokia.mid.ui.DirectUtils;
import javax.microedition.lcdui.Graphics;

public class GraphicsUtils {
    public static void drawGradient(Graphics gr, boolean vert, boolean alpha, int startColor, int endColor, int x, int y, int width, int height) {
        int a = 3;
        int r = 2;
        boolean g = true;
        boolean b = false;
        int colorCount = (alpha ? a : r) + 1;
        int[] color = new int[colorCount];
        int[] slice = new int[colorCount];
        int gradDim = vert ? height : width;
        int gradations = Math.min(gradDim, 12);
        int extraGain = gradDim % gradations;
        int heightSlice = gradDim / gradations;
        for (int c = 0; c < colorCount; ++c) {
            color[c] = startColor >> c * 8 & 0xFF;
            int endColorComponent = endColor >> c * 8 & 0xFF;
            slice[c] = (endColorComponent - color[c]) / gradations;
        }
        int runningOffset = 0;
        for (int i = 0; i < gradations; ++i) {
            int colorIntValue = 0;
            for (int c = 0; c < colorCount; ++c) {
                colorIntValue |= color[c] << c * 8;
                int n = c;
                color[n] = color[n] + slice[c];
            }
            if (alpha) {
                DirectUtils.getDirectGraphics((Graphics)gr).setARGBColor(colorIntValue);
            } else {
                gr.setColor(colorIntValue);
            }
            int curSlice = heightSlice;
            if (i < extraGain) {
                ++curSlice;
            }
            if (vert) {
                gr.fillRect(x, y + runningOffset, width, curSlice);
            } else {
                gr.fillRect(x + runningOffset, y, curSlice, height);
            }
            runningOffset += curSlice;
        }
    }
}

