/*
 * Decompiled with CFR 0.152.
 */
package com.whatsapp.api.util;

import com.whatsapp.api.util.Utilities;
import java.io.IOException;
import java.io.InterruptedIOException;
import javax.microedition.io.Connection;
import javax.microedition.io.Connector;

public class ConnectionThread
extends Thread {
    private Connection conn;
    private boolean opened = false;
    protected boolean stopped = false;
    protected boolean wantsStop = false;

    protected Connection openConnection(String addr) throws IOException {
        if (this.opened) {
            throw new IllegalArgumentException("connection already opened");
        }
        this.conn = Connector.open((String)addr);
        this.opened = true;
        if (this.wantsStop) {
            this.stopped = true;
            this.conn.close();
            throw new InterruptedIOException("stopped");
        }
        return this.conn;
    }

    public void stop() {
        this.wantsStop = true;
        if (!this.opened) {
            return;
        }
        this.stopped = true;
        try {
            this.conn.close();
        }
        catch (IOException ex) {
            Utilities.logData("conn/close/io-error: " + ex);
        }
    }

    public boolean isStopped() {
        return this.stopped || this.wantsStop || this.opened && !this.isAlive();
    }
}

