/*
 * Decompiled with CFR 0.152.
 */
package com.whatsapp.api.ui;

import com.whatsapp.api.ui.CommandBarField;
import com.whatsapp.api.ui.Rect;
import com.whatsapp.api.ui.UIField;
import com.whatsapp.api.ui.UIOverlay;
import java.util.Vector;
import javax.microedition.lcdui.Graphics;

public abstract class UIManager
extends UIField {
    private int _vScroll = 0;
    private int _hScroll = 0;
    private int _virtualWidth = -1;
    private int _virtualHeight = -1;
    private Vector _fields = new Vector();
    private Vector _overlays = null;
    private int _lPad = 0;
    private int _rPad = 0;
    private int _bPad = 0;
    private int _tPad = 0;

    public UIManager(long style) {
        super(style);
    }

    public void setCommandBar(CommandBarField cmdBar) {
        for (int i = 0; i < this._fields.size(); ++i) {
            ((UIField)this._fields.elementAt(i)).setCommandBar(cmdBar);
        }
        super.setCommandBar(cmdBar);
    }

    public UIField elementAt(int index) {
        return (UIField)this._fields.elementAt(index);
    }

    public int size() {
        return this._fields.size();
    }

    public void add(UIField field) {
        this.insertAt(field, this._fields.size());
    }

    public void remove(UIField field) {
        int idx = this._fields.indexOf(field);
        if (idx != -1) {
            this.removeAt(idx);
        }
    }

    public void removeAt(int index) {
        UIField field = (UIField)this._fields.elementAt(index);
        this._fields.removeElementAt(index);
        field.setCommandBar(null);
        field.setManager(null);
        if (field instanceof UIOverlay) {
            this.removeOverlay((UIOverlay)((Object)field));
        }
    }

    public void insertBefore(UIField newField, UIField markerField) {
        int index = 0;
        if (markerField != null) {
            index = this.getChildIndex(markerField);
        }
        this.insertAt(newField, index);
    }

    public void insertAt(UIField newField, int index) {
        this._fields.insertElementAt(newField, index);
        newField.setCommandBar(this._cmdBar);
        newField.setManager(this);
        if (newField instanceof UIOverlay) {
            this.addOverlay((UIOverlay)((Object)newField));
        }
    }

    public void addOverlay(UIOverlay overlay) {
        if (this._overlays == null) {
            this._overlays = new Vector(1, 1);
        }
        this._overlays.addElement(overlay);
    }

    public void removeOverlay(UIOverlay overlay) {
        if (this._overlays == null) {
            return;
        }
        this._overlays.removeElement(overlay);
    }

    public void layout(int width, int height) {
        this.sublayout(width, height);
        if (this._overlays != null) {
            int size = this._overlays.size();
            for (int i = 0; i < size; ++i) {
                UIOverlay overlay = (UIOverlay)this._overlays.elementAt(i);
                overlay.layoutOverlay(width, height);
            }
        }
    }

    protected void setVirtualExtent(int width, int height) {
        this._virtualWidth = width;
        this._virtualHeight = height;
    }

    public int getVirtualWidth() {
        if (this._virtualWidth == -1) {
            return this.getWidth();
        }
        return this._virtualWidth;
    }

    public int getVirtualHeight() {
        if (this._virtualHeight == -1) {
            return this.getHeight();
        }
        return this._virtualHeight;
    }

    public abstract void sublayout(int var1, int var2);

    public void paint(Graphics g, int x, int y, int width, int height) {
        this.subpaint(g, x, y, width, height);
    }

    private boolean xIntersects(Rect fldRect, int width) {
        return fldRect.x >= this._hScroll && fldRect.x < this._hScroll + width || fldRect.x < this._hScroll && fldRect.x + fldRect.width >= this._hScroll;
    }

    private boolean yIntersects(Rect fldRect, int height) {
        return fldRect.y >= this._vScroll && fldRect.y < this._vScroll + height || fldRect.y < this._vScroll && fldRect.y + fldRect.height >= this._vScroll;
    }

    protected void subpaint(Graphics g, int x, int y, int width, int height) {
        int i;
        Rect clip = new Rect(g.getClipX(), g.getClipY(), g.getClipWidth(), g.getClipHeight());
        g.clipRect(x, y, width, height);
        int size = this._fields.size();
        if (this.getStyleBit(16L)) {
            x -= this._hScroll;
            y -= this._vScroll;
        }
        for (i = 0; i < size; ++i) {
            UIField fld = (UIField)this._fields.elementAt(i);
            Rect curFldRect = new Rect(fld.getManagerX(), fld.getManagerY(), fld.getWidth(), fld.getHeight());
            if (!this.xIntersects(curFldRect, width) || !this.yIntersects(curFldRect, height)) continue;
            fld.paint(g, x + curFldRect.x, y + curFldRect.y, curFldRect.width, curFldRect.height);
        }
        g.setClip(clip.x, clip.y, clip.width, clip.height);
        if (this._overlays != null) {
            size = this._overlays.size();
            for (i = 0; i < size; ++i) {
                UIOverlay overlay = (UIOverlay)this._overlays.elementAt(i);
                overlay.paintOverlay(g, x, y, width, height);
            }
        }
    }

    public int getVerticalScroll() {
        return this._vScroll;
    }

    public void setVerticalScroll(int vScroll) {
        this._vScroll = vScroll;
    }

    public void adjustVerticalScroll(int scrollDelta) {
        this._vScroll += scrollDelta;
    }

    public int getHorizontalScroll() {
        return this._hScroll;
    }

    public void setHorizontalScroll(int hScroll) {
        this._hScroll = hScroll;
    }

    public int getNumChildren() {
        return this._fields.size();
    }

    public UIField getChildAt(int i) {
        return (UIField)this._fields.elementAt(i);
    }

    public int getChildIndex(UIField child) {
        return this._fields.indexOf(child);
    }

    public void setPadding(int top, int right, int bottom, int left) {
        this._tPad = top;
        this._rPad = right;
        this._bPad = bottom;
        this._lPad = left;
    }

    public int getPaddingTop() {
        return this._tPad;
    }

    public int getPaddingBottom() {
        return this._bPad;
    }

    public int getPaddingLeft() {
        return this._lPad;
    }

    public int getPaddingRight() {
        return this._rPad;
    }

    public void snapToMe(UIField child) {
        if (!this._fields.contains(child)) {
            throw new IllegalArgumentException("that's not my child");
        }
        this.setVerticalScroll(child.getManagerY());
        if (this.getManager() != null) {
            this.getManager().snapToMe(this);
        }
    }

    public void ensureVisible(UIField child, int offset) {
        int totalOffset = offset + child.getManagerY();
        if (totalOffset > this.getVerticalScroll() + this.getHeight() || totalOffset < this.getVerticalScroll()) {
            this.setVerticalScroll(totalOffset);
        }
        if (this.getManager() != null) {
            this.getManager().ensureVisible(this, totalOffset - this.getVerticalScroll());
        }
    }
}

