/*
 * Decompiled with CFR 0.152.
 */
package com.whatsapp.api.ui;

import com.whatsapp.api.ui.Command;
import com.whatsapp.api.ui.CommandBarField;
import com.whatsapp.api.ui.UIManager;
import java.util.Vector;
import javax.microedition.lcdui.Graphics;

public abstract class UIField {
    private int _managerX;
    private int _managerY;
    private int _align = 0;
    private int _width;
    private int _height;
    private UIManager _mgr;
    private int _tMar = 0;
    private int _bMar = 0;
    private int _lMar = 0;
    private int _rMar = 0;
    private boolean _hasFocus = false;
    public static final int FOCUSABLE = 1;
    public static final int SHOW_SCROLL_BARS = 2;
    public static final int H_EXPAND = 4;
    public static final int V_EXPAND = 8;
    public static final int SCROLL = 16;
    public static final int REVERSE_DIR = 32;
    private final long _style;
    protected CommandBarField _cmdBar = null;
    private Vector _cmds = null;
    private Command.Listener _listener = null;

    public UIField(long style) {
        this._style = style;
    }

    public void setManager(UIManager mgr) {
        if (mgr != null && this._mgr != null && mgr != this._mgr) {
            throw new IllegalStateException("field already has manager");
        }
        this._mgr = mgr;
    }

    public UIManager getManager() {
        return this._mgr;
    }

    public void setAlign(int align) {
        this._align = align;
    }

    public int getAlign() {
        return this._align;
    }

    protected void setExtent(int width, int height) {
        this._width = width;
        this._height = height;
    }

    public int getWidth() {
        return this._width;
    }

    public int getHeight() {
        return this._height;
    }

    public void setManagerPosition(int x, int y) {
        this._managerX = x;
        this._managerY = y;
    }

    public int getManagerX() {
        return this._managerX;
    }

    public int getManagerY() {
        return this._managerY;
    }

    public int getAbsoluteX() {
        if (this.getManager() == null) {
            return 0;
        }
        return this._managerX + this.getManager().getAbsoluteX();
    }

    public int getAbsoluteY() {
        if (this.getManager() == null) {
            return 0;
        }
        return this._managerY + this.getManager().getAbsoluteY();
    }

    public void setCommandBar(CommandBarField cmdBar) {
        int i;
        if (this._cmdBar != null && this._cmds != null) {
            for (i = 0; i < this._cmds.size(); ++i) {
                this._cmdBar.removeCommand((FieldCommand)this._cmds.elementAt(i));
            }
        }
        this._cmdBar = cmdBar;
        if (this._cmdBar != null && this._hasFocus && this._cmds != null) {
            for (i = 0; i < this._cmds.size(); ++i) {
                this._cmdBar.addCommand((FieldCommand)this._cmds.elementAt(i));
            }
        }
    }

    public void addFieldCommand(Command cmd) {
        this.addFieldCommand(cmd, false);
    }

    private void addFieldCommand(Command cmd, boolean isDefault) {
        if (this._cmds == null) {
            this._cmds = new Vector(1, 1);
        }
        this.removeFieldCommand(cmd);
        FieldCommand fieldCmd = new FieldCommand(cmd, isDefault);
        this._cmds.addElement(fieldCmd);
        if (this._cmdBar != null && this._hasFocus) {
            this._cmdBar.addCommand(fieldCmd);
        }
    }

    public void removeFieldCommand(Command cmd) {
        if (this._cmds == null) {
            return;
        }
        for (int i = 0; i < this._cmds.size(); ++i) {
            FieldCommand fieldCmd = (FieldCommand)this._cmds.elementAt(i);
            if (fieldCmd.cmd != cmd) continue;
            this._cmds.removeElementAt(i);
            if (this._cmdBar == null) break;
            this._cmdBar.removeCommand(fieldCmd);
            break;
        }
    }

    public void setDefaultCommand(Command cmd) {
        if (this._cmds != null) {
            for (int i = 0; i < this._cmds.size(); ++i) {
                FieldCommand other = (FieldCommand)this._cmds.elementAt(i);
                if (((Command.FieldType)other.commandType).baseType != Command.FIELD_DEFAULT) continue;
                CommandBarField oldCmdBar = this._cmdBar;
                if (this._cmdBar != null) {
                    this.setCommandBar(null);
                }
                this._cmds.setElementAt(new FieldCommand(other.cmd, false), i);
                this.addFieldCommand(cmd, true);
                if (oldCmdBar != null) {
                    this.setCommandBar(oldCmdBar);
                }
                return;
            }
        }
        this.addFieldCommand(cmd, true);
    }

    private FieldCommand getFieldCommand(Command cmd) {
        if (this._cmds != null) {
            for (int i = 0; i < this._cmds.size(); ++i) {
                FieldCommand fieldCmd = (FieldCommand)this._cmds.elementAt(i);
                if (fieldCmd.cmd != cmd) continue;
                return fieldCmd;
            }
        }
        return null;
    }

    protected boolean hasFieldCommands() {
        return this._cmds != null && this._cmds.size() > 0;
    }

    protected void setFieldCommandListener(Command.Listener listener) {
        this._listener = listener;
    }

    protected void closeFieldCommandBar() {
        if (this._cmdBar != null) {
            this._cmdBar.hideMenu();
        }
    }

    public abstract void layout(int var1, int var2);

    public abstract void paint(Graphics var1, int var2, int var3, int var4, int var5);

    public void setMargin(int top, int right, int bottom, int left) {
        this._tMar = top;
        this._rMar = right;
        this._bMar = bottom;
        this._lMar = left;
    }

    public int getMarginLeft() {
        return this._lMar;
    }

    public int getMarginRight() {
        return this._rMar;
    }

    public int getMarginTop() {
        return this._tMar;
    }

    public int getMarginBottom() {
        return this._bMar;
    }

    public boolean traverse(int dir) {
        if (this.getStyleBit(1L) || this.hasFieldCommands()) {
            if (!this.hasFocus() || dir == 0) {
                this.setFocus(true);
                return true;
            }
            this.traverseOut();
        }
        return false;
    }

    public void traverseOut() {
        this.setFocus(false);
    }

    public void setFocus(boolean val) {
        if (this._hasFocus != val && this._cmdBar != null && this._cmds != null) {
            for (int i = 0; i < this._cmds.size(); ++i) {
                if (val) {
                    this._cmdBar.addCommand((FieldCommand)this._cmds.elementAt(i));
                    continue;
                }
                this._cmdBar.removeCommand((FieldCommand)this._cmds.elementAt(i));
            }
        }
        this._hasFocus = val;
    }

    public boolean hasFocus() {
        return this._hasFocus;
    }

    public long getStyle() {
        return this._style;
    }

    public boolean getStyleBit(long flag) {
        return (this._style & flag) > 0L;
    }

    class FieldCommand
    extends Command {
        public final Command cmd;

        public FieldCommand(Command cmd, boolean isDefault) {
            super(cmd.label, cmd.longLabel, isDefault ? FIELD_DEFAULT.create(cmd.commandType) : FIELD.create(cmd.commandType), cmd.priority);
            this.cmd = cmd;
        }

        public boolean callFieldCommandListener(Command cmd) {
            if (UIField.this._listener != null) {
                return UIField.this._listener.commandAction(cmd, UIField.this);
            }
            return false;
        }

        public UIField getParent() {
            return UIField.this;
        }

        Command getBaseCommand() {
            return this.cmd;
        }

        public boolean isEnabled() {
            return super.isEnabled() && this.cmd.isEnabled();
        }
    }
}

