/*
 * Decompiled with CFR 0.152.
 */
package com.whatsapp.api.ui;

import com.whatsapp.api.ui.UIField;
import com.whatsapp.api.util.DateTimeUtilities;
import com.whatsapp.client.FunXMPP;
import javax.microedition.lcdui.Font;
import javax.microedition.lcdui.Graphics;

public class TimeBubbleField
extends UIField {
    private FunXMPP.FMessage _fmsg;
    private String _curFormattedTime = null;
    private long _timestamp;
    private int hPadding = 20;
    private static final Font clockFont = Font.getFont((int)0, (int)2, (int)8);
    private static final int fontHeight = clockFont.getHeight();

    public TimeBubbleField(FunXMPP.FMessage fmsg) {
        super(0L);
        this._fmsg = fmsg;
    }

    public void setTime(long newTime) {
        this._timestamp = newTime;
        this._curFormattedTime = null;
    }

    public void layout(int width, int height) {
        long now = System.currentTimeMillis();
        if (this._curFormattedTime != null) {
            return;
        }
        long stamp = this._fmsg != null ? this._fmsg.timestamp : this._timestamp;
        this._curFormattedTime = DateTimeUtilities.isSameDate(now, stamp) ? DateTimeUtilities.shortTimeFormat(stamp) : (now - stamp > 31536000000L ? DateTimeUtilities.dayOfYear(stamp) + " " + DateTimeUtilities.shortTimeFormat(stamp) : DateTimeUtilities.simpleDayFormat(stamp) + " " + DateTimeUtilities.shortTimeFormat(stamp));
        int neededWidth = clockFont.stringWidth(this._curFormattedTime) + this.hPadding * 2;
        int neededHeight = fontHeight;
        this.setExtent(neededWidth, neededHeight);
    }

    public void paint(Graphics g, int x, int y, int width, int height) {
        g.setColor(0x808080);
        Font origFont = g.getFont();
        g.setFont(clockFont);
        g.drawString(this._curFormattedTime, x + this.hPadding, y, 0);
        g.setFont(origFont);
    }
}

