/*
 * Decompiled with CFR 0.152.
 */
package com.whatsapp.api.ui;

import com.nokia.mid.ui.DirectUtils;
import com.whatsapp.api.ui.UIOverlay;
import com.whatsapp.client.ChatsListItem;
import java.util.Timer;
import java.util.TimerTask;
import javax.microedition.lcdui.Canvas;
import javax.microedition.lcdui.Font;
import javax.microedition.lcdui.Graphics;

public class SpinnerDialog
implements UIOverlay {
    private static final int HPADDING = 20;
    private static final int VPADDING = 20;
    private static final int SPRITE_STATES = 5;
    private static final int SPRITE_HEIGHT = 30;
    private static final int SPRITE_WIDTH = 100;
    private static final int SPRITE_BOX_MARGIN = 3;
    private static final int SPRITE_PERIOD = 350;
    private static final Font FONT = ChatsListItem.smallFont;
    public static final int COLOR_BEHIND = 0x60000000;
    public static final int COLOR_BACKGROUND = 0xFFFFFF;
    public static final int COLOR_BORDER = 0;
    public static final int COLOR_TEXT = 0;
    public static final int COLOR_SPRITE_BOX_ON = 0x99CCFF;
    public static final int COLOR_SPRITE_BOX_OFF = 255;
    private final Canvas _parent;
    private final Timer timer = new Timer();
    private final TimerTask timerTask = new TimerTask(){

        public void run() {
            SpinnerDialog.this._state = (SpinnerDialog.this._state + 1) % 5;
            SpinnerDialog.this._parent.repaint();
        }
    };
    private final boolean _hideBehind;
    private final String _message;
    private int _state = 0;

    public SpinnerDialog(Canvas parent, String message, boolean hideBehind) {
        this._parent = parent;
        this._message = message;
        this._hideBehind = hideBehind;
    }

    public void start() {
        this.timer.scheduleAtFixedRate(this.timerTask, 350L, 350L);
    }

    public void stop() {
        this.timerTask.cancel();
    }

    public void layoutOverlay(int width, int height) {
    }

    public void paintOverlay(Graphics g, int x, int y, int width, int height) {
        int bottomPadding = Math.max(20, 3);
        int dialogWidth = Math.max(FONT.stringWidth(this._message) + 40, 100 + 2 * Math.max(20, 3));
        int dialogHeight = 20 + FONT.getHeight() + 3 + 30 + bottomPadding;
        int dialogX = x + width / 2 - dialogWidth / 2;
        int dialogY = y + height / 2 - dialogHeight / 2;
        if (this._hideBehind) {
            g.setColor(0xFFFFFF);
            g.fillRect(x, y, width, height);
        } else {
            DirectUtils.getDirectGraphics((Graphics)g).setARGBColor(0x60000000);
            g.fillRect(x, y, width, height);
            g.setColor(0xFFFFFF);
            g.fillRect(dialogX, dialogY, dialogWidth, dialogHeight);
            g.setColor(0);
            g.drawRect(dialogX, dialogY, dialogWidth - 1, dialogHeight - 1);
        }
        g.setFont(FONT);
        g.setColor(0);
        g.drawString(this._message, x + width / 2, dialogY + 20, 17);
        int boxWidth = 17;
        int spriteStart = dialogX + dialogWidth / 2 - 50;
        int spriteY = dialogY + dialogHeight - bottomPadding - 30;
        for (int i = 0; i < 5; ++i) {
            if (i == this._state) {
                g.setColor(0x99CCFF);
            } else {
                g.setColor(255);
            }
            g.fillRect(spriteStart + i * 100 / 5, spriteY, boxWidth, 30);
        }
    }
}

