/*
 * Decompiled with CFR 0.152.
 */
package com.whatsapp.api.ui;

import com.nokia.mid.ui.CanvasGraphicsItem;
import com.whatsapp.api.ui.Command;
import com.whatsapp.api.ui.CommandBarField;
import com.whatsapp.api.ui.CommandMenuField;
import com.whatsapp.api.ui.FieldManager;
import com.whatsapp.api.ui.UIField;
import java.util.Vector;
import javax.microedition.lcdui.Canvas;
import javax.microedition.lcdui.Graphics;

public class MenuCommand
extends Command {
    private static final int SUBMENU_HOFFSET = -10;
    private static final int SUBMENU_VOFFSET = 0;
    private static final int MENU_MIN_WIDTH = 70;
    private static final int SHADOW_WIDTH = 2;
    private static final int SHADOW_OFFSET = 2;
    public static final int COLOR_BACKGROUND = 0xE8E8E8;
    public static final int COLOR_BACKGROUND_FOCUSED = 8959184;
    public static final int COLOR_FOREGROUND = 0;
    public static final int COLOR_FOREGROUND_FOCUSED = 0;
    public static final int COLOR_FIELD_BORDER = 0xF8FCF8;
    public static final int COLOR_BORDER = 0;
    public static final int COLOR_SHADOW = 0;
    final Vector cmdList = new Vector(0);
    private final FieldManager menuVFM = new FieldManager(0L, true);
    private CanvasGraphicsItem menuCGI = null;
    private int width;
    private int height;
    private int z = -1;
    private CommandBarField parentCmdBar = null;
    private Canvas parent = null;
    private Command submenu = null;
    private int submenuYOffset;

    public MenuCommand(javax.microedition.lcdui.Command cmd) {
        super(cmd);
    }

    public MenuCommand(String label, Command.Type type, int prio) {
        super(label, type, prio);
    }

    public MenuCommand(String label, String longLabel, Command.Type type, int prio) {
        super(label, longLabel, type, prio);
    }

    void setParentCommandBar(CommandBarField parentCmdBar) {
        this.parentCmdBar = parentCmdBar;
        for (int i = 0; i < this.cmdList.size(); ++i) {
            Command cmd = (Command)this.cmdList.elementAt(i);
            if (!(cmd.getBaseCommand() instanceof MenuCommand)) continue;
            ((MenuCommand)cmd.getBaseCommand()).setParentCommandBar(parentCmdBar);
        }
    }

    void setParent(Canvas parent) {
        this.parent = parent;
        if (this.menuCGI != null) {
            this.menuCGI.setParent((Object)parent);
        }
        for (int i = 0; i < this.cmdList.size(); ++i) {
            Command cmd = (Command)this.cmdList.elementAt(i);
            if (!(cmd.getBaseCommand() instanceof MenuCommand)) continue;
            ((MenuCommand)cmd.getBaseCommand()).setParent(parent);
        }
    }

    private void setZPosition(int z) {
        this.z = z;
        if (this.menuCGI != null) {
            this.menuCGI.setZPosition(z);
        }
        for (int i = 0; i < this.cmdList.size(); ++i) {
            Command cmd = (Command)this.cmdList.elementAt(i);
            if (!(cmd.getBaseCommand() instanceof MenuCommand)) continue;
            ((MenuCommand)cmd.getBaseCommand()).setZPosition(z + 1);
        }
    }

    public void addCommand(Command cmd) {
        this.insertCommandAt(cmd, this.cmdList.size());
    }

    void insertCommandAt(Command cmd, int i) {
        if (cmd.getBaseCommand() instanceof MenuCommand) {
            MenuCommand menuCmd = (MenuCommand)cmd.getBaseCommand();
            menuCmd.setParent(this.parent);
            menuCmd.setParentCommandBar(this.parentCmdBar);
            if (this.z >= 0) {
                menuCmd.setZPosition(this.z + 1);
            }
        }
        this.cmdList.insertElementAt(cmd, i);
        this.menuVFM.insertAt(new CommandMenuField(cmd), i);
        this.layout(this.width, this.height);
    }

    public boolean removeCommand(Command cmd) {
        int idx = this.cmdList.indexOf(cmd);
        if (idx != -1) {
            this.removeCommandAt(idx);
            return true;
        }
        return false;
    }

    void removeCommandAt(int idx) {
        this.cmdList.removeElementAt(idx);
        this.menuVFM.removeAt(idx);
        this.layout(this.width, this.height);
    }

    private MenuCommand getSubmenu() {
        return (MenuCommand)this.submenu.getBaseCommand();
    }

    boolean show() {
        if (!this.menuVFM.traverse(0)) {
            return false;
        }
        if (this.submenu != null && !this.getSubmenu().show()) {
            this.submenu = null;
        }
        return true;
    }

    void hide() {
        this.menuVFM.traverseOut(false);
        if (this.menuCGI != null) {
            this.menuCGI.setVisible(false);
        }
        if (this.submenu != null) {
            this.getSubmenu().hide();
            this.submenu = null;
        }
    }

    void layout(int width, int height) {
        this.width = width;
        this.height = height;
        for (int i = 0; i < this.menuVFM.size(); ++i) {
            ((CommandMenuField)this.menuVFM.elementAt((int)i)).shortcut = MenuCommand.getShortcutCharacter(i);
        }
        this.menuVFM.layout(width, height);
        width -= this.menuVFM.getWidth();
        if (this.submenu != null) {
            this.getSubmenu().layout(width - -10, height);
        }
    }

    private void repaint() {
        if (this.parent != null) {
            this.parent.repaint();
        }
    }

    void paint(Graphics g, int x, int centerY, int width, int height) {
        int menuWidth = this.menuVFM.getWidth();
        int menuHeight = this.menuVFM.getHeight();
        int cgiWidth = Math.min(menuWidth, width);
        int cgiHeight = Math.min(menuHeight, height);
        int menuX = x;
        int menuY = centerY - menuHeight / 2 + 0;
        if (menuY + menuHeight > height) {
            menuY = height - menuHeight;
        }
        if (this.parent != null) {
            if (this.menuCGI == null || this.menuCGI.getWidth() != cgiWidth || this.menuCGI.getHeight() != cgiHeight) {
                this.cgiCreate(cgiWidth, cgiHeight);
            }
            if (this.menuCGI != null) {
                this.menuCGI.setPosition(menuX, menuY);
                this.menuCGI.setVisible(true);
            }
        }
        x += menuWidth;
        width -= menuWidth;
        if (this.submenu != null) {
            this.getSubmenu().paint(g, x + -10, menuY + this.submenuYOffset, width - -10, height);
        }
    }

    private void cgiPaint(Graphics g, int width, int height) {
        g.setColor(0xE8E8E8);
        g.fillRect(0, 0, width, height);
        this.menuVFM.paint(g, 0, 0, width, height);
        g.setColor(0);
        g.drawRect(0, 0, width - 1, height - 1);
    }

    private void cgiRepaint() {
        if (this.menuCGI != null) {
            this.menuCGI.repaint();
        }
    }

    private void cgiCreate(final int width, final int height) {
        if (this.menuCGI != null) {
            this.menuCGI.setVisible(false);
            this.menuCGI.setParent(null);
            this.menuCGI = null;
        }
        if (width <= 0 || height <= 0) {
            return;
        }
        this.menuCGI = new CanvasGraphicsItem(width, height){
            {
                this.setParent(MenuCommand.this.parent);
            }

            public void paint(Graphics g) {
                MenuCommand.this.cgiPaint(g, width, height);
            }
        };
        if (this.z < 0) {
            this.z = this.menuCGI.getZPosition();
        }
        this.setZPosition(this.z);
    }

    boolean keyPressed(Command thisCmd, int keycode) {
        if (this.submenu == null || !this.getSubmenu().keyPressed(this.submenu, keycode)) {
            switch (keycode) {
                case -2: {
                    if (!this.menuVFM.traverse(6) && !this.menuVFM.traverse(1)) {
                        return false;
                    }
                    this.cgiRepaint();
                    return true;
                }
                case -1: {
                    if (!this.menuVFM.traverse(1) && !this.menuVFM.traverse(6)) {
                        return false;
                    }
                    this.cgiRepaint();
                    return true;
                }
                case -5: 
                case -4: {
                    UIField field = this.menuVFM.getFocus();
                    if (field == null) break;
                    this.fieldAction(thisCmd, field, keycode == -5);
                    return true;
                }
                case -3: {
                    if (this.submenu == null) break;
                    this.getSubmenu().hide();
                    this.submenu = null;
                    return true;
                }
                default: {
                    int shortcut = MenuCommand.getShortcutIndex(keycode);
                    if (shortcut >= 0 && shortcut < this.menuVFM.size()) {
                        this.menuVFM.moveFocus(this.menuVFM.elementAt(shortcut));
                        this.cgiRepaint();
                        this.fieldAction(thisCmd, this.menuVFM.getFocus(), true);
                        return true;
                    }
                    if (shortcut == -1) break;
                    return true;
                }
            }
            return false;
        }
        return true;
    }

    private void fieldAction(Command thisCmd, UIField field, boolean doCommands) {
        Command cmd = ((CommandMenuField)field).cmd;
        boolean isMenuCommand = cmd.getBaseCommand() instanceof MenuCommand;
        if (!cmd.isEnabled()) {
            return;
        }
        if (isMenuCommand) {
            this.submenu = cmd;
            if (this.getSubmenu().show()) {
                this.submenuYOffset = field.getManagerY() + field.getHeight() / 2;
                this.getSubmenu().layout(this.width, this.height);
                this.repaint();
            } else {
                this.submenu = null;
            }
        }
        if ((isMenuCommand || doCommands) && this.parent != null) {
            boolean ret = false;
            if (thisCmd instanceof UIField.FieldCommand && ((UIField.FieldCommand)thisCmd).callFieldCommandListener(cmd.getBaseCommand())) {
                ret = true;
            }
            if (this.parentCmdBar.callCommandListener(cmd)) {
                ret = true;
            }
            if (ret) {
                this.parentCmdBar.hideMenu();
            }
        }
    }

    private static int getShortcutIndex(int keycode) {
        if (keycode >= 48 && keycode <= 57) {
            return keycode - 48;
        }
        switch (keycode) {
            case 77: 
            case 109: {
                return 0;
            }
            case 82: 
            case 114: {
                return 1;
            }
            case 84: 
            case 116: {
                return 2;
            }
            case 89: 
            case 121: {
                return 3;
            }
            case 70: 
            case 102: {
                return 4;
            }
            case 71: 
            case 103: {
                return 5;
            }
            case 72: 
            case 104: {
                return 6;
            }
            case 86: 
            case 118: {
                return 7;
            }
            case 66: 
            case 98: {
                return 8;
            }
            case 78: 
            case 110: {
                return 9;
            }
            case 42: 
            case 85: 
            case 117: {
                return 10;
            }
            case 35: 
            case 74: 
            case 106: {
                return 11;
            }
        }
        return -1;
    }

    private static Character getShortcutCharacter(int index) {
        if (index <= 9) {
            return new Character((char)(index + 48));
        }
        switch (index) {
            case 10: {
                return new Character('*');
            }
            case 11: {
                return new Character('#');
            }
        }
        return null;
    }
}

