/*
 * Decompiled with CFR 0.152.
 */
package com.whatsapp.api.ui;

import com.whatsapp.api.ui.Rect;
import com.whatsapp.api.ui.UIField;
import com.whatsapp.api.util.Utilities;
import java.util.Vector;
import javax.microedition.lcdui.Graphics;

public class ListField
extends UIField {
    int _focusedUIRow = 0;
    int _focusedLogicalRow = 0;
    boolean _topFrag = false;
    public Container _parentScr;

    public ListField(Container container) {
        super(3L);
        this._parentScr = container;
    }

    public void layout(int width, int height) {
        int givenHeight = this._parentScr.getHeightForList();
        this.setExtent(width, givenHeight != -1 ? givenHeight : height);
    }

    public void paint(Graphics g, int x, int y, int width, int height) {
        int totalItems;
        int rowHeight = this._parentScr.getRowHeight();
        int viewableRows = height / rowHeight;
        if (height % rowHeight > 0) {
            ++viewableRows;
        }
        int lastIndex = viewableRows - 1;
        if (this._focusedUIRow >= viewableRows) {
            this._focusedUIRow = lastIndex;
        }
        if ((totalItems = this._parentScr.getNumListItems()) > 0) {
            if (this._focusedUIRow >= totalItems) {
                this._focusedUIRow = totalItems - 1;
            }
            if (this._focusedLogicalRow >= totalItems) {
                this._focusedLogicalRow = totalItems - 1;
            }
        }
        if (this._focusedUIRow == 0) {
            this._topFrag = false;
        }
        Rect clip = new Rect(g.getClipX(), g.getClipY(), g.getClipWidth(), g.getClipHeight());
        g.clipRect(x, y, width, height);
        Vector items = this._parentScr.getListItems(this._focusedLogicalRow - this._focusedUIRow, viewableRows);
        totalItems = this._parentScr.getNumListItems();
        if (this._focusedUIRow == lastIndex) {
            this._topFrag = true;
        }
        for (int i = 0; i < viewableRows && i < items.size(); ++i) {
            Item curItem = (Item)items.elementAt(i);
            int rowY = this._topFrag ? y + height - (viewableRows - i) * rowHeight : y + i * rowHeight;
            curItem.paintListRow(g, x, rowY, width, rowHeight, this.hasFocus() && this._focusedUIRow == i);
        }
        if (this.getStyleBit(2L)) {
            int[] yPts;
            if (this._focusedLogicalRow - this._focusedUIRow > 0) {
                g.setColor(255);
                int[] xPts = new int[]{x + width - 5, x + width, x + width - 10};
                yPts = new int[]{y, y + 10, y + 10};
                g.fillTriangle(xPts[0], yPts[0], xPts[1], yPts[1], xPts[2], yPts[2]);
            }
            if (this._focusedLogicalRow - this._focusedUIRow + viewableRows < totalItems) {
                g.setColor(255);
                int[] xPts = new int[]{x + width - 5, x + width, x + width - 10};
                yPts = new int[]{y + height, y + height - 10, y + height - 10};
                g.fillTriangle(xPts[0], yPts[0], xPts[1], yPts[1], xPts[2], yPts[2]);
            }
        }
        g.setClip(clip.x, clip.y, clip.width, clip.height);
    }

    public boolean traverse(int dir) {
        int rowHeight = this._parentScr.getRowHeight();
        int viewableRows = this.getHeight() / rowHeight;
        if (this.getHeight() % rowHeight > 0) {
            ++viewableRows;
        }
        int totalItems = this._parentScr.getNumListItems();
        if (!this.hasFocus()) {
            if (dir == 1) {
                int focusJump = viewableRows - 1 - this._focusedUIRow;
                this._focusedLogicalRow += focusJump;
                this._focusedUIRow = this._focusedLogicalRow >= totalItems ? (this._focusedLogicalRow = totalItems - 1) : (this._focusedUIRow += focusJump);
                Utilities.logData("entered ListFld from below, ui/logical focus " + this._focusedUIRow + "/" + this._focusedLogicalRow);
            } else if (dir == 6) {
                this._focusedLogicalRow -= this._focusedUIRow;
                this._focusedUIRow = 0;
            } else {
                if (this._focusedLogicalRow == totalItems - 1) {
                    this._focusedUIRow = viewableRows - 1;
                }
                if (this._focusedUIRow >= totalItems) {
                    this._focusedUIRow = this._focusedLogicalRow;
                }
            }
            this.setFocus(true);
        } else if (dir == 1) {
            --this._focusedLogicalRow;
            if (this._focusedLogicalRow < 0) {
                this._focusedLogicalRow = 0;
                if (!this._parentScr.shouldListKeepFocus(1)) {
                    this.setFocus(false);
                    return false;
                }
            } else {
                --this._focusedUIRow;
            }
        } else if (dir == 6) {
            ++this._focusedLogicalRow;
            if (this._focusedLogicalRow >= totalItems) {
                --this._focusedLogicalRow;
                if (!this._parentScr.shouldListKeepFocus(6)) {
                    this.setFocus(false);
                    return false;
                }
            } else {
                ++this._focusedUIRow;
                if (this._focusedUIRow >= viewableRows) {
                    --this._focusedUIRow;
                }
                if (this._focusedUIRow == viewableRows - 1) {
                    this.getManager().snapToMe(this);
                }
            }
        } else if (dir == 0 && this._focusedLogicalRow >= totalItems) {
            this._focusedLogicalRow = totalItems - 1;
            this._focusedUIRow = viewableRows - 1;
        }
        if (this._focusedUIRow < 0) {
            this._focusedUIRow = 0;
        }
        if (this._focusedLogicalRow < 0) {
            this._focusedLogicalRow = 0;
        }
        return true;
    }

    public int getFocusedUIRow() {
        return this._focusedUIRow;
    }

    public int getFocusedLogicalRow() {
        return this._focusedLogicalRow;
    }

    public void jumpToTop() {
        this._focusedLogicalRow = 0;
        this._focusedUIRow = 0;
    }

    public void pageMove(int pages) {
        int rowHeight = this._parentScr.getRowHeight();
        int viewableRows = (this.getHeight() - 1) / rowHeight;
        int newLogicalRow = this._focusedLogicalRow + viewableRows * pages;
        int newUIRow = this._focusedUIRow;
        if (newLogicalRow < 0) {
            newLogicalRow = 0;
            newUIRow = 0;
        } else if (newLogicalRow + (viewableRows - this._focusedUIRow) >= this._parentScr.getNumListItems()) {
            newLogicalRow = this._parentScr.getNumListItems() - 1;
            newUIRow = Math.min(viewableRows, newLogicalRow);
        }
        this._focusedLogicalRow = newLogicalRow;
        this._focusedUIRow = newUIRow;
    }

    public static interface Item {
        public void paintListRow(Graphics var1, int var2, int var3, int var4, int var5, boolean var6);
    }

    public static interface Container {
        public int getHeightForList();

        public int getRowHeight();

        public int getNumListItems();

        public Vector getListItems(int var1, int var2);

        public boolean shouldListKeepFocus(int var1);
    }
}

