/*
 * Decompiled with CFR 0.152.
 */
package com.whatsapp.api.ui;

import com.nokia.mid.ui.DirectUtils;
import com.nokia.mid.ui.TextEditor;
import com.nokia.mid.ui.TextEditorListener;
import com.whatsapp.api.ui.Command;
import com.whatsapp.api.ui.MenuCommand;
import com.whatsapp.api.ui.S40TextEditor;
import com.whatsapp.api.ui.UIField;
import com.whatsapp.api.ui.UIOverlay;
import com.whatsapp.api.util.Utilities;
import javax.microedition.lcdui.Canvas;
import javax.microedition.lcdui.Font;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;

public class InputEditorField
extends UIField
implements UIOverlay,
TextEditorListener,
Command.Listener {
    private static final int UNFOCUSED_BORDER_WIDTH = 1;
    private static final int FOCUSED_BORDER_WIDTH = 2;
    private static final int UNFOCUSED_BORDER_COLOR = 0x808080;
    private static final int FOCUSED_BORDER_COLOR = 9484496;
    private static final int BACKGROUND_COLOR = 0xFFFFFF;
    private static final int TEXT_COLOR = 0;
    private static final int H_MARGIN_DEFAULT = 4;
    private static final int INDICATORS_BACKGROUND_COLOR = -2004318072;
    private static final int INDICATORS_TOP_PADDING = 0;
    private static final int INDICATORS_RIGHT_PADDING = 2;
    private static final int INDICATORS_BOTTOM_PADDING = -1;
    private static final int INDICATORS_LEFT_PADDING = 0;
    private final int width;
    private final int minEditorHeight;
    private final int maxEditorHeight;
    private int layoutWidth;
    private int layoutHeight;
    private boolean visible = false;
    private boolean focusPaused = false;
    public final S40TextEditor s40Editor;
    public final TextEditor editor;
    private Image[] indicators = null;
    private Command[] commands = null;
    private MenuCommand commandMenu = new MenuCommand("Editor Options", Command.EDITOR_OPT, 0);
    private int indicatorsHeight;
    private int indicatorsWidth;
    private Listener listener = null;

    public InputEditorField(Canvas parent, Font font, int maxSize, int constraints, int width, int minRows, int maxRows) {
        super(1L);
        this.editor = TextEditor.createTextEditor((int)maxSize, (int)constraints, (int)1, (int)1);
        this.editor.setParent((Object)parent);
        this.editor.setTextEditorListener((TextEditorListener)this);
        this.setFieldCommandListener(this);
        this.editor.setBackgroundColor(0);
        this.editor.setForegroundColor(-16777216);
        this.editor.setMultiline(minRows > 1 || maxRows > 1);
        if (font != null) {
            this.editor.setFont(font);
        }
        S40TextEditor s40Editor = null;
        String className = null;
        String nokiaUIVersion = System.getProperty("com.nokia.mid.ui.version");
        try {
            Class.forName("com.nokia.mid.ui.s40.TextEditor");
            className = "com.whatsapp.api.ui.S40TextEditorV6Impl";
        }
        catch (ClassNotFoundException ex) {
            // empty catch block
        }
        try {
            Class.forName("com.nokia.mid.ui.S40TextEditor");
            className = "com.whatsapp.api.ui.S40TextEditorV6FP1Impl";
        }
        catch (ClassNotFoundException ex) {
            // empty catch block
        }
        if (className != null) {
            try {
                s40Editor = (S40TextEditor)Class.forName(className).newInstance();
                if (!s40Editor.setEditor(this.editor)) {
                    s40Editor = null;
                }
            }
            catch (Throwable t) {
                // empty catch block
            }
        }
        this.s40Editor = s40Editor;
        if (s40Editor != null) {
            s40Editor.setCursorWrap(s40Editor.getConstant(6));
        }
        this.width = width;
        int lineHeight = this.editor.getContentHeight();
        this.minEditorHeight = minRows * lineHeight;
        this.maxEditorHeight = maxRows * lineHeight;
        this.setMargin(0, 4, 0, 4);
    }

    public void setListener(Listener listener) {
        this.listener = listener;
    }

    public void setFocus(boolean focus) {
        if (this.editor.isVisible() && !this.focusPaused) {
            this.editor.setFocus(focus);
        }
        super.setFocus(focus);
    }

    public void setVisible(boolean visible) {
        this.visible = visible;
        if (this.s40Editor != null && visible && this.focusPaused) {
            this.s40Editor.setVisible(this.s40Editor.getConstant(16));
            return;
        }
        this.editor.setVisible(visible);
    }

    public void pauseFocus() {
        this.focusPaused = true;
        if (this.s40Editor != null) {
            this.setVisible(this.visible);
        } else {
            this.editor.setFocus(false);
        }
    }

    public void resumeFocus() {
        this.focusPaused = false;
        if (this.s40Editor != null) {
            this.setVisible(this.visible);
        } else {
            this.editor.setFocus(this.hasFocus());
        }
    }

    public void inputAction(TextEditor editor, int actions) {
        if ((actions & 2) != 0) {
            this.onOptionsChanged();
        }
        if ((actions & 0x80) != 0) {
            this.onInputModeChanged();
        }
        if (this.s40Editor != null && (actions & this.s40Editor.getConstant(9)) != 0) {
            this.closeFieldCommandBar();
        }
        if (this.listener != null) {
            this.listener.inputAction(this, actions);
        }
    }

    private void onInputModeChanged() {
        if (this.s40Editor != null) {
            this.indicators = this.s40Editor.getIndicatorIcons();
            if (this.indicators != null && this.indicators.length == 0) {
                this.indicators = null;
            }
        }
        if (this.indicators != null) {
            this.indicatorsHeight = 0;
            this.indicatorsWidth = 2;
            for (int i = 0; i < this.indicators.length; ++i) {
                this.indicatorsHeight = Math.max(this.indicators[i].getHeight() + -1 + 0, this.indicatorsHeight);
                this.indicatorsWidth += this.indicators[i].getWidth();
            }
        }
    }

    protected Command.Type convertCommandType(int commandType) {
        if (this.s40Editor != null) {
            if (commandType == this.s40Editor.getConstant(3)) {
                return Command.EDITOR_LSK;
            }
            if (commandType == this.s40Editor.getConstant(1)) {
                return Command.EDITOR_RSK;
            }
            if (commandType == this.s40Editor.getConstant(0)) {
                return Command.EDITOR_MSK;
            }
            if (commandType == this.s40Editor.getConstant(2)) {
                return Command.EDITOR_OPT;
            }
        }
        throw new IllegalArgumentException("ui/input-editor-field/command-type/" + commandType + "/cannot-convert");
    }

    private void onOptionsChanged() {
        int i;
        if (this.commands != null) {
            for (i = 0; i < this.commands.length; ++i) {
                if (this.commands[i].commandType == Command.EDITOR_OPT) {
                    this.commandMenu.removeCommand(this.commands[i]);
                    continue;
                }
                this.removeFieldCommand(this.commands[i]);
            }
        }
        if (this.s40Editor != null) {
            javax.microedition.lcdui.Command[] commands = this.s40Editor.getTextEditorCommands();
            if (commands != null) {
                this.commands = new Command[commands.length];
                for (int i2 = 0; i2 < commands.length; ++i2) {
                    this.commands[i2] = this.s40Editor.isMenuCommand(commands[i2]) ? new TextEditorMenuCommand(commands[i2]) : new TextEditorCommand(commands[i2]);
                }
            } else {
                this.commands = null;
            }
        }
        if (this.commands != null) {
            for (i = 0; i < this.commands.length; ++i) {
                if (this.commands[i].commandType == Command.EDITOR_OPT) {
                    this.commandMenu.addCommand(this.commands[i]);
                    continue;
                }
                this.addFieldCommand(this.commands[i]);
            }
            this.addFieldCommand(this.commandMenu);
        } else {
            this.removeFieldCommand(this.commandMenu);
        }
    }

    public boolean commandAction(Command cmd, UIField field) {
        if (this.s40Editor == null) {
            return false;
        }
        if (this.commands != null) {
            for (int i = 0; i < this.commands.length; ++i) {
                if (this.commands[i] != cmd) continue;
                javax.microedition.lcdui.Command origCmd = this.commands[i] instanceof TextEditorCommand ? ((TextEditorCommand)this.commands[i]).origCmd : ((TextEditorMenuCommand)this.commands[i]).origCmd;
                if (this.s40Editor.isCommandKeyWanted(origCmd)) {
                    this.s40Editor.launchTextEditorCommand(origCmd, this.s40Editor.getConstant(19));
                    this.s40Editor.launchTextEditorCommand(origCmd, this.s40Editor.getConstant(20));
                } else {
                    this.s40Editor.launchTextEditorCommand(origCmd, this.s40Editor.getConstant(18));
                }
                return false;
            }
            Utilities.logData("ui/editor/cmd/" + cmd.label + "/not-handled");
        }
        return false;
    }

    private int calculateHeight() {
        return Math.min(this.layoutHeight, Math.min(this.maxEditorHeight, Math.max(this.minEditorHeight, this.editor.getContentHeight())) + 2 * Math.max(2, 1));
    }

    public boolean needsLayout() {
        return this.calculateHeight() != this.getHeight();
    }

    public void layout(int width, int height) {
        this.layoutWidth = width;
        this.layoutHeight = height;
        if (this.width >= 0) {
            width = Math.min(width, this.width);
        }
        this.setExtent(width, this.calculateHeight());
    }

    public void paint(Graphics g, int x, int y, int width, int height) {
        int borderWidth;
        width = Math.min(this.getWidth(), width);
        height = Math.min(this.getHeight(), height);
        int n = borderWidth = this.hasFocus() ? 2 : 1;
        if (width <= borderWidth * 2 || height <= borderWidth * 2) {
            this.setVisible(false);
            return;
        }
        int editorX = x + borderWidth;
        int editorY = y + borderWidth;
        int editorWidth = width - 2 * borderWidth;
        int editorHeight = height - 2 * borderWidth;
        this.setVisible(true);
        if (!this.focusPaused) {
            this.editor.setFocus(this.hasFocus());
        }
        this.editor.setSize(editorWidth, editorHeight);
        this.editor.setPosition(editorX, editorY);
        g.setColor(0xFFFFFF);
        g.fillRect(editorX, editorY, editorWidth, editorHeight);
        g.setColor(this.hasFocus() ? 9484496 : 0x808080);
        g.setStrokeStyle(0);
        for (int i = 0; i < borderWidth; ++i) {
            g.drawRect(x + i, y + i, width - 1 - 2 * i, height - 1 - 2 * i);
        }
    }

    public void layoutOverlay(int width, int height) {
    }

    public void paintOverlay(Graphics g, int x, int y, int width, int height) {
        if (this.indicators == null) {
            return;
        }
        int right = this.getAbsoluteX() + this.getWidth();
        int bottom = this.getAbsoluteY();
        DirectUtils.getDirectGraphics((Graphics)g).setARGBColor(-2004318072);
        g.fillRect(right - this.indicatorsWidth, bottom - this.indicatorsHeight, this.indicatorsWidth, this.indicatorsHeight);
        int indicatorX = right - 2;
        int indicatorsY = bottom - -1;
        for (int i = this.indicators.length - 1; i >= 0; --i) {
            g.drawImage(this.indicators[i], indicatorX, indicatorsY, 40);
            indicatorX -= this.indicators[i].getWidth();
        }
    }

    private class TextEditorMenuCommand
    extends MenuCommand {
        private final javax.microedition.lcdui.Command origCmd;

        public TextEditorMenuCommand(javax.microedition.lcdui.Command cmd) {
            super(cmd.getLabel(), cmd.getLongLabel(), InputEditorField.this.convertCommandType(cmd.getCommandType()), cmd.getPriority());
            this.origCmd = cmd;
        }
    }

    private class TextEditorCommand
    extends Command {
        private final javax.microedition.lcdui.Command origCmd;

        public TextEditorCommand(javax.microedition.lcdui.Command cmd) {
            super(cmd.getLabel(), cmd.getLongLabel(), InputEditorField.this.convertCommandType(cmd.getCommandType()), cmd.getPriority());
            this.origCmd = cmd;
        }
    }

    public static interface Listener {
        public void inputAction(InputEditorField var1, int var2);
    }
}

